/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.support;

import java.net.ProxySelector;
import java.security.GeneralSecurityException;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.SystemDefaultCredentialsProvider;
import org.apache.http.impl.conn.DefaultRoutePlanner;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.springframework.cloud.config.server.proxy.ProxyHostProperties;
import org.springframework.cloud.config.server.support.HttpEnvironmentRepositoryProperties;
import org.springframework.util.CollectionUtils;

public final class HttpClient4Support {
    private HttpClient4Support() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    public static HttpClientBuilder builder(HttpEnvironmentRepositoryProperties environmentProperties) throws GeneralSecurityException {
        SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        if (environmentProperties.isSkipSslValidation()) {
            sslContextBuilder.loadTrustMaterial(null, (certificate, authType) -> true);
            httpClientBuilder.setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier());
        }
        if (!CollectionUtils.isEmpty(environmentProperties.getProxy())) {
            ProxyHostProperties httpsProxy = environmentProperties.getProxy().get((Object)ProxyHostProperties.ProxyForScheme.HTTPS);
            ProxyHostProperties httpProxy = environmentProperties.getProxy().get((Object)ProxyHostProperties.ProxyForScheme.HTTP);
            httpClientBuilder.setRoutePlanner((HttpRoutePlanner)new SchemeBasedRoutePlanner4(httpsProxy, httpProxy));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)new ProxyHostCredentialsProvider4(httpProxy, httpsProxy));
        } else {
            httpClientBuilder.setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(ProxySelector.getDefault()));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)new SystemDefaultCredentialsProvider());
        }
        httpClientBuilder.disableRedirectHandling();
        int timeout = environmentProperties.getTimeout() * 1000;
        return httpClientBuilder.setSSLContext(sslContextBuilder.build()).setDefaultRequestConfig(RequestConfig.custom().setSocketTimeout(timeout).setConnectTimeout(timeout).build());
    }

    static class SchemeBasedRoutePlanner4
    extends DefaultRoutePlanner {
        private final HttpHost httpsProxy;
        private final HttpHost defaultSchemeProxy;

        SchemeBasedRoutePlanner4(ProxyHostProperties httpsProxy, ProxyHostProperties httpProxy) {
            super(null);
            this.httpsProxy = this.buildProxy(httpsProxy, "https");
            this.defaultSchemeProxy = this.buildProxy(httpProxy, "http");
        }

        protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) {
            return "https".equals(target.getSchemeName()) ? this.determineProxy(this.httpsProxy, this.defaultSchemeProxy) : this.determineProxy(this.defaultSchemeProxy, this.httpsProxy);
        }

        private HttpHost determineProxy(HttpHost proxy, HttpHost fallbackProxy) {
            return proxy != null ? proxy : fallbackProxy;
        }

        private HttpHost buildProxy(ProxyHostProperties properties, String scheme) {
            if (properties == null || !properties.connectionInformationProvided()) {
                return null;
            }
            return new HttpHost(properties.getHost(), properties.getPort(), scheme);
        }
    }

    static class ProxyHostCredentialsProvider4
    extends BasicCredentialsProvider {
        ProxyHostCredentialsProvider4(ProxyHostProperties ... proxyHostProperties) {
            for (ProxyHostProperties proxy : proxyHostProperties) {
                if (proxy == null || !proxy.connectionInformationProvided() || !proxy.authenticationProvided()) continue;
                AuthScope authscope = new AuthScope(proxy.getHost(), proxy.getPort());
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxy.getUsername(), proxy.getPassword());
                this.setCredentials(authscope, (Credentials)credentials);
            }
        }
    }
}

