/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.rpc.message;

import com.caucho.hessian4.io.AbstractSerializerFactory;
import com.caucho.hessian4.io.SerializerFactory;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.io.OutputProducer;
import org.rzo.netty.ahessian.io.OutputStreamHandler;
import org.rzo.netty.ahessian.rpc.io.Hessian2Output;
import org.rzo.netty.ahessian.rpc.message.HessianRPCCallMessage;
import org.rzo.netty.ahessian.session.ClientSessionFilter;

public class HessianRPCCallEncoder
extends OutputProducer {
    SerializerFactory sFactory = new SerializerFactory();
    Hessian2Output hOut = null;
    boolean _hasSessionFilter = false;
    boolean _inverseServer = false;

    public HessianRPCCallEncoder(boolean inverseServer, Executor executor) {
        this(inverseServer, null, executor);
    }

    public HessianRPCCallEncoder(AbstractSerializerFactory serializerFactory, Executor executor) {
        this(false, serializerFactory, executor);
    }

    public HessianRPCCallEncoder(Executor executor) {
        this(false, null, executor);
    }

    public HessianRPCCallEncoder(boolean inverseServer, AbstractSerializerFactory serializerFactory, Executor executor) {
        super(executor);
        if (serializerFactory != null) {
            this.sFactory.addFactory(serializerFactory);
        }
        this._inverseServer = inverseServer;
    }

    @Override
    public void produceOutput(ChannelHandlerContext ctx, Object e, ChannelPromise promise) throws Exception {
        if (!ctx.channel().isActive()) {
            throw new RuntimeException("channel not active");
        }
        try {
            HessianRPCCallMessage message = (HessianRPCCallMessage)e;
            message.setHasSessionFilter(this._hasSessionFilter);
            this.hOut.resetReferences();
            this.hOut.call(message);
            if (this._inverseServer) {
                this.hOut.flush(promise);
            }
        }
        catch (Exception ex) {
            Constants.ahessianLogger.warn("", (Throwable)ex);
            promise.setFailure((Throwable)ex);
        }
    }

    private OutputStream getOutputStream(ChannelHandlerContext ctx) {
        return (OutputStream)ctx.channel().attr(OutputStreamHandler.OUTSTREAM).get();
    }

    @Override
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        super.connect(ctx, remoteAddress, localAddress, promise);
        boolean bl = this._hasSessionFilter = ctx.pipeline().context(ClientSessionFilter.class) != null;
        if (this.hOut == null) {
            OutputStream out = this.getOutputStream(ctx);
            this.hOut = new Hessian2Output(out);
            this.hOut.getSerializerFactory().addFactory((AbstractSerializerFactory)this.sFactory);
        } else {
            this.hOut.reset();
        }
    }

    @Override
    protected void flashOutput(ChannelHandlerContext ctx) throws Exception {
        if (!ctx.channel().isActive()) {
            throw new RuntimeException("channel not active");
        }
        this.hOut.flush();
    }
}

