/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.client;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.retry.annotation.Retryable;

public class ConfigServerInstanceProvider {
    private Log log = LogFactory.getLog(this.getClass());
    private final Function function;

    @Deprecated
    public ConfigServerInstanceProvider(DiscoveryClient client) {
        this.function = arg_0 -> ((DiscoveryClient)client).getInstances(arg_0);
    }

    public ConfigServerInstanceProvider(Function function) {
        this.function = function;
    }

    void setLog(Log log) {
        this.log = log;
    }

    @Retryable(interceptor="configServerRetryInterceptor")
    public List<ServiceInstance> getConfigServerInstances(String serviceId) {
        List<ServiceInstance> instances;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Locating configserver (" + serviceId + ") via discovery"));
        }
        if ((instances = this.function.apply(serviceId)).isEmpty()) {
            throw new IllegalStateException("No instances found of configserver (" + serviceId + ")");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Located configserver (" + serviceId + ") via discovery. No of instances found: " + instances.size()));
        }
        return instances;
    }

    @FunctionalInterface
    public static interface Function {
        public List<ServiceInstance> apply(String var1);
    }
}

