/*
 * Decompiled with CFR 0.152.
 */
package akka.http.scaladsl.model;

import akka.http.impl.model.parser.CharacterClasses$;
import akka.http.impl.model.parser.UriParser;
import akka.http.impl.model.parser.UriParser$;
import akka.http.impl.util.StringRendering;
import akka.http.impl.util.package$;
import akka.http.scaladsl.model.IllegalUriException$;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.model.Uri$Authority$;
import akka.http.scaladsl.model.Uri$Empty$;
import akka.http.scaladsl.model.Uri$Host$;
import akka.http.scaladsl.model.Uri$ParsingMode$Relaxed$;
import akka.http.scaladsl.model.Uri$Path$;
import akka.http.scaladsl.model.Uri$Path$Empty$;
import akka.http.scaladsl.model.UriRendering$;
import akka.parboiled2.CharPredicate;
import akka.parboiled2.CharUtils$;
import akka.parboiled2.ParserInput;
import akka.parboiled2.ParserInput$;
import java.io.Serializable;
import java.nio.charset.Charset;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class Uri$
implements Serializable {
    public static final Uri$ MODULE$ = new Uri$();
    private static final Uri $div = MODULE$.apply("/");
    private static final Map<String, Object> akka$http$scaladsl$model$Uri$$defaultPorts = ((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ftp"), (Object)BoxesRunTime.boxToInteger((int)21)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssh"), (Object)BoxesRunTime.boxToInteger((int)22)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"telnet"), (Object)BoxesRunTime.boxToInteger((int)23)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"smtp"), (Object)BoxesRunTime.boxToInteger((int)25)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"domain"), (Object)BoxesRunTime.boxToInteger((int)53)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tftp"), (Object)BoxesRunTime.boxToInteger((int)69)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"http"), (Object)BoxesRunTime.boxToInteger((int)80)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ws"), (Object)BoxesRunTime.boxToInteger((int)80)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pop3"), (Object)BoxesRunTime.boxToInteger((int)110)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nntp"), (Object)BoxesRunTime.boxToInteger((int)119)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"imap"), (Object)BoxesRunTime.boxToInteger((int)143)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"snmp"), (Object)BoxesRunTime.boxToInteger((int)161)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ldap"), (Object)BoxesRunTime.boxToInteger((int)389)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"https"), (Object)BoxesRunTime.boxToInteger((int)443)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"wss"), (Object)BoxesRunTime.boxToInteger((int)443)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"imaps"), (Object)BoxesRunTime.boxToInteger((int)993)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nfs"), (Object)BoxesRunTime.boxToInteger((int)2049))}))).withDefaultValue((Object)BoxesRunTime.boxToInteger((int)-1));

    public Uri $div() {
        return $div;
    }

    public Uri apply(String input) {
        return this.apply((ParserInput)ParserInput$.MODULE$.apply(input), package$.MODULE$.UTF8(), Uri$ParsingMode$Relaxed$.MODULE$);
    }

    public Uri apply(ParserInput input) {
        return this.apply(input, package$.MODULE$.UTF8(), Uri$ParsingMode$Relaxed$.MODULE$);
    }

    public Uri apply(ParserInput input, Uri.ParsingMode mode) {
        return this.apply(input, package$.MODULE$.UTF8(), mode);
    }

    public Uri apply(ParserInput input, Charset charset, Uri.ParsingMode mode) {
        return new UriParser(input, charset, mode).parseUriReference();
    }

    public Uri apply(String scheme, Uri.Authority authority, Uri.Path path, Option<String> queryString, Option<String> fragment) {
        Uri.Path p = this.verifyPath(path, scheme, authority.host());
        return this.create(this.normalizeScheme(scheme), authority, scheme.isEmpty() ? p : this.collapseDotSegments(p), queryString, fragment);
    }

    public String apply$default$1() {
        return "";
    }

    public Uri.Authority apply$default$2() {
        return Uri$Authority$.MODULE$.Empty();
    }

    public Uri.Path apply$default$3() {
        return Uri$Path$Empty$.MODULE$;
    }

    public Option<String> apply$default$4() {
        return None$.MODULE$;
    }

    public Option<String> apply$default$5() {
        return None$.MODULE$;
    }

    public Uri from(String scheme, String userinfo, String host, int port, String path, Option<String> queryString, Option<String> fragment, Uri.ParsingMode mode) {
        return this.apply(scheme, new Uri.Authority(Uri$Host$.MODULE$.apply(host, package$.MODULE$.UTF8(), mode), this.normalizePort(port, scheme), userinfo), Uri$Path$.MODULE$.apply(path, Uri$Path$.MODULE$.apply$default$2()), queryString, fragment);
    }

    public String from$default$1() {
        return "";
    }

    public String from$default$2() {
        return "";
    }

    public String from$default$3() {
        return "";
    }

    public int from$default$4() {
        return 0;
    }

    public String from$default$5() {
        return "";
    }

    public Option<String> from$default$6() {
        return None$.MODULE$;
    }

    public Option<String> from$default$7() {
        return None$.MODULE$;
    }

    public Uri.ParsingMode from$default$8() {
        return Uri$ParsingMode$Relaxed$.MODULE$;
    }

    public Uri parseAbsolute(ParserInput input, Charset charset, Uri.ParsingMode mode) {
        return new UriParser(input, charset, mode).parseAbsoluteUri();
    }

    public Charset parseAbsolute$default$2() {
        return package$.MODULE$.UTF8();
    }

    public Uri.ParsingMode parseAbsolute$default$3() {
        return Uri$ParsingMode$Relaxed$.MODULE$;
    }

    public Uri parseAndResolve(ParserInput string, Uri base, Charset charset, Uri.ParsingMode mode) {
        return new UriParser(string, charset, mode).parseAndResolveUriReference(base);
    }

    public Charset parseAndResolve$default$3() {
        return package$.MODULE$.UTF8();
    }

    public Uri.ParsingMode parseAndResolve$default$4() {
        return Uri$ParsingMode$Relaxed$.MODULE$;
    }

    public Uri parseHttpRequestTarget(ParserInput requestTarget, Charset charset, Uri.ParsingMode mode) {
        return new UriParser(requestTarget, charset, mode).parseHttpRequestTarget();
    }

    public Charset parseHttpRequestTarget$default$2() {
        return package$.MODULE$.UTF8();
    }

    public Uri.ParsingMode parseHttpRequestTarget$default$3() {
        return Uri$ParsingMode$Relaxed$.MODULE$;
    }

    public Tuple2<Uri.Path, Option<String>> parseHttp2PathPseudoHeader(ParserInput headerValue, Charset charset, Uri.ParsingMode mode) {
        return new UriParser(headerValue, charset, mode).parseHttp2PathPseudoHeader();
    }

    public Charset parseHttp2PathPseudoHeader$default$2() {
        return package$.MODULE$.UTF8();
    }

    public Uri.ParsingMode parseHttp2PathPseudoHeader$default$3() {
        return Uri$ParsingMode$Relaxed$.MODULE$;
    }

    public Uri.Authority parseHttp2AuthorityPseudoHeader(ParserInput headerValue, Charset charset, Uri.ParsingMode mode) {
        return new UriParser(headerValue, charset, mode).parseHttp2AuthorityPseudoHeader();
    }

    public Charset parseHttp2AuthorityPseudoHeader$default$2() {
        return package$.MODULE$.UTF8();
    }

    public Uri.ParsingMode parseHttp2AuthorityPseudoHeader$default$3() {
        return Uri$ParsingMode$Relaxed$.MODULE$;
    }

    public String normalize(ParserInput uri, Charset charset, Uri.ParsingMode mode) {
        Uri parsed = this.apply(uri, charset, mode);
        Uri.Authority x$1 = parsed.authority().normalizedFor(parsed.scheme());
        String x$2 = parsed.copy$default$1();
        Uri.Path x$3 = parsed.copy$default$3();
        Option<String> x$4 = parsed.copy$default$4();
        Option<String> x$5 = parsed.copy$default$5();
        Uri normalized = parsed.copy(x$2, x$1, x$3, x$4, x$5);
        return UriRendering$.MODULE$.renderUri(new StringRendering(), normalized, charset).get();
    }

    public Charset normalize$default$2() {
        return package$.MODULE$.UTF8();
    }

    public Uri.ParsingMode normalize$default$3() {
        return Uri$ParsingMode$Relaxed$.MODULE$;
    }

    public Uri effectiveHttpRequestUri(String scheme, Uri.Host host, int port, Uri.Path path, Option<String> query, Option<String> fragment, boolean securedConnection, Uri.Host hostHeaderHost, int hostHeaderPort, Uri.Authority defaultAuthority) {
        return this.effectiveRequestUri(scheme, host, port, path, query, fragment, this.httpScheme(securedConnection), hostHeaderHost, hostHeaderPort, defaultAuthority);
    }

    public Uri.Authority effectiveHttpRequestUri$default$10() {
        return Uri$Authority$.MODULE$.Empty();
    }

    public Uri effectiveRequestUri(String scheme, Uri.Host host, int port, Uri.Path path, Option<String> query, Option<String> fragment, String defaultScheme, Uri.Host hostHeaderHost, int hostHeaderPort, Uri.Authority defaultAuthority) {
        int _port;
        Uri.Host _host;
        String _scheme;
        block3: {
            _scheme = scheme;
            _host = host;
            _port = port;
            if (!_scheme.isEmpty()) break block3;
            _scheme = defaultScheme;
            if (_host.isEmpty()) {
                if (hostHeaderHost.isEmpty()) {
                    _host = defaultAuthority.host();
                    _port = defaultAuthority.port();
                } else {
                    _host = hostHeaderHost;
                    _port = hostHeaderPort;
                }
            }
        }
        return this.create(_scheme, "", _host, _port, this.collapseDotSegments(path), query, fragment);
    }

    public Uri.Authority effectiveRequestUri$default$10() {
        return Uri$Authority$.MODULE$.Empty();
    }

    public String httpScheme(boolean securedConnection) {
        if (securedConnection) {
            return "https";
        }
        return "http";
    }

    public boolean httpScheme$default$1() {
        return false;
    }

    public String websocketScheme(boolean securedConnection) {
        if (securedConnection) {
            return "wss";
        }
        return "ws";
    }

    public boolean websocketScheme$default$1() {
        return false;
    }

    public Map<String, Object> akka$http$scaladsl$model$Uri$$defaultPorts() {
        return akka$http$scaladsl$model$Uri$$defaultPorts;
    }

    public Uri resolveUnsafe(String scheme, String userinfo, Uri.Host host, int port, Uri.Path path, Option<String> query, Option<String> fragment, Uri base) {
        Predef$.MODULE$.require(base.isAbsolute(), (Function0 & Serializable)() -> "Resolution base Uri must be absolute");
        if (scheme.isEmpty()) {
            if (host.isEmpty()) {
                if (path.isEmpty()) {
                    return this.createUnsafe(base.scheme(), base.authority(), base.path(), (Option<String>)query.orElse((Function0 & Serializable)() -> base.rawQueryString()), fragment);
                }
                Uri.Path p = path.startsWithSlash() ? path : Uri$.mergePaths$1(base, path);
                return this.createUnsafe(base.scheme(), base.authority(), this.collapseDotSegments(p), query, fragment);
            }
            return this.createUnsafe(base.scheme(), new Uri.Authority(host, port, userinfo), this.collapseDotSegments(path), query, fragment);
        }
        return this.createUnsafe(scheme, new Uri.Authority(host, port, userinfo), this.collapseDotSegments(path), query, fragment);
    }

    public String decode(String string, Charset charset) {
        int ix = string.indexOf(37);
        if (ix >= 0) {
            String x$1 = string;
            Charset x$2 = charset;
            int x$3 = ix;
            StringBuilder x$4 = this.decode$default$4(x$1, x$2, x$3);
            return this.decode(x$1, x$2, x$3, x$4);
        }
        return string;
    }

    public String decode(String string, Charset charset, int ix, StringBuilder sb) {
        block3: while (ix < string.length()) {
            char c = string.charAt(ix);
            switch (c) {
                case '%': {
                    StringBuilder stringBuilder;
                    int lastPercentSignIndexPlus3;
                    for (lastPercentSignIndexPlus3 = ix + 3; lastPercentSignIndexPlus3 < string.length() && string.charAt(lastPercentSignIndexPlus3) == '%'; lastPercentSignIndexPlus3 += 3) {
                    }
                    if (string.length() < lastPercentSignIndexPlus3) {
                        throw this.fail(new StringBuilder(32).append("Illegal percent-encoding at pos ").append(lastPercentSignIndexPlus3 - 3).toString(), this.fail$default$2());
                    }
                    int bytesCount = (lastPercentSignIndexPlus3 - ix) / 3;
                    byte[] bytes = new byte[bytesCount];
                    if (this.decodeBytes$1(Uri$.decodeBytes$default$1$1(), Uri$.decodeBytes$default$2$1(), bytesCount, ix, bytes, string) >> 7 == 0 && UriRendering$.MODULE$.isAsciiCompatible(charset)) {
                        this.appendBytes$1(Uri$.appendBytes$default$1$1(), bytesCount, sb, bytes);
                        stringBuilder = BoxedUnit.UNIT;
                    } else {
                        stringBuilder = sb.append(new String(bytes, charset));
                    }
                    ix = lastPercentSignIndexPlus3;
                    continue block3;
                }
            }
            sb = sb.append(c);
            ++ix;
        }
        return sb.toString();
    }

    public StringBuilder decode$default$4(String string, Charset charset, int ix) {
        return new StringBuilder(string.length()).append(string, 0, ix);
    }

    public String normalizeScheme(String scheme) {
        int n = this.verify$1(Uri$.verify$default$1$1(), Uri$.verify$default$2$1(), Uri$.verify$default$3$1(), scheme);
        switch (n) {
            case -2: {
                return scheme.toLowerCase();
            }
            case -1: {
                return scheme;
            }
        }
        throw this.fail(new StringBuilder(53).append("Invalid URI scheme, unexpected character at pos ").append(n).append(" ('").append(scheme.charAt(n)).append("')").toString(), this.fail$default$2());
    }

    public int normalizePort(int port, String scheme) {
        if (port >> 16 == 0) {
            if (port != 0 && BoxesRunTime.unboxToInt((Object)this.akka$http$scaladsl$model$Uri$$defaultPorts().apply((Object)scheme)) == port) {
                return 0;
            }
            return port;
        }
        throw this.fail(new StringBuilder(13).append("Invalid port ").append(port).toString(), this.fail$default$2());
    }

    public Uri.Path verifyPath(Uri.Path path, String scheme, Uri.Host host) {
        if (host.isEmpty()) {
            if (path.startsWithSlash() && path.tail().startsWithSlash()) {
                throw this.fail("The path of an URI without authority must not begin with \"//\"", this.fail$default$2());
            }
        } else if (path.startsWithSegment()) {
            throw this.fail("The path of an URI containing an authority must either be empty or start with a '/' (slash) character", this.fail$default$2());
        }
        return path;
    }

    public Uri.Path collapseDotSegments(Uri.Path path) {
        if (this.hasDotOrDotDotSegment$1(path)) {
            if (path.startsWithSlash()) {
                return this.process$1(path, Uri$.process$default$2$1());
            }
            return this.process$1(new Uri.Path.Slash(path), Uri$.process$default$2$1()).tail();
        }
        return path;
    }

    public Nothing$ fail(String summary, String detail) {
        throw IllegalUriException$.MODULE$.apply(summary, detail);
    }

    public String fail$default$2() {
        return "";
    }

    public Uri create(String scheme, String userinfo, Uri.Host host, int port, Uri.Path path, Option<String> queryString, Option<String> fragment) {
        return this.create(scheme, new Uri.Authority(host, port, userinfo), path, queryString, fragment);
    }

    public Uri create(String scheme, Uri.Authority authority, Uri.Path path, Option<String> queryString, Option<String> fragment) {
        return this.createUnsafe(scheme, authority, path, (Option<String>)queryString.map((Function1 & Serializable)x$3 -> new UriParser((ParserInput)ParserInput$.MODULE$.apply(x$3), UriParser$.MODULE$.$lessinit$greater$default$2(), UriParser$.MODULE$.$lessinit$greater$default$3()).parseRawQueryString()), fragment);
    }

    public Uri createUnsafe(String scheme, Uri.Authority authority, Uri.Path path, Option<String> queryString, Option<String> fragment) {
        if (path.isEmpty() && scheme.isEmpty() && authority.isEmpty() && queryString.isEmpty() && fragment.isEmpty()) {
            return Uri$Empty$.MODULE$;
        }
        return new Uri(scheme, authority, path, (Option)queryString, (Option)fragment){

            public boolean isEmpty() {
                return false;
            }
        };
    }

    public Option<Tuple5<String, Uri.Authority, Uri.Path, Option<String>, Option<String>>> unapply(Uri x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple5((Object)x$0.scheme(), (Object)x$0.authority(), (Object)x$0.path(), x$0.rawQueryString(), x$0.fragment()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Uri$.class);
    }

    private static final Uri.Path replaceLastSegment$1(Uri.Path p, Uri.Path replacement) {
        Uri.Path.Segment segment;
        Uri.Path.SlashOrEmpty slashOrEmpty;
        Uri.Path path = p;
        if (Uri$Path$Empty$.MODULE$.equals(path) ? true : path instanceof Uri.Path.Segment && Uri$Path$Empty$.MODULE$.equals(slashOrEmpty = (segment = (Uri.Path.Segment)path).tail())) {
            return replacement;
        }
        if (path instanceof Uri.Path.Segment) {
            Uri.Path.Segment segment2 = (Uri.Path.Segment)path;
            String string = segment2.head();
            Uri.Path.SlashOrEmpty tail = segment2.tail();
            String string2 = string;
            return Uri$.replaceLastSegment$1(tail, replacement).$colon$colon(string2);
        }
        if (path instanceof Uri.Path.Slash) {
            Uri.Path.Slash slash = (Uri.Path.Slash)path;
            Uri.Path tail = slash.tail();
            return new Uri.Path.Slash(Uri$.replaceLastSegment$1(tail, replacement));
        }
        throw new MatchError((Object)path);
    }

    private static final Uri.Path mergePaths$1(Uri base, Uri.Path path) {
        if (!base.authority().isEmpty() && base.path().isEmpty()) {
            return new Uri.Path.Slash(path);
        }
        return Uri$.replaceLastSegment$1(base.path(), path);
    }

    private final int intValueOfHexChar$1(int j, String string$2) {
        char c = string$2.charAt(j);
        if (BoxesRunTime.unboxToBoolean((Object)CharacterClasses$.MODULE$.HEXDIG().apply((Object)BoxesRunTime.boxToCharacter((char)c)))) {
            return CharUtils$.MODULE$.hexValue(c);
        }
        throw this.fail(new StringBuilder(32).append("Illegal percent-encoding at pos ").append(j).toString(), this.fail$default$2());
    }

    private final int intValueOfHexWord$1(int i, String string$2) {
        return this.intValueOfHexChar$1(i, string$2) * 16 + this.intValueOfHexChar$1(i + 1, string$2);
    }

    private final int decodeBytes$1(int i, int oredBytes, int bytesCount$1, int ix$1, byte[] bytes$1, String string$2) {
        while (i < bytesCount$1) {
            int n = this.intValueOfHexWord$1(ix$1 + 3 * i + 1, string$2);
            bytes$1[i] = (byte)n;
            oredBytes |= n;
            ++i;
        }
        return oredBytes;
    }

    private static final int decodeBytes$default$1$1() {
        return 0;
    }

    private static final int decodeBytes$default$2$1() {
        return 0;
    }

    private final void appendBytes$1(int i, int bytesCount$1, StringBuilder sb$1, byte[] bytes$1) {
        while (i < bytesCount$1) {
            sb$1.append((char)bytes$1[i]);
            ++i;
        }
    }

    private static final int appendBytes$default$1$1() {
        return 0;
    }

    private final int verify$1(int ix, CharPredicate allowed, boolean allLower, String scheme$1) {
        while (ix < scheme$1.length()) {
            char c = scheme$1.charAt(ix);
            if (BoxesRunTime.unboxToBoolean((Object)allowed.apply((Object)BoxesRunTime.boxToCharacter((char)c)))) {
                allLower = allLower && !BoxesRunTime.unboxToBoolean((Object)CharacterClasses$.MODULE$.UPPER_ALPHA().apply((Object)BoxesRunTime.boxToCharacter((char)c)));
                allowed = CharacterClasses$.MODULE$.scheme$minuschar();
                ++ix;
                continue;
            }
            return ix;
        }
        if (allLower) {
            return -1;
        }
        return -2;
    }

    private static final int verify$default$1$1() {
        return 0;
    }

    private static final CharPredicate verify$default$2$1() {
        return CharacterClasses$.MODULE$.ALPHA();
    }

    private static final boolean verify$default$3$1() {
        return true;
    }

    private final boolean hasDotOrDotDotSegment$1(Uri.Path p) {
        Uri.Path path;
        while (!Uri$Path$Empty$.MODULE$.equals(path = p)) {
            Uri.Path.Segment segment;
            String string;
            Uri.Path.Segment segment2;
            String string2;
            if (path instanceof Uri.Path.Segment && ".".equals(string2 = (segment2 = (Uri.Path.Segment)path).head()) ? true : path instanceof Uri.Path.Segment && "..".equals(string = (segment = (Uri.Path.Segment)path).head())) {
                return true;
            }
            p = p.tail();
        }
        return false;
    }

    private final Uri.Path process$1(Uri.Path input, Uri.Path output) {
        Uri.Path path;
        while (true) {
            Uri.Path path2;
            boolean bl = false;
            Uri.Path.Segment segment = null;
            boolean bl2 = false;
            Uri.Path.Slash slash = null;
            path = input;
            if (Uri$Path$Empty$.MODULE$.equals(path)) {
                return output.reverse();
            }
            if (path instanceof Uri.Path.Segment) {
                bl = true;
                segment = (Uri.Path.Segment)path;
                String string = segment.head();
                Uri.Path.SlashOrEmpty slashOrEmpty = segment.tail();
                if ((".".equals(string) ? true : "..".equals(string)) && slashOrEmpty instanceof Uri.Path.Slash) {
                    Uri.Path tail;
                    Uri.Path.Slash slash2 = (Uri.Path.Slash)slashOrEmpty;
                    input = tail = slash2.tail();
                    continue;
                }
            }
            if (path instanceof Uri.Path.Slash) {
                bl2 = true;
                slash = (Uri.Path.Slash)path;
                Uri.Path path3 = slash.tail();
                if (path3 instanceof Uri.Path.Segment) {
                    Uri.Path.Segment segment2 = (Uri.Path.Segment)path3;
                    String string = segment2.head();
                    Uri.Path.SlashOrEmpty tail = segment2.tail();
                    if (".".equals(string)) {
                        input = tail.isEmpty() ? Uri$Path$.MODULE$.$div() : tail;
                        continue;
                    }
                }
            }
            if (bl2 && (path2 = slash.tail()) instanceof Uri.Path.Segment) {
                Uri.Path.Segment segment3 = (Uri.Path.Segment)path2;
                String string = segment3.head();
                Uri.Path.SlashOrEmpty tail = segment3.tail();
                if ("..".equals(string)) {
                    output = output.startsWithSegment() ? (output.tail().startsWithSlash() ? output.tail().tail() : tail) : output;
                    input = tail.isEmpty() ? Uri$Path$.MODULE$.$div() : tail;
                    continue;
                }
            }
            if (bl) {
                String string = segment.head();
                Uri.Path.SlashOrEmpty tail = segment.tail();
                if (".".equals(string) ? true : "..".equals(string)) {
                    input = tail;
                    continue;
                }
            }
            if (bl2) {
                Uri.Path tail = slash.tail();
                output = new Uri.Path.Slash(output);
                input = tail;
                continue;
            }
            if (!bl) break;
            String string = segment.head();
            Uri.Path.SlashOrEmpty tail = segment.tail();
            String string2 = string;
            output = output.$colon$colon(string2);
            input = tail;
        }
        throw new MatchError((Object)path);
    }

    private static final Uri.Path process$default$2$1() {
        return Uri$Path$Empty$.MODULE$;
    }

    private Uri$() {
    }
}

