/*
 * Decompiled with CFR 0.152.
 */
package akka.http.scaladsl.model;

import akka.http.impl.util.ObjectRegistry;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpMethod$;
import akka.http.scaladsl.model.RequestEntityAcceptance$Disallowed$;
import akka.http.scaladsl.model.RequestEntityAcceptance$Expected$;
import akka.http.scaladsl.model.RequestEntityAcceptance$Tolerated$;
import akka.http.scaladsl.model.StatusCode;
import java.io.Serializable;
import java.util.Locale;
import scala.;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;

public final class HttpMethods$
implements ObjectRegistry<String, HttpMethod> {
    public static final HttpMethods$ MODULE$ = new HttpMethods$();
    private static final HttpMethod CONNECT;
    private static final HttpMethod DELETE;
    private static final HttpMethod GET;
    private static final HttpMethod HEAD;
    private static final HttpMethod OPTIONS;
    private static final HttpMethod PATCH;
    private static final HttpMethod POST;
    private static final HttpMethod PUT;
    private static final HttpMethod TRACE;
    private static Map<String, HttpMethod> akka$http$impl$util$ObjectRegistry$$_registry;

    static {
        ObjectRegistry.$init$(MODULE$);
        CONNECT = MODULE$.register(HttpMethod$.MODULE$.apply("CONNECT", false, false, RequestEntityAcceptance$Disallowed$.MODULE$, (Function1<StatusCode, Object>)(Function1 & Serializable)forStatus -> BoxesRunTime.boxToBoolean((boolean)HttpMethods$.MODULE$.contentLengthAllowedForConnect(forStatus))));
        DELETE = MODULE$.register(HttpMethod$.MODULE$.apply("DELETE", false, true, RequestEntityAcceptance$Tolerated$.MODULE$, (Function1<StatusCode, Object>)(Function1 & Serializable)forStatus -> BoxesRunTime.boxToBoolean((boolean)HttpMethods$.MODULE$.contentLengthAllowedCommon(forStatus))));
        GET = MODULE$.register(HttpMethod$.MODULE$.apply("GET", true, true, RequestEntityAcceptance$Tolerated$.MODULE$, (Function1<StatusCode, Object>)(Function1 & Serializable)forStatus -> BoxesRunTime.boxToBoolean((boolean)HttpMethods$.MODULE$.contentLengthAllowedCommon(forStatus))));
        HEAD = MODULE$.register(HttpMethod$.MODULE$.apply("HEAD", true, true, RequestEntityAcceptance$Disallowed$.MODULE$, (Function1<StatusCode, Object>)(Function1 & Serializable)forStatus -> BoxesRunTime.boxToBoolean((boolean)HttpMethods$.MODULE$.contentLengthAllowedForHead(forStatus))));
        OPTIONS = MODULE$.register(HttpMethod$.MODULE$.apply("OPTIONS", true, true, RequestEntityAcceptance$Expected$.MODULE$, (Function1<StatusCode, Object>)(Function1 & Serializable)forStatus -> BoxesRunTime.boxToBoolean((boolean)HttpMethods$.MODULE$.contentLengthAllowedCommon(forStatus))));
        PATCH = MODULE$.register(HttpMethod$.MODULE$.apply("PATCH", false, false, RequestEntityAcceptance$Expected$.MODULE$, (Function1<StatusCode, Object>)(Function1 & Serializable)forStatus -> BoxesRunTime.boxToBoolean((boolean)HttpMethods$.MODULE$.contentLengthAllowedCommon(forStatus))));
        POST = MODULE$.register(HttpMethod$.MODULE$.apply("POST", false, false, RequestEntityAcceptance$Expected$.MODULE$, (Function1<StatusCode, Object>)(Function1 & Serializable)forStatus -> BoxesRunTime.boxToBoolean((boolean)HttpMethods$.MODULE$.contentLengthAllowedCommon(forStatus))));
        PUT = MODULE$.register(HttpMethod$.MODULE$.apply("PUT", false, true, RequestEntityAcceptance$Expected$.MODULE$, (Function1<StatusCode, Object>)(Function1 & Serializable)forStatus -> BoxesRunTime.boxToBoolean((boolean)HttpMethods$.MODULE$.contentLengthAllowedCommon(forStatus))));
        TRACE = MODULE$.register(HttpMethod$.MODULE$.apply("TRACE", true, true, RequestEntityAcceptance$Disallowed$.MODULE$, (Function1<StatusCode, Object>)(Function1 & Serializable)forStatus -> BoxesRunTime.boxToBoolean((boolean)HttpMethods$.MODULE$.contentLengthAllowedCommon(forStatus))));
    }

    @Override
    public final Object register(Object key, Object obj) {
        return ObjectRegistry.register$(this, key, obj);
    }

    @Override
    public Option getForKey(Object key) {
        return ObjectRegistry.getForKey$(this, key);
    }

    @Override
    public Map<String, HttpMethod> akka$http$impl$util$ObjectRegistry$$_registry() {
        return akka$http$impl$util$ObjectRegistry$$_registry;
    }

    @Override
    public void akka$http$impl$util$ObjectRegistry$$_registry_$eq(Map<String, HttpMethod> x$1) {
        akka$http$impl$util$ObjectRegistry$$_registry = x$1;
    }

    private HttpMethod register(HttpMethod method) {
        return (HttpMethod)this.register(method.value(), method);
    }

    private boolean contentLengthAllowedForConnect(StatusCode forStatus) {
        return forStatus.intValue() < 200 || forStatus.intValue() >= 300;
    }

    private boolean contentLengthAllowedForHead(StatusCode forStatus) {
        return false;
    }

    private boolean contentLengthAllowedCommon(StatusCode forStatus) {
        int code = forStatus.intValue();
        return code >= 200 && code != 204 && code != 304;
    }

    public HttpMethod CONNECT() {
        return CONNECT;
    }

    public HttpMethod DELETE() {
        return DELETE;
    }

    public HttpMethod GET() {
        return GET;
    }

    public HttpMethod HEAD() {
        return HEAD;
    }

    public HttpMethod OPTIONS() {
        return OPTIONS;
    }

    public HttpMethod PATCH() {
        return PATCH;
    }

    public HttpMethod POST() {
        return POST;
    }

    public HttpMethod PUT() {
        return PUT;
    }

    public HttpMethod TRACE() {
        return TRACE;
    }

    @Override
    public Option<HttpMethod> getForKeyCaseInsensitive(String key, .less.colon.less<String, String> conv) {
        return this.getForKey(conv.apply((Object)key.toUpperCase(Locale.ROOT)));
    }

    private HttpMethods$() {
    }
}

