/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.ws;

import akka.annotation.InternalApi;
import akka.http.impl.engine.ws.Utf8Encoder$;
import akka.stream.Attributes;
import akka.stream.Attributes$;
import akka.stream.FlowShape;
import akka.stream.Inlet;
import akka.stream.Inlet$;
import akka.stream.Outlet;
import akka.stream.Outlet$;
import akka.stream.stage.GraphStage;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.InHandler;
import akka.stream.stage.OutHandler;
import akka.util.ByteString;
import akka.util.ByteStringBuilder;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;

@InternalApi
public final class Utf8Encoder$
extends GraphStage<FlowShape<String, ByteString>> {
    public static final Utf8Encoder$ MODULE$ = new Utf8Encoder$();
    private static final int SurrogateHighMask = 55296;
    private static final int SurrogateLowMask = 56320;
    private static final long Utf8OneByteLimit = MODULE$.lowerNBitsSet(7);
    private static final long Utf8TwoByteLimit = MODULE$.lowerNBitsSet(11);
    private static final long Utf8ThreeByteLimit = MODULE$.lowerNBitsSet(16);
    private static final Inlet<String> stringIn = Inlet$.MODULE$.apply("Utf8Encoder.stringIn");
    private static final Outlet<ByteString> byteStringOut = Outlet$.MODULE$.apply("Utf8Encoder.byteStringOut");
    private static final FlowShape<String, ByteString> shape = new FlowShape(MODULE$.stringIn(), MODULE$.byteStringOut());
    private static final Attributes initialAttributes = Attributes$.MODULE$.name("utf8Encoder");

    public int SurrogateHighMask() {
        return SurrogateHighMask;
    }

    public int SurrogateLowMask() {
        return SurrogateLowMask;
    }

    public long Utf8OneByteLimit() {
        return Utf8OneByteLimit;
    }

    public long Utf8TwoByteLimit() {
        return Utf8TwoByteLimit;
    }

    public long Utf8ThreeByteLimit() {
        return Utf8ThreeByteLimit;
    }

    public long lowerNBitsSet(int n) {
        return (1L << n) - 1L;
    }

    public Inlet<String> stringIn() {
        return stringIn;
    }

    public Outlet<ByteString> byteStringOut() {
        return byteStringOut;
    }

    public FlowShape<String, ByteString> shape() {
        return shape;
    }

    public Attributes initialAttributes() {
        return initialAttributes;
    }

    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new InHandler(){
            private int surrogateValue;

            public void onDownstreamFinish() throws Exception {
                OutHandler.onDownstreamFinish$((OutHandler)this);
            }

            public void onDownstreamFinish(Throwable cause) throws Exception {
                OutHandler.onDownstreamFinish$((OutHandler)this, (Throwable)cause);
            }

            public void onUpstreamFailure(Throwable ex) throws Exception {
                InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
            }

            private int surrogateValue() {
                return this.surrogateValue;
            }

            private void surrogateValue_$eq(int x$1) {
                this.surrogateValue = x$1;
            }

            private boolean inSurrogatePair() {
                return this.surrogateValue() != 0;
            }

            public void onPush() {
                ByteStringBuilder builder = new ByteStringBuilder();
                String input = (String)this.grab(Utf8Encoder$.MODULE$.stringIn());
                for (int offset = 0; offset < input.length(); ++offset) {
                    this.step$1(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(input), offset), builder);
                }
                if (builder.length() > 0) {
                    this.push(Utf8Encoder$.MODULE$.byteStringOut(), builder.result());
                    return;
                }
                this.pull(Utf8Encoder$.MODULE$.stringIn());
            }

            public void onUpstreamFinish() {
                if (this.inSurrogatePair()) {
                    this.failStage(new IllegalArgumentException("Truncated String input (ends in the middle of surrogate pair)"));
                    return;
                }
                this.completeStage();
            }

            public void onPull() {
                this.pull(Utf8Encoder$.MODULE$.stringIn());
            }

            private static final void b$1(int v, ByteStringBuilder builder$1) {
                builder$1.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)v)));
            }

            private final void step$1(int n, ByteStringBuilder builder$1) {
                if (!this.inSurrogatePair()) {
                    if ((long)n <= Utf8Encoder$.MODULE$.Utf8OneByteLimit()) {
                        builder$1.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)n)));
                        return;
                    }
                    if ((long)n <= Utf8Encoder$.MODULE$.Utf8TwoByteLimit()) {
                        anon.1.b$1(0xC0 | (n & 0x7C0) >> 6, builder$1);
                        anon.1.b$1(0x80 | n & 0x3F, builder$1);
                        return;
                    }
                    if (n >= Utf8Encoder$.MODULE$.SurrogateHighMask() && n < Utf8Encoder$.MODULE$.SurrogateLowMask()) {
                        this.surrogateValue_$eq(65536 + ((n & 0x3FF) << 10));
                        return;
                    }
                    if (n >= Utf8Encoder$.MODULE$.SurrogateLowMask() && n < 57343) {
                        throw new IllegalArgumentException("Unexpected UTF-16 surrogate continuation");
                    }
                    if ((long)n <= Utf8Encoder$.MODULE$.Utf8ThreeByteLimit()) {
                        anon.1.b$1(0xE0 | (n & 0xF000) >> 12, builder$1);
                        anon.1.b$1(0x80 | (n & 0xFC0) >> 6, builder$1);
                        anon.1.b$1(0x80 | n & 0x3F, builder$1);
                        return;
                    }
                    throw new IllegalStateException("Char cannot be >= 2^16");
                }
                if (n >= Utf8Encoder$.MODULE$.SurrogateLowMask() && n <= 57343) {
                    this.surrogateValue_$eq(this.surrogateValue() | n & 0x3FF);
                    anon.1.b$1(0xF0 | (this.surrogateValue() & 0x1C0000) >> 18, builder$1);
                    anon.1.b$1(0x80 | (this.surrogateValue() & 0x3F000) >> 12, builder$1);
                    anon.1.b$1(0x80 | (this.surrogateValue() & 0xFC0) >> 6, builder$1);
                    anon.1.b$1(0x80 | this.surrogateValue() & 0x3F, builder$1);
                    this.surrogateValue_$eq(0);
                    return;
                }
                throw new IllegalArgumentException("Expected UTF-16 surrogate continuation");
            }
            {
                InHandler.$init$((InHandler)this);
                OutHandler.$init$((OutHandler)this);
                this.surrogateValue = 0;
                this.setHandlers(Utf8Encoder$.MODULE$.stringIn(), Utf8Encoder$.MODULE$.byteStringOut(), this);
            }
        };
    }

    public String toString() {
        return "Utf8Encoder";
    }

    private Utf8Encoder$() {
    }
}

