/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.rendering;

import akka.NotUsed;
import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.http.impl.engine.parsing.HttpResponseParser$OneHundredContinueError$;
import akka.http.impl.engine.rendering.HttpRequestRendererFactory;
import akka.http.impl.engine.rendering.RenderSupport$;
import akka.http.impl.engine.rendering.RenderSupport$CheckContentLengthTransformer$;
import akka.http.impl.engine.rendering.RenderSupport$ChunkTransformer$;
import akka.http.impl.engine.rendering.RequestRenderingContext;
import akka.http.impl.util.ByteStringRendering;
import akka.http.impl.util.Renderer$;
import akka.http.impl.util.package$;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.RequestEntityAcceptance;
import akka.http.scaladsl.model.RequestEntityAcceptance$Expected$;
import akka.http.scaladsl.model.UriRendering$;
import akka.http.scaladsl.model.headers.Content$minusLength;
import akka.http.scaladsl.model.headers.Content$minusLength$;
import akka.http.scaladsl.model.headers.Content$minusType;
import akka.http.scaladsl.model.headers.CustomHeader;
import akka.http.scaladsl.model.headers.Host;
import akka.http.scaladsl.model.headers.Raw$minusRequest$minusURI;
import akka.http.scaladsl.model.headers.RawHeader;
import akka.http.scaladsl.model.headers.Transfer$minusEncoding;
import akka.http.scaladsl.model.headers.Transfer$minusEncoding$;
import akka.http.scaladsl.model.headers.User$minusAgent;
import akka.stream.Graph;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import akka.util.ByteString;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t5d!\u0002 @\u0001\u0015K\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011\u0002*\t\u0011}\u0003!\u0011!Q\u0001\n\u0001D\u0001b\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\u0006U\u0002!\ta\u001b\u0005\u0006c\u0002!\tA\u001d\u0005\b\u0003#\u0001A\u0011AA\n\u0011\u001d\t\t\u0003\u0001C\u0001\u0005;:\u0001\"!\u0007@\u0011\u0003)\u00151\u0004\u0004\b}}B\t!RA\u000f\u0011\u0019Q\u0017\u0002\"\u0001\u0002 !9\u0011\u0011E\u0005\u0005\u0002\u0005\rb!CA\u001c\u0013A\u0005\u0019\u0013EA\u001d\u0011\u001d\tY\u0004\u0004D\u0001\u0003{9qA!\u0017\n\u0011\u0003\t9EB\u0004\u00028%A\t!a\u0011\t\r)|A\u0011AA#\r\u0019\tYe\u0004!\u0002N!Q\u0011qN\t\u0003\u0016\u0004%\t!!\u001d\t\u0013\u0005M\u0014C!E!\u0002\u0013Q\bB\u00026\u0012\t\u0003\t)\bC\u0004\u0002<E!\t!!\u0010\t\u0013\u0005u\u0014#!A\u0005\u0002\u0005}\u0004\"CAB#E\u0005I\u0011AAC\u0011%\tY*EA\u0001\n\u0003\ni\nC\u0005\u00020F\t\t\u0011\"\u0001\u00022\"I\u00111W\t\u0002\u0002\u0013\u0005\u0011Q\u0017\u0005\n\u0003w\u000b\u0012\u0011!C!\u0003{C\u0011\"a3\u0012\u0003\u0003%\t!!4\t\u0013\u0005]\u0017#!A\u0005B\u0005e\u0007\"CAo#\u0005\u0005I\u0011IAp\u0011%\t\t/EA\u0001\n\u0003\n\u0019\u000fC\u0005\u0002fF\t\t\u0011\"\u0011\u0002h\u001eI\u00111^\b\u0002\u0002#\u0005\u0011Q\u001e\u0004\n\u0003\u0017z\u0011\u0011!E\u0001\u0003_DaA\u001b\u0012\u0005\u0002\t\u001d\u0001\"CAqE\u0005\u0005IQIAr\u0011%\u0011IAIA\u0001\n\u0003\u0013Y\u0001C\u0005\u0003\u0010\t\n\t\u0011\"!\u0003\u0012!I!\u0011\u0004\u0012\u0002\u0002\u0013%!1\u0004\u0004\u0007\u0003\u0003z\u0001I!\u000f\t\u0015\u0005m\u0002F!f\u0001\n\u0003\ti\u0004C\u0005\u0003<!\u0012\t\u0012)A\u0005g\"1!\u000e\u000bC\u0001\u0005{A\u0011\"! )\u0003\u0003%\tA!\u0011\t\u0013\u0005\r\u0005&%A\u0005\u0002\t\u0015\u0003\"CANQ\u0005\u0005I\u0011IAO\u0011%\ty\u000bKA\u0001\n\u0003\t\t\fC\u0005\u00024\"\n\t\u0011\"\u0001\u0003J!I\u00111\u0018\u0015\u0002\u0002\u0013\u0005\u0013Q\u0018\u0005\n\u0003\u0017D\u0013\u0011!C\u0001\u0005\u001bB\u0011\"a6)\u0003\u0003%\tE!\u0015\t\u0013\u0005u\u0007&!A\u0005B\u0005}\u0007\"CAqQ\u0005\u0005I\u0011IAr\u0011%\t)\u000fKA\u0001\n\u0003\u0012)fB\u0005\u0003$=\t\t\u0011#\u0001\u0003&\u0019I\u0011\u0011I\b\u0002\u0002#\u0005!q\u0005\u0005\u0007Ub\"\tA!\f\t\u0013\u0005\u0005\b(!A\u0005F\u0005\r\b\"\u0003B\u0005q\u0005\u0005I\u0011\u0011B\u0018\u0011%\u0011y\u0001OA\u0001\n\u0003\u0013\u0019\u0004C\u0005\u0003\u001aa\n\t\u0011\"\u0003\u0003\u001c\tQ\u0002\n\u001e;q%\u0016\fX/Z:u%\u0016tG-\u001a:fe\u001a\u000b7\r^8ss*\u0011\u0001)Q\u0001\ne\u0016tG-\u001a:j]\u001eT!AQ\"\u0002\r\u0015tw-\u001b8f\u0015\t!U)\u0001\u0003j[Bd'B\u0001$H\u0003\u0011AG\u000f\u001e9\u000b\u0003!\u000bA!Y6lCN\u0011\u0001A\u0013\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0002\u001b\u0006)1oY1mC&\u0011q\n\u0014\u0002\u0007\u0003:L(+\u001a4\u0002\u001fU\u001cXM]!hK:$\b*Z1eKJ\u001c\u0001\u0001E\u0002L'VK!\u0001\u0016'\u0003\r=\u0003H/[8o!\t1V,D\u0001X\u0015\tA\u0016,A\u0004iK\u0006$WM]:\u000b\u0005i[\u0016!B7pI\u0016d'B\u0001/F\u0003!\u00198-\u00197bINd\u0017B\u00010X\u0005=)6/\u001a:%[&tWo]!hK:$\u0018!\u0006:fcV,7\u000f\u001e%fC\u0012,'oU5{K\"Kg\u000e\u001e\t\u0003\u0017\u0006L!A\u0019'\u0003\u0007%sG/A\u0002m_\u001e\u0004\"!\u001a5\u000e\u0003\u0019T!aZ$\u0002\u000b\u00154XM\u001c;\n\u0005%4'A\u0004'pO\u001eLgnZ!eCB$XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\t1tw\u000e\u001d\t\u0003[\u0002i\u0011a\u0010\u0005\u0006!\u0012\u0001\rA\u0015\u0005\u0006?\u0012\u0001\r\u0001\u0019\u0005\u0006G\u0012\u0001\r\u0001Z\u0001\u000fe\u0016tG-\u001a:U_N{WO]2f)\r\u0019\u0018q\u0001\t\u0006ibT\u0018\u0011A\u0007\u0002k*\u0011AL\u001e\u0006\u0003o\u001e\u000baa\u001d;sK\u0006l\u0017BA=v\u0005\u0019\u0019v.\u001e:dKB\u00111P`\u0007\u0002y*\u0011QpR\u0001\u0005kRLG.\u0003\u0002\u0000y\nQ!)\u001f;f'R\u0014\u0018N\\4\u0011\u0007-\u000b\u0019!C\u0002\u0002\u00061\u00131!\u00118z\u0011\u001d\tI!\u0002a\u0001\u0003\u0017\t1a\u0019;y!\ri\u0017QB\u0005\u0004\u0003\u001fy$a\u0006*fcV,7\u000f\u001e*f]\u0012,'/\u001b8h\u0007>tG/\u001a=u\u0003\u0019\u0011XM\u001c3feR!\u0011Q\u0003B.!\r\t9\u0002\u0004\b\u0003[\"\t!\u0004\u0013;uaJ+\u0017/^3tiJ+g\u000eZ3sKJ4\u0015m\u0019;pef\u0004\"!\\\u0005\u0014\u0005%QECAA\u000e\u00031\u0011XM\u001c3feN#(/[2u)\u001dQ\u0018QEA\u0014\u0003kAq!!\u0003\f\u0001\u0004\tY\u0001C\u0004\u0002*-\u0001\r!a\u000b\u0002\u0011M,G\u000f^5oON\u0004B!!\f\u000225\u0011\u0011q\u0006\u0006\u0004\u0003SY\u0016\u0002BA\u001a\u0003_\u0011\u0001d\u00117jK:$8i\u001c8oK\u000e$\u0018n\u001c8TKR$\u0018N\\4t\u0011\u0015\u00197\u00021\u0001e\u0005Y\u0011V-];fgR\u0014VM\u001c3fe&twmT;uaV$8C\u0001\u0007K\u0003)\u0011\u0017\u0010^3TiJ,\u0017-\\\u000b\u0002g&\u001aA\u0002K\t\u0003\u0011M#(/Z1nK\u0012\u001c\"a\u0004&\u0015\u0005\u0005\u001d\u0003cAA%\u001f5\t\u0011B\u0001\u0004TiJL7\r^\n\t#)\u000by%!\u0015\u0002XA\u0019\u0011\u0011\n\u0007\u0011\u0007-\u000b\u0019&C\u0002\u0002V1\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0002Z\u0005%d\u0002BA.\u0003KrA!!\u0018\u0002d5\u0011\u0011q\f\u0006\u0004\u0003C\n\u0016A\u0002\u001fs_>$h(C\u0001N\u0013\r\t9\u0007T\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY'!\u001c\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0007\u0005\u001dD*A\u0003csR,7/F\u0001{\u0003\u0019\u0011\u0017\u0010^3tAQ!\u0011qOA>!\r\tI(E\u0007\u0002\u001f!1\u0011q\u000e\u000bA\u0002i\fAaY8qsR!\u0011qOAA\u0011!\tyG\u0006I\u0001\u0002\u0004Q\u0018AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u000fS3A_AEW\t\tY\t\u0005\u0003\u0002\u000e\u0006]UBAAH\u0015\u0011\t\t*a%\u0002\u0013Ut7\r[3dW\u0016$'bAAK\u0019\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005e\u0015q\u0012\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002 B!\u0011\u0011UAV\u001b\t\t\u0019K\u0003\u0003\u0002&\u0006\u001d\u0016\u0001\u00027b]\u001eT!!!+\u0002\t)\fg/Y\u0005\u0005\u0003[\u000b\u0019K\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0002A\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0001\u0003oC\u0001\"!/\u001b\u0003\u0003\u0005\r\u0001Y\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005}\u0006CBAa\u0003\u000f\f\t!\u0004\u0002\u0002D*\u0019\u0011Q\u0019'\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002J\u0006\r'\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a4\u0002VB\u00191*!5\n\u0007\u0005MGJA\u0004C_>dW-\u00198\t\u0013\u0005eF$!AA\u0002\u0005\u0005\u0011A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a(\u0002\\\"A\u0011\u0011X\u000f\u0002\u0002\u0003\u0007\u0001-\u0001\u0005iCND7i\u001c3f)\u0005\u0001\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005}\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0002P\u0006%\b\"CA]A\u0005\u0005\t\u0019AA\u0001\u0003\u0019\u0019FO]5diB\u0019\u0011\u0011\u0010\u0012\u0014\u000b\t\n\t0!@\u0011\u000f\u0005M\u0018\u0011 >\u0002x5\u0011\u0011Q\u001f\u0006\u0004\u0003od\u0015a\u0002:v]RLW.Z\u0005\u0005\u0003w\f)PA\tBEN$(/Y2u\rVt7\r^5p]F\u0002B!a@\u0003\u00065\u0011!\u0011\u0001\u0006\u0005\u0005\u0007\t9+\u0001\u0002j_&!\u00111\u000eB\u0001)\t\ti/A\u0003baBd\u0017\u0010\u0006\u0003\u0002x\t5\u0001BBA8K\u0001\u0007!0A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tM!Q\u0003\t\u0004\u0017NS\b\"\u0003B\fM\u0005\u0005\t\u0019AA<\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005;\u0001B!!)\u0003 %!!\u0011EAR\u0005\u0019y%M[3di\u0006A1\u000b\u001e:fC6,G\rE\u0002\u0002za\u001aR\u0001\u000fB\u0015\u0003{\u0004r!a=\u0002zN\u0014Y\u0003E\u0002\u0002z!\"\"A!\n\u0015\t\t-\"\u0011\u0007\u0005\u0007\u0003wY\u0004\u0019A:\u0015\t\tU\"q\u0007\t\u0004\u0017N\u001b\b\"\u0003B\fy\u0005\u0005\t\u0019\u0001B\u0016'!A#*a\u0014\u0002R\u0005]\u0013a\u00032zi\u0016\u001cFO]3b[\u0002\"BAa\u000b\u0003@!1\u00111H\u0016A\u0002M$BAa\u000b\u0003D!A\u00111\b\u0017\u0011\u0002\u0003\u00071/\u0006\u0002\u0003H)\u001a1/!#\u0015\t\u0005\u0005!1\n\u0005\t\u0003s\u0003\u0014\u0011!a\u0001AR!\u0011q\u001aB(\u0011%\tILMA\u0001\u0002\u0004\t\t\u0001\u0006\u0003\u0002 \nM\u0003\u0002CA]g\u0005\u0005\t\u0019\u00011\u0015\t\u0005='q\u000b\u0005\n\u0003s3\u0014\u0011!a\u0001\u0003\u0003\taCU3rk\u0016\u001cHOU3oI\u0016\u0014\u0018N\\4PkR\u0004X\u000f\u001e\u0005\b\u0003\u00131\u0001\u0019AA\u0006)\rQ(q\f\u0005\b\u0003\u00139\u0001\u0019AA\u0006Q\r\u0001!1\r\t\u0005\u0005K\u0012I'\u0004\u0002\u0003h)\u0019\u0011QS$\n\t\t-$q\r\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018\u000e")
@InternalApi
public class HttpRequestRendererFactory {
    private final Option<User$minusAgent> userAgentHeader;
    private final int requestHeaderSizeHint;
    private final LoggingAdapter log;

    public Source<ByteString, Object> renderToSource(RequestRenderingContext ctx) {
        return this.render(ctx).byteStream();
    }

    public RequestRenderingOutput render(RequestRenderingContext ctx) {
        ByteStringRendering r = new ByteStringRendering(this.requestHeaderSizeHint, (Function1<String, BoxedUnit>)(Function1 & Serializable)message -> {
            this.log.warning(message);
            return BoxedUnit.UNIT;
        });
        HttpRequestRendererFactory.renderRequestLine$1(r, ctx);
        this.renderHeaders$1(ctx.request().headers().toList(), HttpRequestRendererFactory.renderHeaders$default$2$1(), HttpRequestRendererFactory.renderHeaders$default$3$1(), HttpRequestRendererFactory.renderHeaders$default$4$1(), ctx, r);
        RenderSupport$.MODULE$.renderEntityContentType(r, ctx.request().entity());
        return HttpRequestRendererFactory.completeRequestRendering$1(ctx, r);
    }

    public ByteString renderStrict(RequestRenderingContext ctx) {
        RequestRenderingOutput requestRenderingOutput = this.render(ctx);
        if (requestRenderingOutput instanceof RequestRenderingOutput.Strict) {
            RequestRenderingOutput.Strict strict = (RequestRenderingOutput.Strict)requestRenderingOutput;
            ByteString bytes = strict.bytes();
            return bytes;
        }
        if (requestRenderingOutput instanceof RequestRenderingOutput.Streamed) {
            throw new IllegalArgumentException(new StringBuilder(34).append("Request entity was not Strict but ").append(ctx.request().entity().getClass().getSimpleName()).toString());
        }
        throw new MatchError((Object)requestRenderingOutput);
    }

    public static final /* synthetic */ boolean $anonfun$render$2(ByteStringRendering r$1, HttpHeader x0$1) {
        HttpHeader httpHeader = x0$1;
        if (httpHeader instanceof Raw$minusRequest$minusURI) {
            Raw$minusRequest$minusURI raw$minusRequest$minusURI = (Raw$minusRequest$minusURI)httpHeader;
            String rawUri = raw$minusRequest$minusURI.uri();
            r$1.$tilde$tilde(rawUri);
            return true;
        }
        return false;
    }

    private static final void renderRequestLine$1(ByteStringRendering r$1, RequestRenderingContext ctx$1) {
        ((ByteStringRendering)r$1.$tilde$tilde(ctx$1.request().method(), Renderer$.MODULE$.renderableRenderer())).$tilde$tilde(' ');
        boolean rawRequestUriRendered = ctx$1.request().headers().exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)HttpRequestRendererFactory.$anonfun$render$2(r$1, x0$1)));
        Object object = !rawRequestUriRendered ? UriRendering$.MODULE$.renderUriWithoutFragment(r$1, ctx$1.request().uri(), package$.MODULE$.UTF8()) : BoxedUnit.UNIT;
        ((ByteStringRendering)r$1.$tilde$tilde(' ').$tilde$tilde(ctx$1.request().protocol(), Renderer$.MODULE$.renderableRenderer())).$tilde$tilde(RenderSupport$.MODULE$.CrLf());
    }

    private static final ByteStringRendering render$1(HttpHeader h, ByteStringRendering r$1) {
        return (ByteStringRendering)r$1.$tilde$tilde(h);
    }

    private final void renderHeaders$1(List remaining, boolean hostHeaderSeen, boolean userAgentSeen, boolean transferEncodingSeen, RequestRenderingContext ctx$1, ByteStringRendering r$1) {
        List list;
        while ((list = remaining) instanceof .colon.colon) {
            ByteStringRendering byteStringRendering;
            .colon.colon colon2 = (.colon.colon)list;
            HttpHeader head = (HttpHeader)colon2.head();
            List tail = colon2.next$access$1();
            boolean bl = false;
            RawHeader rawHeader = null;
            HttpHeader httpHeader = head;
            if (httpHeader instanceof Content$minusLength) {
                Content$minusLength content$minusLength = (Content$minusLength)httpHeader;
                RenderSupport$.MODULE$.suppressionWarning(this.log, content$minusLength, "explicit `Content-Length` header is not allowed. Use the appropriate HttpEntity subtype.");
                remaining = tail;
                continue;
            }
            if (httpHeader instanceof Content$minusType) {
                Content$minusType content$minusType = (Content$minusType)httpHeader;
                RenderSupport$.MODULE$.suppressionWarning(this.log, content$minusType, "explicit `Content-Type` header is not allowed. Set `HttpRequest.entity.contentType` instead.");
                remaining = tail;
                continue;
            }
            if (httpHeader instanceof Transfer$minusEncoding) {
                Transfer$minusEncoding transfer$minusEncoding = (Transfer$minusEncoding)httpHeader;
                Option<Transfer$minusEncoding> option = transfer$minusEncoding.withChunkedPeeled();
                if (None$.MODULE$.equals(option)) {
                    RenderSupport$.MODULE$.suppressionWarning(this.log, head, RenderSupport$.MODULE$.suppressionWarning$default$3());
                    remaining = tail;
                    continue;
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Transfer$minusEncoding te = (Transfer$minusEncoding)some.value();
                    HttpRequestRendererFactory.render$1(ctx$1.request().entity().isChunked() && !ctx$1.request().entity().isKnownEmpty() ? te.withChunked() : te, r$1);
                    transferEncodingSeen = true;
                    remaining = tail;
                    continue;
                }
                throw new MatchError(option);
            }
            if (httpHeader instanceof Host) {
                Host host = (Host)httpHeader;
                HttpRequestRendererFactory.render$1(host, r$1);
                hostHeaderSeen = true;
                remaining = tail;
                continue;
            }
            if (httpHeader instanceof User$minusAgent) {
                User$minusAgent user$minusAgent = (User$minusAgent)httpHeader;
                HttpRequestRendererFactory.render$1(user$minusAgent, r$1);
                userAgentSeen = true;
                remaining = tail;
                continue;
            }
            if (httpHeader instanceof Raw$minusRequest$minusURI) {
                remaining = tail;
                continue;
            }
            if (httpHeader instanceof CustomHeader) {
                CustomHeader customHeader = (CustomHeader)httpHeader;
                Object object = customHeader.renderInRequests() ? HttpRequestRendererFactory.render$1(customHeader, r$1) : BoxedUnit.UNIT;
                remaining = tail;
                continue;
            }
            if (httpHeader instanceof RawHeader) {
                bl = true;
                rawHeader = (RawHeader)httpHeader;
                if (rawHeader.is("content-type") || rawHeader.is("content-length") || rawHeader.is("transfer-encoding")) {
                    RenderSupport$.MODULE$.suppressionWarning(this.log, rawHeader, "illegal RawHeader");
                    remaining = tail;
                    continue;
                }
            }
            if (bl && rawHeader.is("user-agent")) {
                HttpRequestRendererFactory.render$1(rawHeader, r$1);
                userAgentSeen = true;
                remaining = tail;
                continue;
            }
            if (bl && rawHeader.is("host")) {
                HttpRequestRendererFactory.render$1(rawHeader, r$1);
                hostHeaderSeen = true;
                remaining = tail;
                continue;
            }
            if (httpHeader.renderInRequests()) {
                byteStringRendering = HttpRequestRendererFactory.render$1(httpHeader, r$1);
            } else {
                this.log.warning("HTTP header '{}' is not allowed in requests", (Object)httpHeader);
                byteStringRendering = BoxedUnit.UNIT;
            }
            remaining = tail;
        }
        if (Nil$.MODULE$.equals(list)) {
            Object object = !hostHeaderSeen ? r$1.$tilde$tilde(ctx$1.hostHeader()) : BoxedUnit.UNIT;
            Object object2 = !userAgentSeen && this.userAgentHeader.isDefined() ? r$1.$tilde$tilde((HttpHeader)this.userAgentHeader.get()) : BoxedUnit.UNIT;
            if (ctx$1.request().entity().isChunked() && !ctx$1.request().entity().isKnownEmpty() && !transferEncodingSeen) {
                ((ByteStringRendering)r$1.$tilde$tilde(Transfer$minusEncoding$.MODULE$, Renderer$.MODULE$.renderableRenderer())).$tilde$tilde(RenderSupport$.MODULE$.ChunkedBytes()).$tilde$tilde(RenderSupport$.MODULE$.CrLf());
            }
        } else {
            throw new MatchError((Object)list);
        }
    }

    private static final boolean renderHeaders$default$2$1() {
        return false;
    }

    private static final boolean renderHeaders$default$3$1() {
        return false;
    }

    private static final boolean renderHeaders$default$4$1() {
        return false;
    }

    private static final ByteStringRendering renderContentLength$1(long contentLength, RequestRenderingContext ctx$1, ByteStringRendering r$1) {
        block2: {
            block3: {
                if (!ctx$1.request().method().isEntityAccepted()) break block2;
                if (contentLength > 0L) break block3;
                RequestEntityAcceptance requestEntityAcceptance = ctx$1.request().method().requestEntityAcceptance();
                RequestEntityAcceptance$Expected$ requestEntityAcceptance$Expected$ = RequestEntityAcceptance$Expected$.MODULE$;
                if (requestEntityAcceptance != null ? !requestEntityAcceptance.equals(requestEntityAcceptance$Expected$) : requestEntityAcceptance$Expected$ != null) break block2;
            }
            return ((ByteStringRendering)r$1.$tilde$tilde(Content$minusLength$.MODULE$, Renderer$.MODULE$.renderableRenderer()).$tilde$tilde(contentLength)).$tilde$tilde(RenderSupport$.MODULE$.CrLf());
        }
        return r$1;
    }

    private static final RequestRenderingOutput renderStreamed$1(Source body, ByteStringRendering r$1, RequestRenderingContext ctx$1) {
        Source source;
        Source headerPart = Source$.MODULE$.single((Object)r$1.get());
        Option<Future<NotUsed>> option = ctx$1.sendEntityTrigger();
        if (None$.MODULE$.equals(option)) {
            source = (Source)headerPart.$plus$plus((Graph)body);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Future future = (Future)some.value();
            Source barrier = (Source)Source$.MODULE$.future(future).drop(1L);
            source = (Source)headerPart.$plus$plus((Graph)barrier).$plus$plus((Graph)body).recoverWithRetries(-1, (PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (HttpResponseParser$OneHundredContinueError$.MODULE$.equals(A1)) {
                        return (B1)Source$.MODULE$.empty();
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    return HttpResponseParser$OneHundredContinueError$.MODULE$.equals(throwable);
                }
            });
        } else {
            throw new MatchError(option);
        }
        Source stream = source;
        return new RequestRenderingOutput.Streamed((Source<ByteString, Object>)stream);
    }

    private static final RequestRenderingOutput completeRequestRendering$1(RequestRenderingContext ctx$1, ByteStringRendering r$1) {
        RequestEntity requestEntity = ctx$1.request().entity();
        if (requestEntity.isKnownEmpty()) {
            HttpRequestRendererFactory.renderContentLength$1(0L, ctx$1, r$1).$tilde$tilde(RenderSupport$.MODULE$.CrLf());
            return new RequestRenderingOutput.Strict(r$1.get());
        }
        if (requestEntity instanceof HttpEntity.Strict) {
            HttpEntity.Strict strict = (HttpEntity.Strict)requestEntity;
            ByteString data = strict.data();
            HttpRequestRendererFactory.renderContentLength$1(data.length(), ctx$1, r$1).$tilde$tilde(RenderSupport$.MODULE$.CrLf());
            if (ctx$1.sendEntityTrigger().isDefined()) {
                return HttpRequestRendererFactory.renderStreamed$1(Source$.MODULE$.single((Object)data), r$1, ctx$1);
            }
            return new RequestRenderingOutput.Strict(r$1.get().$plus$plus(data));
        }
        if (requestEntity instanceof HttpEntity.Default) {
            HttpEntity.Default default_ = (HttpEntity.Default)requestEntity;
            long contentLength = default_.contentLength();
            Source<ByteString, Object> data = default_.data();
            HttpRequestRendererFactory.renderContentLength$1(contentLength, ctx$1, r$1).$tilde$tilde(RenderSupport$.MODULE$.CrLf());
            return HttpRequestRendererFactory.renderStreamed$1(data.via(RenderSupport$CheckContentLengthTransformer$.MODULE$.flow(contentLength)), r$1, ctx$1);
        }
        if (requestEntity instanceof HttpEntity.Chunked) {
            HttpEntity.Chunked chunked = (HttpEntity.Chunked)requestEntity;
            Source<HttpEntity.ChunkStreamPart, Object> chunks = chunked.chunks();
            r$1.$tilde$tilde(RenderSupport$.MODULE$.CrLf());
            return HttpRequestRendererFactory.renderStreamed$1(chunks.via(RenderSupport$ChunkTransformer$.MODULE$.flow()), r$1, ctx$1);
        }
        throw new MatchError((Object)requestEntity);
    }

    public HttpRequestRendererFactory(Option<User$minusAgent> userAgentHeader, int requestHeaderSizeHint, LoggingAdapter log) {
        this.userAgentHeader = userAgentHeader;
        this.requestHeaderSizeHint = requestHeaderSizeHint;
        this.log = log;
    }

    public static interface RequestRenderingOutput {
        public Source<ByteString, Object> byteStream();
    }
}

