/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.http2.framing;

import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.http.impl.engine.http2.ByteFlag$;
import akka.http.impl.engine.http2.FrameEvent;
import akka.http.impl.engine.http2.Http2Compliance;
import akka.http.impl.engine.http2.Http2Compliance$;
import akka.http.impl.engine.http2.Http2Protocol;
import akka.http.impl.engine.http2.Http2Protocol$ErrorCode$;
import akka.http.impl.engine.http2.Http2Protocol$Flags$;
import akka.http.impl.engine.http2.Http2Protocol$FrameType$CONTINUATION$;
import akka.http.impl.engine.http2.Http2Protocol$FrameType$DATA$;
import akka.http.impl.engine.http2.Http2Protocol$FrameType$GOAWAY$;
import akka.http.impl.engine.http2.Http2Protocol$FrameType$HEADERS$;
import akka.http.impl.engine.http2.Http2Protocol$FrameType$PING$;
import akka.http.impl.engine.http2.Http2Protocol$FrameType$PRIORITY$;
import akka.http.impl.engine.http2.Http2Protocol$FrameType$PUSH_PROMISE$;
import akka.http.impl.engine.http2.Http2Protocol$FrameType$RST_STREAM$;
import akka.http.impl.engine.http2.Http2Protocol$FrameType$SETTINGS$;
import akka.http.impl.engine.http2.Http2Protocol$FrameType$WINDOW_UPDATE$;
import akka.http.impl.engine.http2.Http2Protocol$SettingIdentifier$;
import akka.stream.impl.io.ByteStringParser;
import akka.util.OptionVal;
import akka.util.OptionVal$;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;

@InternalApi
public final class Http2FrameParsing$ {
    public static final Http2FrameParsing$ MODULE$ = new Http2FrameParsing$();

    public Seq<FrameEvent.Setting> readSettings(ByteStringParser.ByteReader payload, LoggingAdapter log) {
        return this.readSettings$1((List)Nil$.MODULE$, payload, log);
    }

    public FrameEvent parseFrame(Http2Protocol.FrameType tpe, int flags, int streamId, ByteStringParser.ByteReader payload, LoggingAdapter log) {
        Http2Protocol.FrameType frameType = tpe;
        if (Http2Protocol$FrameType$GOAWAY$.MODULE$.equals(frameType)) {
            Http2Compliance$.MODULE$.requireZeroStreamId(streamId);
            return new FrameEvent.GoAwayFrame(payload.readIntBE(), Http2Protocol$ErrorCode$.MODULE$.byId(payload.readIntBE()), payload.takeAll());
        }
        if (Http2Protocol$FrameType$HEADERS$.MODULE$.equals(frameType)) {
            None$ none$;
            int paddingLength;
            boolean pad = ByteFlag$.MODULE$.isSet$extension(Http2Protocol$Flags$.MODULE$.PADDED(), flags);
            boolean endStream = ByteFlag$.MODULE$.isSet$extension(Http2Protocol$Flags$.MODULE$.END_STREAM(), flags);
            boolean endHeaders = ByteFlag$.MODULE$.isSet$extension(Http2Protocol$Flags$.MODULE$.END_HEADERS(), flags);
            boolean priority = ByteFlag$.MODULE$.isSet$extension(Http2Protocol$Flags$.MODULE$.PRIORITY(), flags);
            int n = paddingLength = pad ? payload.readByte() & 0xFF : 0;
            if (priority) {
                int dependencyAndE = payload.readIntBE();
                int weight = payload.readByte() & 0xFF;
                boolean exclusiveFlag = dependencyAndE >>> 31 == 1;
                int dependencyId = dependencyAndE & Integer.MAX_VALUE;
                Http2Compliance$.MODULE$.requireNoSelfDependency(streamId, dependencyId);
                none$ = new Some((Object)new FrameEvent.PriorityFrame(streamId, exclusiveFlag, dependencyId, weight));
            } else {
                none$ = None$.MODULE$;
            }
            None$ priorityInfo = none$;
            return new FrameEvent.HeadersFrame(streamId, endStream, endHeaders, payload.take(payload.remainingSize() - paddingLength), (Option<FrameEvent.PriorityFrame>)priorityInfo);
        }
        if (Http2Protocol$FrameType$DATA$.MODULE$.equals(frameType)) {
            boolean pad = ByteFlag$.MODULE$.isSet$extension(Http2Protocol$Flags$.MODULE$.PADDED(), flags);
            boolean endStream = ByteFlag$.MODULE$.isSet$extension(Http2Protocol$Flags$.MODULE$.END_STREAM(), flags);
            int paddingLength = pad ? payload.readByte() & 0xFF : 0;
            return new FrameEvent.DataFrame(streamId, endStream, payload.take(payload.remainingSize() - paddingLength));
        }
        if (Http2Protocol$FrameType$SETTINGS$.MODULE$.equals(frameType)) {
            boolean ack = ByteFlag$.MODULE$.isSet$extension(Http2Protocol$Flags$.MODULE$.ACK(), flags);
            Http2Compliance$.MODULE$.requireZeroStreamId(streamId);
            if (ack) {
                if (payload.hasRemaining()) {
                    throw new Http2Compliance.IllegalPayloadInSettingsAckFrame(payload.remainingSize(), "SETTINGS ACK frame MUST NOT contain payload (spec 6.5)!");
                }
                return new FrameEvent.SettingsAckFrame((Seq<FrameEvent.Setting>)Nil$.MODULE$);
            }
            if (payload.remainingSize() % 6 != 0) {
                throw new Http2Compliance.IllegalPayloadLengthInSettingsFrame(payload.remainingSize(), "SETTINGS payload MUST be a multiple of multiple of 6 octets");
            }
            return new FrameEvent.SettingsFrame(this.readSettings(payload, log));
        }
        if (Http2Protocol$FrameType$WINDOW_UPDATE$.MODULE$.equals(frameType)) {
            int increment = payload.readIntBE();
            Http2Compliance$.MODULE$.requirePositiveWindowUpdateIncrement(streamId, increment);
            return new FrameEvent.WindowUpdateFrame(streamId, increment);
        }
        if (Http2Protocol$FrameType$CONTINUATION$.MODULE$.equals(frameType)) {
            boolean endHeaders = ByteFlag$.MODULE$.isSet$extension(Http2Protocol$Flags$.MODULE$.END_HEADERS(), flags);
            return new FrameEvent.ContinuationFrame(streamId, endHeaders, payload.remainingData());
        }
        if (Http2Protocol$FrameType$PING$.MODULE$.equals(frameType)) {
            Http2Compliance$.MODULE$.requireFrameSize(payload.remainingSize(), 8);
            Http2Compliance$.MODULE$.requireZeroStreamId(streamId);
            boolean ack = ByteFlag$.MODULE$.isSet$extension(Http2Protocol$Flags$.MODULE$.ACK(), flags);
            return new FrameEvent.PingFrame(ack, payload.remainingData());
        }
        if (Http2Protocol$FrameType$RST_STREAM$.MODULE$.equals(frameType)) {
            Http2Compliance$.MODULE$.requireFrameSize(payload.remainingSize(), 4);
            Http2Compliance$.MODULE$.requireNonZeroStreamId(streamId);
            return new FrameEvent.RstStreamFrame(streamId, Http2Protocol$ErrorCode$.MODULE$.byId(payload.readIntBE()));
        }
        if (Http2Protocol$FrameType$PRIORITY$.MODULE$.equals(frameType)) {
            Http2Compliance$.MODULE$.requireFrameSize(payload.remainingSize(), 5);
            int streamDependency = payload.readIntBE();
            boolean exclusiveFlag = streamDependency >>> 31 == 1;
            int dependencyId = streamDependency & Integer.MAX_VALUE;
            int priority = payload.readByte() & 0xFF;
            Http2Compliance$.MODULE$.requireNoSelfDependency(streamId, dependencyId);
            return new FrameEvent.PriorityFrame(streamId, exclusiveFlag, dependencyId, priority);
        }
        if (Http2Protocol$FrameType$PUSH_PROMISE$.MODULE$.equals(frameType)) {
            boolean pad = ByteFlag$.MODULE$.isSet$extension(Http2Protocol$Flags$.MODULE$.PADDED(), flags);
            boolean endHeaders = ByteFlag$.MODULE$.isSet$extension(Http2Protocol$Flags$.MODULE$.END_HEADERS(), flags);
            int paddingLength = pad ? payload.readByte() & 0xFF : 0;
            int promisedStreamId = payload.readIntBE();
            return new FrameEvent.PushPromiseFrame(streamId, endHeaders, promisedStreamId, payload.take(payload.remainingSize() - paddingLength));
        }
        return new FrameEvent.UnknownFrameEvent(frameType, flags, streamId, payload.remainingData());
    }

    private final Seq readSettings$1(List read, ByteStringParser.ByteReader payload$1, LoggingAdapter log$1) {
        while (payload$1.hasRemaining()) {
            List read0;
            List list;
            int id = payload$1.readShortBE();
            int value = payload$1.readIntBE();
            Http2Protocol.SettingIdentifier settingIdentifier = Http2Protocol$SettingIdentifier$.MODULE$.byId(id);
            Http2Protocol.SettingIdentifier settingIdentifier2 = (Http2Protocol.SettingIdentifier)OptionVal.Some$.MODULE$.unapply((Object)settingIdentifier);
            if (!OptionVal$.MODULE$.isEmpty$extension((Object)settingIdentifier2)) {
                Http2Protocol.SettingIdentifier s2 = (Http2Protocol.SettingIdentifier)OptionVal$.MODULE$.get$extension((Object)settingIdentifier2);
                FrameEvent.Setting setting = new FrameEvent.Setting(s2, value);
                list = read.$colon$colon((Object)setting);
            } else {
                log$1.debug("Ignoring unknown setting identifier {}", (Object)BoxesRunTime.boxToInteger((int)id));
                list = read;
            }
            read = read0 = list;
        }
        return read.reverse();
    }

    private Http2FrameParsing$() {
    }
}

