/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.http2;

import akka.NotUsed;
import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.http.impl.engine.HttpConnectionIdleTimeoutBidi$;
import akka.http.impl.engine.HttpIdleTimeoutException;
import akka.http.impl.engine.http2.FrameEvent;
import akka.http.impl.engine.http2.FrameEvent$GoAwayFrame$;
import akka.http.impl.engine.http2.FrameLogger$;
import akka.http.impl.engine.http2.Http2$;
import akka.http.impl.engine.http2.Http2Blueprint;
import akka.http.impl.engine.http2.Http2ClientDemux;
import akka.http.impl.engine.http2.Http2Compliance;
import akka.http.impl.engine.http2.Http2Protocol$;
import akka.http.impl.engine.http2.Http2Protocol$ErrorCode$INTERNAL_ERROR$;
import akka.http.impl.engine.http2.Http2ServerDemux;
import akka.http.impl.engine.http2.Http2SubStream;
import akka.http.impl.engine.http2.RequestErrorFlow$;
import akka.http.impl.engine.http2.RequestParsing$;
import akka.http.impl.engine.http2.RequestRendering;
import akka.http.impl.engine.http2.ResponseRendering;
import akka.http.impl.engine.http2.TelemetrySpi;
import akka.http.impl.engine.http2.client.ResponseParsing$;
import akka.http.impl.engine.http2.framing.FrameRenderer$;
import akka.http.impl.engine.http2.framing.Http2FrameParsing;
import akka.http.impl.engine.http2.framing.RSTFrameLimit;
import akka.http.impl.engine.http2.hpack.HeaderCompression$;
import akka.http.impl.engine.http2.hpack.HeaderDecompression;
import akka.http.impl.engine.parsing.HttpHeaderParser;
import akka.http.impl.engine.parsing.HttpHeaderParser$;
import akka.http.impl.engine.rendering.DateHeaderRendering;
import akka.http.impl.engine.server.ServerTerminator;
import akka.http.impl.util.JavaMapping$;
import akka.http.impl.util.LogByteStringTools$;
import akka.http.impl.util.StreamUtils$;
import akka.http.javadsl.model.AttributeKey;
import akka.http.scaladsl.model.ErrorInfo;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.settings.ClientConnectionSettings;
import akka.http.scaladsl.settings.Http2ClientSettings;
import akka.http.scaladsl.settings.Http2ServerSettings;
import akka.http.scaladsl.settings.ParserSettings;
import akka.http.scaladsl.settings.ParserSettings$ErrorLoggingVerbosity$Full$;
import akka.http.scaladsl.settings.ParserSettings$ErrorLoggingVerbosity$Off$;
import akka.http.scaladsl.settings.ParserSettings$ErrorLoggingVerbosity$Simple$;
import akka.http.scaladsl.settings.ServerSettings;
import akka.http.scaladsl.settings.ServerSettings$;
import akka.stream.Attributes;
import akka.stream.Graph;
import akka.stream.StreamTcpException;
import akka.stream.TLSProtocol;
import akka.stream.scaladsl.BidiFlow;
import akka.stream.scaladsl.BidiFlow$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.Source$;
import akka.util.ByteString;
import java.io.Serializable;
import java.net.InetSocketAddress;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@InternalApi
public final class Http2Blueprint$ {
    public static final Http2Blueprint$ MODULE$ = new Http2Blueprint$();
    private static final BidiFlow<ByteString, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, ByteString, NotUsed> unwrapTls = BidiFlow$.MODULE$.fromFlows((Graph)Flow$.MODULE$.apply().map((Function1 & Serializable)x$2 -> new TLSProtocol.SendBytes(x$2)), (Graph)Flow$.MODULE$.apply().collect((PartialFunction)new Serializable(){
        private static final long serialVersionUID = 0L;

        public final <A1 extends TLSProtocol.SslTlsInbound, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
            A1 A1 = x1;
            if (A1 instanceof TLSProtocol.SessionBytes) {
                TLSProtocol.SessionBytes sessionBytes = (TLSProtocol.SessionBytes)A1;
                ByteString bytes = sessionBytes.bytes();
                return (B1)bytes;
            }
            return (B1)function1.apply(x1);
        }

        public final boolean isDefinedAt(TLSProtocol.SslTlsInbound x1) {
            TLSProtocol.SslTlsInbound sslTlsInbound = x1;
            return sslTlsInbound instanceof TLSProtocol.SessionBytes;
        }
    }));

    public BidiFlow<HttpResponse, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, HttpRequest, ServerTerminator> serverStackTls(ServerSettings settings, LoggingAdapter log, TelemetrySpi telemetry, DateHeaderRendering dateHeaderRendering) {
        ServerSettings x$1 = settings;
        LoggingAdapter x$2 = log;
        TelemetrySpi x$3 = telemetry;
        DateHeaderRendering x$4 = dateHeaderRendering;
        Seq<FrameEvent.Setting> x$5 = this.serverStack$default$3();
        boolean x$6 = this.serverStack$default$4();
        return this.serverStack(x$1, x$2, x$5, x$6, x$3, x$4).atop(this.unwrapTls()).atop(LogByteStringTools$.MODULE$.logTLSBidiBySetting("server-plain-text", settings.logUnencryptedNetworkBytes()));
    }

    public BidiFlow<HttpResponse, ByteString, ByteString, HttpRequest, ServerTerminator> serverStack(ServerSettings settings, LoggingAdapter log, Seq<FrameEvent.Setting> initialDemuxerSettings, boolean upgraded, TelemetrySpi telemetry, DateHeaderRendering dateHeaderRendering) {
        HttpHeaderParser masterHttpHeaderParser = HttpHeaderParser$.MODULE$.apply(settings.parserSettings(), log);
        return this.BidiFlowExt(telemetry.serverConnection().atop(this.httpLayer(settings, log, dateHeaderRendering))).atopKeepRight(this.serverDemux(settings.http2Settings(), initialDemuxerSettings, upgraded)).atop(FrameLogger$.MODULE$.logFramesIfEnabled(settings.http2Settings().logFrames())).atop(this.hpackCoding(masterHttpHeaderParser, settings.parserSettings())).atop(this.framing(settings.http2Settings(), log)).atop(this.errorHandling(log)).atop(this.idleTimeoutIfConfigured(ServerSettings$.MODULE$.timeoutsShortcut(settings).idleTimeout()));
    }

    public Seq<FrameEvent.Setting> serverStack$default$3() {
        return Nil$.MODULE$;
    }

    public boolean serverStack$default$4() {
        return false;
    }

    public BidiFlow<HttpRequest, ByteString, ByteString, HttpResponse, NotUsed> clientStack(ClientConnectionSettings settings, LoggingAdapter log, TelemetrySpi telemetry) {
        HttpHeaderParser masterHttpHeaderParser = HttpHeaderParser$.MODULE$.apply(settings.parserSettings(), log);
        return telemetry.client().atop(this.httpLayerClient(masterHttpHeaderParser, settings, log)).atop(this.clientDemux(settings.http2Settings(), masterHttpHeaderParser)).atop(FrameLogger$.MODULE$.logFramesIfEnabled(settings.http2Settings().logFrames())).atop(this.hpackCoding(masterHttpHeaderParser, settings.parserSettings())).atop(this.framingClient(log)).atop(this.errorHandling(log)).atop(this.idleTimeoutIfConfigured(settings.idleTimeout()));
    }

    public BidiFlow<HttpRequest, Http2SubStream, Http2SubStream, HttpResponse, NotUsed> httpLayerClient(HttpHeaderParser masterHttpHeaderParser, ClientConnectionSettings settings, LoggingAdapter log) {
        return BidiFlow$.MODULE$.fromFlows((Graph)Flow$.MODULE$.apply().statefulMapConcat((Function0 & Serializable)() -> {
            RequestRendering renderer = new RequestRendering(settings, log);
            return (Function1 & Serializable)request -> {
                Http2SubStream http2SubStream = renderer.apply(request);
                return Nil$.MODULE$.$colon$colon((Object)http2SubStream);
            };
        }), StreamUtils$.MODULE$.statefulAttrsMap((Function1 & Serializable)attrs -> {
            HttpHeaderParser headerParser = masterHttpHeaderParser.createShallowCopy();
            return (Function1 & Serializable)stream -> (HttpResponse)ResponseParsing$.MODULE$.parseResponse(headerParser, settings.parserSettings(), (Attributes)attrs).apply(stream);
        }));
    }

    public BidiFlow<ByteString, ByteString, ByteString, ByteString, NotUsed> idleTimeoutIfConfigured(Duration timeout) {
        Duration duration = timeout;
        if (duration instanceof FiniteDuration) {
            FiniteDuration finiteDuration = (FiniteDuration)duration;
            return HttpConnectionIdleTimeoutBidi$.MODULE$.apply(finiteDuration, (Option<InetSocketAddress>)None$.MODULE$);
        }
        return BidiFlow$.MODULE$.identity();
    }

    public BidiFlow<ByteString, ByteString, ByteString, ByteString, NotUsed> errorHandling(LoggingAdapter log) {
        return BidiFlow$.MODULE$.fromFlows(StreamUtils$.MODULE$.encodeErrorAndComplete((Function1 & Serializable)x0$1 -> {
            Option option;
            Throwable throwable = x0$1;
            if (throwable instanceof Http2Compliance.Http2ProtocolException) {
                Http2Compliance.Http2ProtocolException http2ProtocolException = (Http2Compliance.Http2ProtocolException)throwable;
                if (log.isDebugEnabled()) {
                    log.debug(new StringBuilder(71).append("HTTP2 connection failed with error [").append(http2ProtocolException.getMessage()).append("]. Sending ").append(http2ProtocolException.errorCode()).append(" and closing connection.").toString());
                }
                return FrameRenderer$.MODULE$.render(new FrameEvent.GoAwayFrame(0, http2ProtocolException.errorCode(), FrameEvent$GoAwayFrame$.MODULE$.apply$default$3()));
            }
            if (throwable instanceof StreamTcpException) {
                StreamTcpException streamTcpException = (StreamTcpException)throwable;
                throw streamTcpException;
            }
            if (throwable instanceof HttpIdleTimeoutException) {
                HttpIdleTimeoutException httpIdleTimeoutException = (HttpIdleTimeoutException)throwable;
                throw httpIdleTimeoutException;
            }
            if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                Throwable ex = (Throwable)option.get();
                log.error(new StringBuilder(85).append("HTTP2 connection failed with error [").append(ex.getMessage()).append("]. Sending INTERNAL_ERROR and closing connection.").toString());
                return FrameRenderer$.MODULE$.render(new FrameEvent.GoAwayFrame(0, Http2Protocol$ErrorCode$INTERNAL_ERROR$.MODULE$, FrameEvent$GoAwayFrame$.MODULE$.apply$default$3()));
            }
            if (throwable != null) {
                Throwable throwable2 = throwable;
                throw throwable2;
            }
            throw new MatchError((Object)throwable);
        }), (Graph)Flow$.MODULE$.apply());
    }

    public BidiFlow<FrameEvent, ByteString, ByteString, FrameEvent, NotUsed> framing(Http2ServerSettings http2ServerSettings, LoggingAdapter log) {
        return BidiFlow$.MODULE$.fromFlows((Graph)Flow$.MODULE$.apply().map((Function1 & Serializable)frame -> FrameRenderer$.MODULE$.render((FrameEvent)frame)), (Graph)Flow$.MODULE$.apply().via((Graph)new Http2FrameParsing(true, log)).via((Graph)new RSTFrameLimit(http2ServerSettings)));
    }

    public BidiFlow<FrameEvent, ByteString, ByteString, FrameEvent, NotUsed> framingClient(LoggingAdapter log) {
        return BidiFlow$.MODULE$.fromFlows((Graph)Flow$.MODULE$.apply().map((Function1 & Serializable)frame -> FrameRenderer$.MODULE$.render((FrameEvent)frame)).prepend((Graph)Source$.MODULE$.single((Object)Http2Protocol$.MODULE$.ClientConnectionPreface())), (Graph)Flow$.MODULE$.apply().via((Graph)new Http2FrameParsing(false, log)));
    }

    public BidiFlow<FrameEvent, FrameEvent, FrameEvent, FrameEvent, NotUsed> hpackCoding(HttpHeaderParser masterHttpHeaderParser, ParserSettings parserSettings) {
        return BidiFlow$.MODULE$.fromFlows((Graph)Flow$.MODULE$.apply().via((Graph)HeaderCompression$.MODULE$), (Graph)Flow$.MODULE$.apply().via((Graph)new HeaderDecompression(masterHttpHeaderParser, parserSettings)));
    }

    public BidiFlow<Http2SubStream, FrameEvent, FrameEvent, Http2SubStream, ServerTerminator> serverDemux(Http2ServerSettings settings, Seq<FrameEvent.Setting> initialDemuxerSettings, boolean upgraded) {
        return BidiFlow$.MODULE$.fromGraph((Graph)new Http2ServerDemux(settings, initialDemuxerSettings, upgraded));
    }

    public BidiFlow<Http2SubStream, FrameEvent, FrameEvent, Http2SubStream, ServerTerminator> clientDemux(Http2ClientSettings settings, HttpHeaderParser masterHttpHeaderParser) {
        return BidiFlow$.MODULE$.fromGraph((Graph)new Http2ClientDemux(settings, masterHttpHeaderParser));
    }

    public BidiFlow<HttpResponse, Http2SubStream, Http2SubStream, HttpRequest, NotUsed> httpLayer(ServerSettings settings, LoggingAdapter log, DateHeaderRendering dateHeaderRendering) {
        ParserSettings parserSettings = settings.parserSettings();
        HttpHeaderParser masterHttpHeaderParser = HttpHeaderParser$.MODULE$.apply(parserSettings, log);
        return RequestErrorFlow$.MODULE$.apply().atop((Graph)BidiFlow$.MODULE$.fromFlows((Graph)Flow$.MODULE$.apply().map((Function1)new ResponseRendering(settings, log, dateHeaderRendering)), (Graph)Flow$.MODULE$.apply().via(StreamUtils$.MODULE$.statefulAttrsMap((Function1 & Serializable)attrs -> {
            HttpHeaderParser headerParser = masterHttpHeaderParser.createShallowCopy();
            return RequestParsing$.MODULE$.parseRequest(headerParser, settings, (Attributes)attrs);
        }))));
    }

    public Flow<HttpRequest, HttpResponse, NotUsed> handleWithStreamIdHeader(int parallelism, Function1<HttpRequest, Future<HttpResponse>> handler, ExecutionContext ec) {
        return (Flow)Flow$.MODULE$.apply().mapAsyncUnordered(parallelism, (Function1 & Serializable)req -> Future$.MODULE$.apply((Function0 & Serializable)() -> {
            Future response = (Future)handler.apply(req);
            Option<Object> option = req.attribute(Http2$.MODULE$.streamId(), JavaMapping$.MODULE$.attributeKey());
            if (option instanceof Some) {
                Some some = (Some)option;
                int streamIdHeader = BoxesRunTime.unboxToInt((Object)some.value());
                return response.map((Function1 & Serializable)x$1 -> (HttpResponse)x$1.addAttribute((AttributeKey)Http2$.MODULE$.streamId(), BoxesRunTime.boxToInteger((int)streamIdHeader)), ec);
            }
            if (None$.MODULE$.equals(option)) {
                return response;
            }
            throw new MatchError(option);
        }, ec).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public void logParsingError(ErrorInfo info, LoggingAdapter log, ParserSettings.ErrorLoggingVerbosity setting) {
        ParserSettings.ErrorLoggingVerbosity errorLoggingVerbosity = setting;
        if (ParserSettings$ErrorLoggingVerbosity$Off$.MODULE$.equals(errorLoggingVerbosity)) {
            return;
        }
        if (ParserSettings$ErrorLoggingVerbosity$Simple$.MODULE$.equals(errorLoggingVerbosity)) {
            log.warning(info.summary());
            return;
        }
        if (ParserSettings$ErrorLoggingVerbosity$Full$.MODULE$.equals(errorLoggingVerbosity)) {
            log.warning(info.formatPretty());
            return;
        }
        throw new MatchError((Object)errorLoggingVerbosity);
    }

    public BidiFlow<ByteString, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, ByteString, NotUsed> unwrapTls() {
        return unwrapTls;
    }

    public <I1, O1, I2, O2, Mat> Http2Blueprint.BidiFlowExt<I1, O1, I2, O2, Mat> BidiFlowExt(BidiFlow<I1, O1, I2, O2, Mat> bidi) {
        return new Http2Blueprint.BidiFlowExt<I1, O1, I2, O2, Mat>(bidi);
    }

    private Http2Blueprint$() {
    }
}

