/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.client;

import akka.Done;
import akka.Done$;
import akka.actor.ActorRefFactory;
import akka.annotation.InternalStableApi;
import akka.event.LoggingAdapter;
import akka.http.impl.engine.client.PoolFlow;
import akka.http.impl.engine.client.PoolId;
import akka.http.impl.engine.client.PoolInterface$;
import akka.http.impl.engine.client.PoolInterface$ShutdownReason$IdleTimeout$;
import akka.http.impl.engine.client.PoolInterface$ShutdownReason$ShutdownRequested$;
import akka.http.impl.engine.client.PoolMaster;
import akka.http.impl.settings.HostConnectionPoolSetup;
import akka.http.impl.util.StreamUtils$;
import akka.http.impl.util.StreamUtils$CaptureTerminationOp$;
import akka.http.impl.util.package$;
import akka.http.impl.util.package$RichHttpRequest$;
import akka.http.javadsl.ConnectionContext;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.HttpResponse$;
import akka.http.scaladsl.model.OptHttpResponse$;
import akka.http.scaladsl.model.ResponseEntity;
import akka.http.scaladsl.model.Uri$;
import akka.http.scaladsl.model.headers.Host;
import akka.http.scaladsl.model.headers.Host$;
import akka.macros.LogHelper;
import akka.macros.LogHelperMacro;
import akka.stream.Attributes;
import akka.stream.BufferOverflowException;
import akka.stream.FlowShape;
import akka.stream.Inlet;
import akka.stream.Inlet$;
import akka.stream.Materializer;
import akka.stream.Outlet;
import akka.stream.Outlet$;
import akka.stream.stage.AsyncCallback;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.GraphStageWithMaterializedValue;
import akka.stream.stage.InHandler;
import akka.stream.stage.OutHandler;
import akka.stream.stage.TimerGraphStageLogic;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayDeque;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0011\u0005b\u0001\u00034h!\u0003\r\n!\\9\t\u000ba\u0004a\u0011\u0001>\t\u000f\u0005\u0015\u0002A\"\u0001\u0002(!91q\u001a\u0001\u0007\u0002\u0011}q\u0001CA\u001cO\"\u0005Q.!\u000f\u0007\u000f\u0019<\u0007\u0012A7\u0002<!9\u0011QH\u0003\u0005\u0002\u0005}bACA!\u000bA\u0005\u0019\u0013E7\u0002D\u001dA\u0011q]\u0003\t\u00025\fiE\u0002\u0005\u0002B\u0015A\t!\\A%\u0011\u001d\ti$\u0003C\u0001\u0003\u0017:q!!\u0015\n\u0011\u0003\u000b\u0019FB\u0004\u0002X%A\t)!\u0017\t\u000f\u0005uB\u0002\"\u0001\u0002|!I\u0011Q\u0010\u0007\u0002\u0002\u0013\u0005\u0013q\u0010\u0005\n\u0003#c\u0011\u0011!C\u0001\u0003'C\u0011\"a'\r\u0003\u0003%\t!!(\t\u0013\u0005%F\"!A\u0005B\u0005-\u0006\"CA]\u0019\u0005\u0005I\u0011AA^\u0011%\t)\rDA\u0001\n\u0003\n9\rC\u0005\u0002J2\t\t\u0011\"\u0011\u0002L\"I\u0011Q\u001a\u0007\u0002\u0002\u0013%\u0011qZ\u0004\b\u0003/L\u0001\u0012QAm\r\u001d\t9%\u0003EA\u00037Dq!!\u0010\u0018\t\u0003\ti\u000eC\u0005\u0002~]\t\t\u0011\"\u0011\u0002\u0000!I\u0011\u0011S\f\u0002\u0002\u0013\u0005\u00111\u0013\u0005\n\u00037;\u0012\u0011!C\u0001\u0003?D\u0011\"!+\u0018\u0003\u0003%\t%a+\t\u0013\u0005ev#!A\u0005\u0002\u0005\r\b\"CAc/\u0005\u0005I\u0011IAd\u0011%\tImFA\u0001\n\u0003\nY\rC\u0005\u0002N^\t\t\u0011\"\u0003\u0002P\"9\u0011\u0011^\u0003\u0005\u0002\u0005-\b\"CAl\u000b\t\u0007I\u0011BA@\u0011!\u0011)#\u0002Q\u0001\n\u0005\u0005eA\u0002B\u0014\u000b\u0001\u0011I\u0003\u0003\u0006\u0003\u0004\u0011\u0012\t\u0011)A\u0005\u0005\u000bA!B!\b%\u0005\u0003\u0005\u000b\u0011\u0002B\u0010\u0011)\u0011)\u0007\nB\u0001B\u0003%\u0011Q\u0013\u0005\u000b\u0005O\"#\u0011!Q\u0001\n\t%\u0004bBA\u001fI\u0011\u0005!Q\u000f\u0005\n\u0005\u0003##\u0019!C\u0005\u0005\u0007C\u0001Ba#%A\u0003%!Q\u0011\u0005\n\u0005\u001b##\u0019!C\u0005\u0005\u001fC\u0001Ba&%A\u0003%!\u0011\u0013\u0005\b\u00053#C\u0011\tBN\u0011\u001d\u0011i\n\nC!\u0005?CqA!(%\t\u0003\u00129L\u0002\u0004\u0003@\u0016!!\u0011\u0019\u0005\u000b\u0005\u0007\t$\u0011!Q\u0001\n\t\u0015\u0001B\u0003BMc\t\u0005\t\u0015!\u0003\u00038!Q!QD\u0019\u0003\u0002\u0003\u0006IAa\b\t\u0015\t\u0005\u0015G!A!\u0002\u0013\u0011)\t\u0003\u0006\u0003\u000eF\u0012\t\u0011)A\u0005\u0005#C!B!\u001a2\u0005\u0003\u0005\u000b\u0011BAK\u0011)\u00119'\rBC\u0002\u0013\u0005!\u0011\u001d\u0005\u000b\u0005G\f$\u0011!Q\u0001\n\t%\u0004B\u0003Bsc\t\u0005\t\u0015a\u0003\u0003h\"9\u0011QH\u0019\u0005\u0002\t5\b\u0002CB\u0002c\u0001\u0006Ia!\u0002\t\u0013\r-\u0011G1A\u0005\u0002\r5\u0001\u0002CB\u000ec\u0001\u0006Iaa\u0004\t\u0013\ru\u0011G1A\u0005\u0002\r}\u0001\u0002CB\u0017c\u0001\u0006Ia!\t\t\u0013\r=\u0012G1A\u0005\u0002\rE\u0002\u0002CB\u001bc\u0001\u0006Iaa\r\t\u000f\r]\u0012\u0007\"\u0001\u0004:!I11H\u0019A\u0002\u0013\u00051Q\b\u0005\n\u0007\u000b\n\u0004\u0019!C\u0001\u0007\u000fB\u0001ba\u00132A\u0003&1q\b\u0005\n\u0007\u001b\n\u0004\u0019!C\u0001\u0003'C\u0011ba\u00142\u0001\u0004%\ta!\u0015\t\u0011\rU\u0013\u0007)Q\u0005\u0003+C\u0011ba\u00162\u0005\u0004%\ta!\u0017\t\u0011\r\u001d\u0014\u0007)A\u0005\u00077Bqa!\u001b2\t\u0003\u001aY\u0007C\u0004\u0004nE\"\tfa\u001c\t\u000f\rU\u0014\u0007\"\u0011\u0004l!91qO\u0019\u0005B\r-\u0004\"CB=c\t\u0007I\u0011AB>\u0011!\u0019Y)\rQ\u0001\n\ru\u0004\"CBGc\t\u0007I\u0011ABH\u0011!\u0019)*\rQ\u0001\n\rE\u0005\"CBLc\t\u0007I\u0011ABM\u0011!\u0019i*\rQ\u0001\n\rm\u0005bBBPc\u0011\u000511\u000e\u0005\b\u0007C\u000bD\u0011ABR\u0011\u001d\u0019I+\rC\u0001\u0007WBqaa+2\t\u0003\u0019Y\u0007C\u0004\u0004.F\"\ta!\u000f\t\u000f\r=\u0016\u0007\"\u0011\u00042\"91QX\u0019\u0005B\r-\u0004B\u0002=2\t\u0003\u001ay\fC\u0004\u0002&E\"\te!2\t\u000f\r=\u0017\u0007\"\u0011\u0004R\"911[\u0019\u0005\u0002\rU\u0007bBBtc\u0011\u00051\u0011\u001e\u0005\b\u0007_\fD\u0011ABy\u0011\u001d!)!\rC\u0001\t\u000fA!\u0002\"\u0005\u0006\u0005\u0004%\t!\u001cC\n\u0011!!Y\"\u0002Q\u0001\n\u0011U!!\u0004)p_2Le\u000e^3sM\u0006\u001cWM\u0003\u0002iS\u000611\r\\5f]RT!A[6\u0002\r\u0015tw-\u001b8f\u0015\taW.\u0001\u0003j[Bd'B\u00018p\u0003\u0011AG\u000f\u001e9\u000b\u0003A\fA!Y6lCN\u0011\u0001A\u001d\t\u0003gZl\u0011\u0001\u001e\u0006\u0002k\u0006)1oY1mC&\u0011q\u000f\u001e\u0002\u0007\u0003:L(+\u001a4\u0002\u000fI,\u0017/^3ti\u000e\u0001A\u0003B>\u007f\u0003\u001f\u0001\"a\u001d?\n\u0005u$(\u0001B+oSRDQ\u0001_\u0001A\u0002}\u0004B!!\u0001\u0002\f5\u0011\u00111\u0001\u0006\u0005\u0003\u000b\t9!A\u0003n_\u0012,GNC\u0002\u0002\n5\f\u0001b]2bY\u0006$7\u000f\\\u0005\u0005\u0003\u001b\t\u0019AA\u0006IiR\u0004(+Z9vKN$\bbBA\t\u0003\u0001\u0007\u00111C\u0001\u0010e\u0016\u001c\bo\u001c8tKB\u0013x.\\5tKB1\u0011QCA\u000e\u0003?i!!a\u0006\u000b\u0007\u0005eA/\u0001\u0006d_:\u001cWO\u001d:f]RLA!!\b\u0002\u0018\t9\u0001K]8nSN,\u0007\u0003BA\u0001\u0003CIA!a\t\u0002\u0004\ta\u0001\n\u001e;q%\u0016\u001c\bo\u001c8tK\u0006A1\u000f[;uI><h\u000e\u0006\u0002\u0002*Q!\u00111\u0006C\u000f!\u0019\t)\"!\f\u00022%!\u0011qFA\f\u0005\u00191U\u000f^;sKB\u0019\u00111G\u0004\u000f\u0007\u0005UB!D\u0001h\u00035\u0001vn\u001c7J]R,'OZ1dKB\u0019\u0011QG\u0003\u0014\u0005\u0015\u0011\u0018A\u0002\u001fj]&$h\b\u0006\u0002\u0002:\tq1\u000b[;uI><hNU3bg>t7CA\u0004sS\r9q\u0003\u0004\u0002\f\u0013\u0012dW\rV5nK>,Ho\u0005\u0002\neR\u0011\u0011Q\n\t\u0004\u0003\u001fJQ\"A\u0003\u0002#MCW\u000f\u001e3po:\u0014V-];fgR,G\rE\u0002\u0002V1i\u0011!\u0003\u0002\u0012'\",H\u000fZ8x]J+\u0017/^3ti\u0016$7\u0003\u0003\u0007s\u00037\ni&a\u0019\u0011\u0007\u0005=s\u0001E\u0002t\u0003?J1!!\u0019u\u0005\u001d\u0001&o\u001c3vGR\u0004B!!\u001a\u0002v9!\u0011qMA9\u001d\u0011\tI'a\u001c\u000e\u0005\u0005-$bAA7s\u00061AH]8pizJ\u0011!^\u0005\u0004\u0003g\"\u0018a\u00029bG.\fw-Z\u0005\u0005\u0003o\nIH\u0001\u0007TKJL\u0017\r\\5{C\ndWMC\u0002\u0002tQ$\"!a\u0015\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\t\t\u0005\u0003\u0002\u0004\u00065UBAAC\u0015\u0011\t9)!#\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0017\u000bAA[1wC&!\u0011qRAC\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u0013\t\u0004g\u0006]\u0015bAAMi\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011qTAS!\r\u0019\u0018\u0011U\u0005\u0004\u0003G#(aA!os\"I\u0011q\u0015\t\u0002\u0002\u0003\u0007\u0011QS\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u00055\u0006CBAX\u0003k\u000by*\u0004\u0002\u00022*\u0019\u00111\u0017;\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00028\u0006E&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!0\u0002DB\u00191/a0\n\u0007\u0005\u0005GOA\u0004C_>dW-\u00198\t\u0013\u0005\u001d&#!AA\u0002\u0005}\u0015\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005U\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u0005\u0015\u0001D<sSR,'+\u001a9mC\u000e,GCAAi!\u0011\t\u0019)a5\n\t\u0005U\u0017Q\u0011\u0002\u0007\u001f\nTWm\u0019;\u0002\u0017%#G.\u001a+j[\u0016|W\u000f\u001e\t\u0004\u0003+:2\u0003C\fs\u00037\ni&a\u0019\u0015\u0005\u0005eG\u0003BAP\u0003CD\u0011\"a*\u001c\u0003\u0003\u0005\r!!&\u0015\t\u0005u\u0016Q\u001d\u0005\n\u0003Ok\u0012\u0011!a\u0001\u0003?\u000bab\u00155vi\u0012|wO\u001c*fCN|g.A\u0003baBd\u0017\u0010\u0006\u0005\u0002n\n\u0005!1\u0002B\u000e)\u0011\ty/!=\u0011\u0007\u0005U\u0002\u0001C\u0004\u0002t\u0006\u0002\u001d!!>\u0002\u0005\u0019l\u0007\u0003BA|\u0003{l!!!?\u000b\u0007\u0005mx.\u0001\u0004tiJ,\u0017-\\\u0005\u0005\u0003\u007f\fIP\u0001\u0007NCR,'/[1mSj,'\u000fC\u0004\u0003\u0004\u0005\u0002\rA!\u0002\u0002\rA|w\u000e\\%e!\u0011\t)Da\u0002\n\u0007\t%qM\u0001\u0004Q_>d\u0017\n\u001a\u0005\b\u0005\u001b\t\u0003\u0019\u0001B\b\u0003\u0019\u0001\u0018M]3oiB!!\u0011\u0003B\f\u001b\t\u0011\u0019BC\u0002\u0003\u0016=\fQ!Y2u_JLAA!\u0007\u0003\u0014\ty\u0011i\u0019;peJ+gMR1di>\u0014\u0018\u0010C\u0004\u0003\u001e\u0005\u0002\rAa\b\u0002\r5\f7\u000f^3s!\u0011\t)D!\t\n\u0007\t\rrM\u0001\u0006Q_>dW*Y:uKJ\fA\"\u00133mKRKW.Z8vi\u0002\u0012!\u0003U8pY&sG/\u001a:gC\u000e,7\u000b^1hKN\u0019AEa\u000b\u0011\u0011\t5\"1\u0007B\u001c\u0003_l!Aa\f\u000b\t\tE\u0012\u0011`\u0001\u0006gR\fw-Z\u0005\u0005\u0005k\u0011yCA\u0010He\u0006\u0004\bn\u0015;bO\u0016<\u0016\u000e\u001e5NCR,'/[1mSj,GMV1mk\u0016\u0004\u0002\"a>\u0003:\tu\"qL\u0005\u0005\u0005w\tIPA\u0005GY><8\u000b[1qKB!!q\bB-\u001d\u0011\u0011\tE!\u0016\u000f\t\t\r#1\u000b\b\u0005\u0005\u000b\u0012\tF\u0004\u0003\u0003H\t=c\u0002\u0002B%\u0005\u001brA!!\u001b\u0003L%\t\u0001/\u0003\u0002o_&\u0011A.\\\u0005\u0003U.L!\u0001[5\n\u0007\t]s-\u0001\u0005Q_>dg\t\\8x\u0013\u0011\u0011YF!\u0018\u0003\u001fI+7\u000f]8og\u0016\u001cuN\u001c;fqRT1Aa\u0016h!\u0011\u0011yD!\u0019\n\t\t\r$Q\f\u0002\u000f%\u0016\fX/Z:u\u0007>tG/\u001a=u\u0003)\u0011WO\u001a4feNK'0Z\u0001\u0004Y><\u0007\u0003\u0002B6\u0005cj!A!\u001c\u000b\u0007\t=t.A\u0003fm\u0016tG/\u0003\u0003\u0003t\t5$A\u0004'pO\u001eLgnZ!eCB$XM\u001d\u000b\u000b\u0005o\u0012IHa\u001f\u0003~\t}\u0004cAA(I!9!1A\u0015A\u0002\t\u0015\u0001b\u0002B\u000fS\u0001\u0007!q\u0004\u0005\b\u0005KJ\u0003\u0019AAK\u0011\u001d\u00119'\u000ba\u0001\u0005S\n!B]3rk\u0016\u001cHoT;u+\t\u0011)\t\u0005\u0004\u0002x\n\u001d%qL\u0005\u0005\u0005\u0013\u000bIP\u0001\u0004PkRdW\r^\u0001\fe\u0016\fX/Z:u\u001fV$\b%\u0001\u0006sKN\u0004xN\\:f\u0013:,\"A!%\u0011\r\u0005](1\u0013B\u001f\u0013\u0011\u0011)*!?\u0003\u000b%sG.\u001a;\u0002\u0017I,7\u000f]8og\u0016Le\u000eI\u0001\u0006g\"\f\u0007/Z\u000b\u0003\u0005o\tqd\u0019:fCR,Gj\\4jG\u0006sG-T1uKJL\u0017\r\\5{K\u00124\u0016\r\\;f)\u0011\u0011\tK!,\u0011\u000fM\u0014\u0019Ka*\u0002p&\u0019!Q\u0015;\u0003\rQ+\b\u000f\\33!\u0011\u0011iC!+\n\t\t-&q\u0006\u0002\u0010\u000fJ\f\u0007\u000f[*uC\u001e,Gj\\4jG\"9!qV\u0018A\u0002\tE\u0016aE5oQ\u0016\u0014\u0018\u000e^3e\u0003R$(/\u001b2vi\u0016\u001c\b\u0003BA|\u0005gKAA!.\u0002z\nQ\u0011\t\u001e;sS\n,H/Z:\u0015\r\t\u0005&\u0011\u0018B^\u0011\u001d\u0011y\u000b\ra\u0001\u0005cCqA!01\u0001\u0004\t)0A\u0007`[\u0006$XM]5bY&TXM\u001d\u0002\u0006\u0019><\u0017nY\n\fc\t\r\u0017q\u001eBe\u0005\u001f\u0014)\u000e\u0005\u0003\u0003.\t\u0015\u0017\u0002\u0002Bd\u0005_\u0011A\u0003V5nKJ<%/\u00199i'R\fw-\u001a'pO&\u001c\u0007\u0003\u0002B\u0017\u0005\u0017LAA!4\u00030\tI\u0011J\u001c%b]\u0012dWM\u001d\t\u0005\u0005[\u0011\t.\u0003\u0003\u0003T\n=\"AC(vi\"\u000bg\u000e\u001a7feB!!q\u001bBo\u001b\t\u0011INC\u0002\u0003\\>\fa!\\1de>\u001c\u0018\u0002\u0002Bp\u00053\u0014\u0011\u0002T8h\u0011\u0016d\u0007/\u001a:\u0016\u0005\t%\u0014\u0001\u00027pO\u0002\n\u0001#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0011\t\u0005U!\u0011^\u0005\u0005\u0005W\f9B\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yiR\u0001\"q\u001eB{\u0005o\u0014IPa?\u0003~\n}8\u0011\u0001\u000b\u0005\u0005c\u0014\u0019\u0010E\u0002\u0002PEBqA!:<\u0001\b\u00119\u000fC\u0004\u0003\u0004m\u0002\rA!\u0002\t\u000f\te5\b1\u0001\u00038!9!QD\u001eA\u0002\t}\u0001b\u0002BAw\u0001\u0007!Q\u0011\u0005\b\u0005\u001b[\u0004\u0019\u0001BI\u0011\u001d\u0011)g\u000fa\u0001\u0003+CqAa\u001a<\u0001\u0004\u0011I'A\u000bQ_>dwJ^3sM2|w/\u0012=dKB$\u0018n\u001c8\u0011\t\u0005]8qA\u0005\u0005\u0007\u0013\tIPA\fCk\u001a4WM](wKJ4Gn\\<Fq\u000e,\u0007\u000f^5p]\u0006!\u0001n\u00199t+\t\u0019y\u0001\u0005\u0003\u0004\u0012\r]QBAB\n\u0015\r\u0019)b[\u0001\tg\u0016$H/\u001b8hg&!1\u0011DB\n\u0005]Aun\u001d;D_:tWm\u0019;j_:\u0004vn\u001c7TKR,\b/A\u0003iGB\u001c\b%A\u0006jI2,G+[7f_V$XCAB\u0011!\u0011\u0019\u0019c!\u000b\u000e\u0005\r\u0015\"\u0002BB\u0014\u0003/\t\u0001\u0002Z;sCRLwN\\\u0005\u0005\u0007W\u0019)C\u0001\u0005EkJ\fG/[8o\u00031IG\r\\3US6,w.\u001e;!\u0003=\u0019\b.\u001e;e_^t\u0007K]8nSN,WCAB\u001a!\u0019\t)\"a\u0007\u0002\\\u0005\u00012\u000f[;uI><h\u000e\u0015:p[&\u001cX\rI\u0001\rg\",H\u000f^5oO\u0012{wO\\\u000b\u0003\u0003{\u000b!c\u001d5viRLgn\u001a#po:\u0014V-Y:p]V\u00111q\b\t\u0006g\u000e\u0005\u00131L\u0005\u0004\u0007\u0007\"(AB(qi&|g.\u0001\ftQV$H/\u001b8h\t><hNU3bg>tw\fJ3r)\rY8\u0011\n\u0005\n\u0003O+\u0015\u0011!a\u0001\u0007\u007f\t1c\u001d5viRLgn\u001a#po:\u0014V-Y:p]\u0002\n!C]3nC&t\u0017N\\4SKF,Xm\u001d;fI\u00061\"/Z7bS:Lgn\u001a*fcV,7\u000f^3e?\u0012*\u0017\u000fF\u0002|\u0007'B\u0011\"a*I\u0003\u0003\u0005\r!!&\u0002'I,W.Y5oS:<'+Z9vKN$X\r\u001a\u0011\u0002\r\t,hMZ3s+\t\u0019Y\u0006\u0005\u0004\u0004^\r\r$qL\u0007\u0003\u0007?RAa!\u0019\u0002\n\u0006!Q\u000f^5m\u0013\u0011\u0019)ga\u0018\u0003\u0015\u0005\u0013(/Y=EKF,X-A\u0004ck\u001a4WM\u001d\u0011\u0002\u0011A\u0014Xm\u0015;beR$\u0012a_\u0001\b_:$\u0016.\\3s)\rY8\u0011\u000f\u0005\b\u0007gj\u0005\u0019AAP\u0003!!\u0018.\\3s\u0017\u0016L\u0018AB8o!V\u001c\b.\u0001\u0004p]B+H\u000e\\\u0001\u001ae\u0016\u001c\bo\u001c8tK\u000e{W\u000e\u001d7fi\u0016$7)\u00197mE\u0006\u001c7.\u0006\u0002\u0004~A1!QFB@\u0007\u0007KAa!!\u00030\ti\u0011i]=oG\u000e\u000bG\u000e\u001c2bG.\u0004Ba!\"\u0004\b6\tq.C\u0002\u0004\n>\u0014A\u0001R8oK\u0006Q\"/Z:q_:\u001cXmQ8na2,G/\u001a3DC2d'-Y2lA\u0005y!/Z9vKN$8)\u00197mE\u0006\u001c7.\u0006\u0002\u0004\u0012B1!QFB@\u0007'\u0003ba\u001dBR\u007f\u0006M\u0011\u0001\u0005:fcV,7\u000f^\"bY2\u0014\u0017mY6!\u0003A\u0019\b.\u001e;e_^t7)\u00197mE\u0006\u001c7.\u0006\u0002\u0004\u001cB)!QFB@w\u0006\t2\u000f[;uI><hnQ1mY\n\f7m\u001b\u0011\u0002)\u00054G/\u001a:SKF,Xm\u001d;GS:L7\u000f[3e\u0003=\u0011X-];fgR\u001c\u0006.\u001e;e_^tGcA>\u0004&\"91qU,A\u0002\u0005m\u0013A\u0002:fCN|g.\u0001\u0010tQV$Hm\\<o\u0013\u001a\u0014V-];fgR,G-\u00118e!>\u001c8/\u001b2mK\u0006q!/Z:fi&#G.\u001a+j[\u0016\u0014\u0018\u0001E:i_VdGm\u0015;pa>s\u0017\n\u001a7f\u0003Eyg.\u00169tiJ,\u0017-\u001c$bS2,(/\u001a\u000b\u0004w\u000eM\u0006bBB[7\u0002\u00071qW\u0001\u0003Kb\u0004B!!\u001a\u0004:&!11XA=\u0005%!\u0006N]8xC\ndW-\u0001\u0005q_N$8\u000b^8q)\u0015Y8\u0011YBb\u0011\u0015AX\f1\u0001\u0000\u0011\u001d\t\t\"\u0018a\u0001\u0003'!\"aa2\u0015\t\r%71\u001a\t\u0007\u0003+\ti#a\u0017\t\u000f\r5g\fq\u0001\u0003h\u0006\u0011QmY\u0001\ro\",gn\u00155vi\u0012|wO\\\u000b\u0003\u0007\u0013\faa\u001c8J]&$HcA>\u0004X\"9!1\u00011A\u0002\t\u0015\u0001f\u00011\u0004\\B!1Q\\Br\u001b\t\u0019yNC\u0002\u0004b>\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0019)oa8\u0003#%sG/\u001a:oC2\u001cF/\u00192mK\u0006\u0003\u0018.\u0001\u0006p]\u0012K7\u000f]1uG\"$2a`Bv\u0011\u0015A\u0018\r1\u0001\u0000Q\r\t71\\\u0001\u000b_:\u0014Vm\u001d9p]N,GCBAP\u0007g\u001c)\u0010C\u0003yE\u0002\u0007q\u0010C\u0004\u0004x\n\u0004\ra!?\u0002\u0011I,7\u000f]8og\u0016\u0004baa?\u0004\u0000\u0006}QBAB\u007f\u0015\r\u0019\t\u0007^\u0005\u0005\t\u0003\u0019iPA\u0002UefD3AYBn\u0003IygNU3ta>t7/Z\"p[BdW\r^3\u0015\u0007m$I\u0001C\u0004\u0005\f\r\u0004\r!a(\u0002\u0007\u0005t\u0017\u0010K\u0002d\u00077D3!MBn\u00035\u0001vn\u001c7M_\u001e\u001cv.\u001e:dKV\u0011AQ\u0003\t\u0007\u0005W\"9B!\u0002\n\t\u0011e!Q\u000e\u0002\n\u0019><7k\\;sG\u0016\fa\u0002U8pY2{wmU8ve\u000e,\u0007\u0005C\u0004\u0004N\n\u0001\u001dAa:\u0016\u0005\u0005-\u0002")
public interface PoolInterface {
    public static PoolInterface apply(PoolId poolId, ActorRefFactory parent, PoolMaster master, Materializer fm) {
        return PoolInterface$.MODULE$.apply(poolId, parent, master, fm);
    }

    public void request(HttpRequest var1, Promise<HttpResponse> var2);

    public Future<ShutdownReason> shutdown(ExecutionContext var1);

    public Future<ShutdownReason> whenShutdown();

    @InternalStableApi
    private static class Logic
    extends TimerGraphStageLogic
    implements PoolInterface,
    InHandler,
    OutHandler,
    LogHelper {
        private final PoolId poolId;
        private final PoolMaster master;
        private final Outlet<PoolFlow.RequestContext> requestOut;
        private final Inlet<PoolFlow.ResponseContext> responseIn;
        private final int bufferSize;
        private final LoggingAdapter log;
        private final ExecutionContext executionContext;
        private final BufferOverflowException PoolOverflowException;
        private final HostConnectionPoolSetup hcps;
        private final Duration idleTimeout;
        private final Promise<ShutdownReason> shutdownPromise;
        private Option<ShutdownReason> shuttingDownReason;
        private int remainingRequested;
        private final ArrayDeque<PoolFlow.RequestContext> buffer;
        private final AsyncCallback<Done> responseCompletedCallback;
        private final AsyncCallback<Tuple2<HttpRequest, Promise<HttpResponse>>> requestCallback;
        private final AsyncCallback<BoxedUnit> shutdownCallback;

        public boolean isDebugEnabled() {
            return LogHelper.isDebugEnabled$((LogHelper)this);
        }

        public boolean isInfoEnabled() {
            return LogHelper.isInfoEnabled$((LogHelper)this);
        }

        public boolean isWarningEnabled() {
            return LogHelper.isWarningEnabled$((LogHelper)this);
        }

        public String prefixString() {
            return LogHelper.prefixString$((LogHelper)this);
        }

        public void onDownstreamFinish() throws Exception {
            OutHandler.onDownstreamFinish$((OutHandler)this);
        }

        public void onDownstreamFinish(Throwable cause) throws Exception {
            OutHandler.onDownstreamFinish$((OutHandler)this, (Throwable)cause);
        }

        public void onUpstreamFinish() throws Exception {
            InHandler.onUpstreamFinish$((InHandler)this);
        }

        public LoggingAdapter log() {
            return this.log;
        }

        public HostConnectionPoolSetup hcps() {
            return this.hcps;
        }

        public Duration idleTimeout() {
            return this.idleTimeout;
        }

        public Promise<ShutdownReason> shutdownPromise() {
            return this.shutdownPromise;
        }

        public boolean shuttingDown() {
            return this.shuttingDownReason().isDefined();
        }

        public Option<ShutdownReason> shuttingDownReason() {
            return this.shuttingDownReason;
        }

        public void shuttingDownReason_$eq(Option<ShutdownReason> x$1) {
            this.shuttingDownReason = x$1;
        }

        public int remainingRequested() {
            return this.remainingRequested;
        }

        public void remainingRequested_$eq(int x$1) {
            this.remainingRequested = x$1;
        }

        public ArrayDeque<PoolFlow.RequestContext> buffer() {
            return this.buffer;
        }

        public void preStart() {
            this.onInit(this.poolId);
            this.pull(this.responseIn);
            this.resetIdleTimer();
        }

        public void onTimer(Object timerKey) {
            BoxedUnit boxedUnit;
            Logic logHelper = this;
            if (logHelper.isDebugEnabled()) {
                logHelper.log().debug(new StringBuilder(88).append(logHelper.prefixString()).append("Pool shutting down because akka.http.host-connection-pool.idle-timeout triggered after ").append(this.idleTimeout()).append(".").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.requestShutdown(PoolInterface$ShutdownReason$IdleTimeout$.MODULE$);
        }

        /*
         * Unable to fully structure code
         */
        public void onPush() {
            var5_1 = (PoolFlow.ResponseContext)this.grab(this.responseIn);
            if (var5_1 == null) {
                throw new MatchError((Object)var5_1);
            }
            rc = var5_1.rc();
            response0 = var5_1.response();
            var4_4 = new Tuple2((Object)rc, response0);
            rc = (PoolFlow.RequestContext)var4_4._1();
            response0 = (Try)var4_4._2();
            ctx = this.onResponse(rc.request(), (Try<HttpResponse>)response0);
            var12_8 = false;
            var13_9 = null;
            var14_10 = response0;
            if (!(var14_10 instanceof Success)) ** GOTO lbl-1000
            var12_8 = true;
            var13_9 = (Success)var14_10;
            r = (HttpResponse)var13_9.value();
            if (r != null && !OptHttpResponse$.MODULE$.isEmpty$extension(var16_12 = HttpResponse$.MODULE$.unapply(r)) && !(entity = var16_12._3()).isStrict()) {
                var19_14 = StreamUtils$.MODULE$.transformEntityStream(entity, StreamUtils$CaptureTerminationOp$.MODULE$);
                if (var19_14 == null) {
                    throw new MatchError(var19_14);
                }
                newEntity = (ResponseEntity)var19_14._1();
                termination = (Future)var19_14._2();
                var18_17 = new Tuple2((Object)newEntity, (Object)termination);
                newEntity = (ResponseEntity)var18_17._1();
                termination = (Future)var18_17._2();
                termination.onComplete((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$onPush$1$adapted(akka.http.impl.engine.client.PoolInterface$Logic scala.util.Try ), (Lscala/util/Try;)Ljava/lang/Object;)((Logic)this), this.executionContext);
                v0 = new Success((Object)r.withEntity(newEntity));
            } else if (var12_8) {
                response = (HttpResponse)var13_9.value();
                this.remainingRequested_$eq(this.remainingRequested() - 1);
                v0 = new Success((Object)response);
            } else if (var14_10 instanceof Failure) {
                this.remainingRequested_$eq(this.remainingRequested() - 1);
                v0 = response0;
            } else {
                throw new MatchError((Object)var14_10);
            }
            response1 = v0;
            rc.responsePromise().complete(response1);
            this.onResponseComplete(ctx);
            this.pull(this.responseIn);
            this.afterRequestFinished();
        }

        public void onPull() {
            if (!this.buffer().isEmpty()) {
                BoxedUnit boxedUnit;
                PoolFlow.RequestContext ctx = this.buffer().removeFirst();
                Logic logHelper = this;
                if (logHelper.isDebugEnabled()) {
                    logHelper.log().debug(new StringBuilder(63).append(logHelper.prefixString()).append("Dispatching request [").append(package$RichHttpRequest$.MODULE$.debugString$extension(package$.MODULE$.RichHttpRequest(ctx.request()))).append("] from buffer to pool. Remaining buffer: ").append(this.buffer().size()).append("/").append(this.bufferSize).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.push(this.requestOut, ctx);
                return;
            }
        }

        public AsyncCallback<Done> responseCompletedCallback() {
            return this.responseCompletedCallback;
        }

        public AsyncCallback<Tuple2<HttpRequest, Promise<HttpResponse>>> requestCallback() {
            return this.requestCallback;
        }

        public AsyncCallback<BoxedUnit> shutdownCallback() {
            return this.shutdownCallback;
        }

        public void afterRequestFinished() {
            this.shutdownIfRequestedAndPossible();
            this.resetIdleTimer();
        }

        public void requestShutdown(ShutdownReason reason) {
            this.shuttingDownReason_$eq((Option<ShutdownReason>)new Some((Object)reason));
            this.shutdownIfRequestedAndPossible();
        }

        public void shutdownIfRequestedAndPossible() {
            if (this.shuttingDown()) {
                BoxedUnit boxedUnit;
                if (this.remainingRequested() == 0) {
                    BoxedUnit boxedUnit2;
                    Logic logHelper = this;
                    if (logHelper.isDebugEnabled()) {
                        logHelper.log().debug(new StringBuilder(39).append(logHelper.prefixString()).append("Pool is now shutting down as requested.").toString());
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    this.shutdownPromise().trySuccess(this.shuttingDownReason().get());
                    this.completeStage();
                    return;
                }
                Logic logHelper = this;
                if (logHelper.isDebugEnabled()) {
                    logHelper.log().debug(new StringBuilder(64).append(logHelper.prefixString()).append("Pool is shutting down after waiting for [").append(this.remainingRequested()).append("] outstanding requests.").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
        }

        public void resetIdleTimer() {
            this.cancelTimer(PoolInterface$.MODULE$.akka$http$impl$engine$client$PoolInterface$$IdleTimeout());
            if (this.shouldStopOnIdle()) {
                this.scheduleOnce(PoolInterface$.MODULE$.akka$http$impl$engine$client$PoolInterface$$IdleTimeout(), (FiniteDuration)this.idleTimeout());
                return;
            }
        }

        public boolean shouldStopOnIdle() {
            return !this.shuttingDown() && this.remainingRequested() == 0 && this.idleTimeout().isFinite() && this.hcps().setup().settings().minConnections() == 0;
        }

        public void onUpstreamFailure(Throwable ex) {
            this.shutdownPromise().tryFailure(ex);
        }

        public void postStop() {
            this.shutdownPromise().tryFailure((Throwable)new IllegalStateException("Pool shutdown unexpectedly"));
        }

        @Override
        public void request(HttpRequest request, Promise<HttpResponse> responsePromise) {
            this.requestCallback().invokeWithFeedback((Object)new Tuple2((Object)request, responsePromise)).failed().foreach((Function1 & Serializable)x$6 -> {
                BoxedUnit boxedUnit;
                Logic logHelper = this;
                if (logHelper.isDebugEnabled()) {
                    logHelper.log().debug(new StringBuilder(106).append(logHelper.prefixString()).append("Request was sent to pool which was already closed, retrying through the master to create new pool instance").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return responsePromise.tryCompleteWith($this.master.dispatchRequest($this.poolId, request, this.materializer()));
            }, this.executionContext);
        }

        @Override
        public Future<ShutdownReason> shutdown(ExecutionContext ec) {
            this.shutdownCallback().invoke((Object)BoxedUnit.UNIT);
            return this.whenShutdown();
        }

        @Override
        public Future<ShutdownReason> whenShutdown() {
            return this.shutdownPromise().future();
        }

        @InternalStableApi
        public void onInit(PoolId poolId) {
        }

        @InternalStableApi
        public HttpRequest onDispatch(HttpRequest request) {
            return request;
        }

        @InternalStableApi
        public Object onResponse(HttpRequest request, Try<HttpResponse> response) {
            return None$.MODULE$;
        }

        @InternalStableApi
        public void onResponseComplete(Object any) {
        }

        public static final /* synthetic */ void $anonfun$onPush$1(Logic $this, Try x$3) {
            $this.responseCompletedCallback().invoke((Object)Done$.MODULE$);
        }

        public static final /* synthetic */ void $anonfun$responseCompletedCallback$1(Logic $this, Done x$4) {
            $this.remainingRequested_$eq($this.remainingRequested() - 1);
            $this.afterRequestFinished();
        }

        public static final /* synthetic */ void $anonfun$requestCallback$1(Logic $this, Tuple2 x0$1) {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                BoxedUnit boxedUnit;
                HttpRequest request = (HttpRequest)tuple2._1();
                Promise responsePromise = (Promise)tuple2._2();
                String scheme = Uri$.MODULE$.httpScheme(((ConnectionContext)((Object)$this.hcps().setup().connectionContext())).isSecure());
                Host hostHeader = Host$.MODULE$.apply($this.hcps().host(), Uri$.MODULE$.normalizePort($this.hcps().port(), scheme));
                HttpRequest effectiveRequest = $this.onDispatch((HttpRequest)request.withUri(request.uri().toHttpRequestTargetOriginForm()).withDefaultHeaders(hostHeader, (Seq<HttpHeader>)Nil$.MODULE$));
                int retries = request.method().isIdempotent() ? $this.hcps().setup().settings().maxRetries() : 0;
                $this.remainingRequested_$eq($this.remainingRequested() + 1);
                $this.resetIdleTimer();
                PoolFlow.RequestContext ctx = new PoolFlow.RequestContext(effectiveRequest, (Promise<HttpResponse>)responsePromise, retries);
                if ($this.isAvailable($this.requestOut)) {
                    BoxedUnit boxedUnit2;
                    Logic logHelper = $this;
                    if (logHelper.isDebugEnabled()) {
                        logHelper.log().debug(new StringBuilder(30).append(logHelper.prefixString()).append("Dispatching request [").append(package$RichHttpRequest$.MODULE$.debugString$extension(package$.MODULE$.RichHttpRequest(request))).append("] to pool").toString());
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    $this.push($this.requestOut, ctx);
                    return;
                }
                if ($this.buffer().size() < $this.bufferSize) {
                    $this.buffer().addLast(ctx);
                    Logic logHelper = $this;
                    if (logHelper.isDebugEnabled()) {
                        logHelper.log().debug(new StringBuilder(34).append(logHelper.prefixString()).append("Buffering request [").append(package$RichHttpRequest$.MODULE$.debugString$extension(package$.MODULE$.RichHttpRequest(request))).append("] at position ").append($this.buffer().size()).append("/").append($this.bufferSize).toString());
                        return;
                    }
                    return;
                }
                Logic logHelper = $this;
                if (logHelper.isDebugEnabled()) {
                    logHelper.log().debug(new StringBuilder(52).append(logHelper.prefixString()).append("Could not dispatch request [").append(package$RichHttpRequest$.MODULE$.debugString$extension(package$.MODULE$.RichHttpRequest(request))).append("] because buffer is full").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                responsePromise.tryFailure((Throwable)$this.PoolOverflowException);
                return;
            }
            throw new MatchError((Object)tuple2);
        }

        public Logic(PoolId poolId, FlowShape<PoolFlow.ResponseContext, PoolFlow.RequestContext> shape, PoolMaster master, Outlet<PoolFlow.RequestContext> requestOut, Inlet<PoolFlow.ResponseContext> responseIn, int bufferSize, LoggingAdapter log, ExecutionContext executionContext) {
            this.poolId = poolId;
            this.master = master;
            this.requestOut = requestOut;
            this.responseIn = responseIn;
            this.bufferSize = bufferSize;
            this.log = log;
            this.executionContext = executionContext;
            super(shape);
            InHandler.$init$((InHandler)this);
            OutHandler.$init$((OutHandler)this);
            LogHelperMacro.$init$((LogHelperMacro)this);
            LogHelper.$init$((LogHelper)this);
            this.PoolOverflowException = new BufferOverflowException(new StringBuilder(370).append("Exceeded configured max-open-requests value of [").append(poolId.hcps().setup().settings().maxOpenRequests()).append("]. This means that the request queue of this pool (").append(poolId.hcps()).append(") ").append("has completely filled up because the pool currently does not process requests fast enough to handle the incoming request load. ").append("Please retry the request later. See https://doc.akka.io/docs/akka-http/current/scala/http/client-side/pool-overflow.html for ").append("more information.").toString());
            this.hcps = poolId.hcps();
            this.idleTimeout = this.hcps().setup().settings().idleTimeout();
            this.shutdownPromise = Promise$.MODULE$.apply();
            this.shuttingDownReason = None$.MODULE$;
            this.remainingRequested = 0;
            this.buffer = new ArrayDeque(bufferSize);
            this.setHandlers(responseIn, requestOut, this);
            this.responseCompletedCallback = this.getAsyncCallback((Function1 & Serializable)x$4 -> {
                Logic.$anonfun$responseCompletedCallback$1(this, x$4);
                return BoxedUnit.UNIT;
            });
            this.requestCallback = this.getAsyncCallback((Function1 & Serializable)x0$1 -> {
                Logic.$anonfun$requestCallback$1(this, x0$1);
                return BoxedUnit.UNIT;
            });
            this.shutdownCallback = this.getAsyncCallback((Function1 & Serializable)x$5 -> {
                this.requestShutdown(PoolInterface$ShutdownReason$ShutdownRequested$.MODULE$);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ Object $anonfun$onPush$1$adapted(Logic $this, Try x$3) {
            Logic.$anonfun$onPush$1($this, x$3);
            return BoxedUnit.UNIT;
        }
    }

    public static class PoolInterfaceStage
    extends GraphStageWithMaterializedValue<FlowShape<PoolFlow.ResponseContext, PoolFlow.RequestContext>, PoolInterface> {
        private final PoolId poolId;
        private final PoolMaster master;
        private final int bufferSize;
        private final LoggingAdapter log;
        private final Outlet<PoolFlow.RequestContext> requestOut;
        private final Inlet<PoolFlow.ResponseContext> responseIn;

        private Outlet<PoolFlow.RequestContext> requestOut() {
            return this.requestOut;
        }

        private Inlet<PoolFlow.ResponseContext> responseIn() {
            return this.responseIn;
        }

        public FlowShape<PoolFlow.ResponseContext, PoolFlow.RequestContext> shape() {
            return new FlowShape(this.responseIn(), this.requestOut());
        }

        public Tuple2<GraphStageLogic, PoolInterface> createLogicAndMaterializedValue(Attributes inheritedAttributes) {
            throw new IllegalStateException("Should not be called");
        }

        public Tuple2<GraphStageLogic, PoolInterface> createLogicAndMaterializedValue(Attributes inheritedAttributes, Materializer _materializer) {
            Logic logic = new Logic(this.poolId, this.shape(), this.master, this.requestOut(), this.responseIn(), this.bufferSize, this.log, (ExecutionContext)_materializer.executionContext());
            return new Tuple2((Object)logic, (Object)logic);
        }

        public PoolInterfaceStage(PoolId poolId, PoolMaster master, int bufferSize, LoggingAdapter log) {
            this.poolId = poolId;
            this.master = master;
            this.bufferSize = bufferSize;
            this.log = log;
            this.requestOut = Outlet$.MODULE$.apply("PoolInterface.requestOut");
            this.responseIn = Inlet$.MODULE$.apply("PoolInterface.responseIn");
        }
    }

    public static interface ShutdownReason {
    }
}

