/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsArchiveEntry;
import de.schlichtherle.truezip.fs.FsCacheController;
import de.schlichtherle.truezip.fs.FsContextController;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDriver;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsLockController;
import de.schlichtherle.truezip.fs.FsLockModel;
import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsOutputOptions;
import de.schlichtherle.truezip.fs.FsResourceController;
import de.schlichtherle.truezip.fs.FsSyncController;
import de.schlichtherle.truezip.fs.FsTargetArchiveController;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.CharConversionException;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;
import javax.swing.Icon;

@Immutable
public abstract class FsArchiveDriver<E extends FsArchiveEntry>
extends FsDriver {
    @Override
    public final boolean isFederated() {
        return true;
    }

    @Override
    public final FsController<? extends FsModel> newController(FsManager manager, FsModel model, @CheckForNull FsController<? extends FsModel> parent) {
        assert (parent.getModel().equals(model.getParent()));
        return manager.newController(this, model, parent);
    }

    @Override
    public FsController<?> newController(FsModel model, @Nonnull FsController<?> parent) {
        assert (model.getParent().equals(parent.getModel()));
        assert (!(model instanceof FsLockModel));
        return new FsLockController(new FsSyncController(new FsCacheController(this.getPool(), new FsResourceController(new FsContextController(new FsTargetArchiveController(this, new FsLockModel(model), parent))))));
    }

    protected abstract IOPool<?> getPool();

    public boolean getRedundantContentSupport() {
        return false;
    }

    public boolean getRedundantMetaDataSupport() {
        return false;
    }

    @CheckForNull
    public Icon getOpenIcon(FsModel model) {
        return null;
    }

    @CheckForNull
    public Icon getClosedIcon(FsModel model) {
        return null;
    }

    public InputSocket<?> getInputSocket(FsController<?> controller, FsEntryName name, BitField<FsInputOption> options) {
        return controller.getInputSocket(name, options);
    }

    @CreatesObligation
    public abstract InputShop<E> newInputShop(FsModel var1, InputSocket<?> var2) throws IOException;

    public OutputSocket<?> getOutputSocket(FsController<?> controller, FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        return controller.getOutputSocket(name, options, template);
    }

    @CreatesObligation
    public abstract OutputShop<E> newOutputShop(FsModel var1, OutputSocket<?> var2, @CheckForNull @WillNotClose InputShop<E> var3) throws IOException;

    public final E newEntry(String name, Entry.Type type, @CheckForNull Entry template) throws CharConversionException {
        return this.newEntry(name, type, template, FsOutputOptions.NONE);
    }

    public abstract E newEntry(String var1, Entry.Type var2, @CheckForNull Entry var3, BitField<FsOutputOption> var4) throws CharConversionException;

    protected void assertEncodable(String name) throws CharConversionException {
    }
}

