/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.origin;

import java.io.IOException;
import org.springframework.boot.origin.JarUri;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginTrackedResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.ObjectUtils;

public class TextResourceOrigin
implements Origin {
    private final Resource resource;
    private final Location location;

    public TextResourceOrigin(Resource resource, Location location) {
        this.resource = resource;
        this.location = location;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Location getLocation() {
        return this.location;
    }

    @Override
    public Origin getParent() {
        return Origin.from(this.resource);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof TextResourceOrigin) {
            TextResourceOrigin other = (TextResourceOrigin)obj;
            boolean result = true;
            result = result && ObjectUtils.nullSafeEquals((Object)this.resource, (Object)other.resource);
            result = result && ObjectUtils.nullSafeEquals((Object)this.location, (Object)other.location);
            return result;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.resource);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.location);
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getResourceDescription(this.resource));
        if (this.location != null) {
            result.append(" - ").append(this.location);
        }
        return result.toString();
    }

    private String getResourceDescription(Resource resource) {
        if (resource instanceof OriginTrackedResource) {
            return this.getResourceDescription(((OriginTrackedResource)resource).getResource());
        }
        if (resource == null) {
            return "unknown resource [?]";
        }
        if (resource instanceof ClassPathResource) {
            return this.getResourceDescription((ClassPathResource)resource);
        }
        return resource.getDescription();
    }

    private String getResourceDescription(ClassPathResource resource) {
        try {
            JarUri jarUri = JarUri.from(resource.getURI());
            if (jarUri != null) {
                return jarUri.getDescription(resource.getDescription());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return resource.getDescription();
    }

    public static final class Location {
        private final int line;
        private final int column;

        public Location(int line, int column) {
            this.line = line;
            this.column = column;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Location other = (Location)obj;
            boolean result = true;
            result = result && this.line == other.line;
            result = result && this.column == other.column;
            return result;
        }

        public int hashCode() {
            return 31 * this.line + this.column;
        }

        public String toString() {
            return this.line + 1 + ":" + (this.column + 1);
        }
    }
}

