/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import org.springframework.aop.Advisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.security.authorization.method.AuthorizationManagerBeforeMethodInterceptor;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;

@Configuration(proxyBeanMethods=false)
@Role(value=2)
final class SecuredMethodSecurityConfiguration {
    private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();

    SecuredMethodSecurityConfiguration() {
    }

    @Bean
    @Role(value=2)
    Advisor securedAuthorizationMethodInterceptor() {
        AuthorizationManagerBeforeMethodInterceptor interceptor = AuthorizationManagerBeforeMethodInterceptor.secured();
        interceptor.setSecurityContextHolderStrategy(this.securityContextHolderStrategy);
        return interceptor;
    }

    @Autowired(required=false)
    void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
        this.securityContextHolderStrategy = securityContextHolderStrategy;
    }
}

