/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;

public abstract class TransportIpAddress
extends IpAddress {
    private static final LogAdapter logger = LogFactory.getLogger(TransportIpAddress.class);
    static final long serialVersionUID = 695596530250216972L;
    protected int port = 0;

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Illegal port specified: " + n);
        }
        this.port = n;
    }

    public boolean isValid() {
        return super.isValid() && this.port >= 0 && this.port <= 65535;
    }

    public int compareTo(Object object) {
        int n = super.compareTo(object);
        if (n == 0) {
            return this.port - ((TransportIpAddress)object).getPort();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof TransportIpAddress) {
            return super.equals(object) && ((TransportIpAddress)object).getPort() == this.port;
        }
        return false;
    }

    public boolean parseAddress(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            if (super.parseAddress(string2)) {
                this.port = Integer.parseInt(string3);
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Address parse(String string) {
        try {
            UdpAddress udpAddress = new UdpAddress();
            if (udpAddress.parseAddress(string)) {
                return udpAddress;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String toString() {
        return super.toString() + "/" + this.port;
    }

    public int hashCode() {
        return super.hashCode() ^ 2 + this.port;
    }

    public void setTransportAddress(OctetString octetString) throws UnknownHostException {
        OctetString octetString2 = octetString.substring(0, octetString.length() - 2);
        this.setInetAddress(InetAddress.getByAddress(octetString2.getValue()));
        this.port = (octetString.get(octetString.length() - 2) & 0xFF) << 8;
        this.port += octetString.get(octetString.length() - 1) & 0xFF;
    }

    public byte[] getValue() {
        byte[] byArray = this.getInetAddress().getAddress();
        byte[] byArray2 = new byte[byArray.length + 2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray.length] = (byte)(this.port >> 8 & 0xFF);
        byArray2[byArray.length + 1] = (byte)(this.port & 0xFF);
        return byArray2;
    }

    public void decodeBER(BERInputStream bERInputStream) throws IOException {
        OctetString octetString = new OctetString();
        octetString.decodeBER(bERInputStream);
        try {
            this.setTransportAddress(octetString);
        }
        catch (Exception exception) {
            String string = "Wrong encoding of TransportAddress";
            logger.error(string);
            throw new IOException(string + ": " + exception.getMessage());
        }
    }

    public void encodeBER(OutputStream outputStream) throws IOException {
        OctetString octetString = new OctetString(this.getValue());
        octetString.encodeBER(outputStream);
    }

    public int getBERLength() {
        return this.getInetAddress().getAddress().length + 2;
    }

    public int getBERPayloadLength() {
        return this.getBERLength();
    }

    public int getSyntax() {
        return 4;
    }
}

