/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.jffi;

import com.kenai.jffi.Function;
import com.kenai.jffi.HeapInvocationBuffer;
import com.kenai.jffi.MemoryIO;
import com.kenai.jffi.Platform;
import org.python.core.Py;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.modules.jffi.CType;
import org.python.modules.jffi.Invoker;
import org.python.modules.jffi.JITRuntime;
import org.python.modules.jffi.NativeType;
import org.python.modules.jffi.Pointer;
import org.python.modules.jffi.StringCData;
import org.python.modules.jffi.Util;

class DefaultInvokerFactory {
    public static final DefaultInvokerFactory getFactory() {
        return SingletonHolder.INSTANCE;
    }

    private DefaultInvokerFactory() {
    }

    final Invoker createInvoker(Function function, PyObject returnType, PyObject[] parameterTypes) {
        ParameterMarshaller[] marshallers = new ParameterMarshaller[parameterTypes.length];
        for (int i = 0; i < marshallers.length; ++i) {
            marshallers[i] = DefaultInvokerFactory.getMarshaller(parameterTypes[i]);
        }
        return this.createInvoker(function, returnType, marshallers);
    }

    final Invoker createInvoker(Function function, CType[] parameterTypes, CType returnType) {
        ParameterMarshaller[] marshallers = new ParameterMarshaller[parameterTypes.length];
        for (int i = 0; i < marshallers.length; ++i) {
            marshallers[i] = DefaultInvokerFactory.getMarshaller(parameterTypes[i]);
        }
        return this.createInvoker(function, (PyObject)returnType, marshallers);
    }

    final Invoker createInvoker(Function function, NativeType[] parameterTypes, NativeType returnType) {
        ParameterMarshaller[] marshallers = new ParameterMarshaller[parameterTypes.length];
        for (int i = 0; i < marshallers.length; ++i) {
            marshallers[i] = DefaultInvokerFactory.getMarshaller(parameterTypes[i]);
        }
        return this.createInvoker(function, returnType, marshallers);
    }

    final Invoker createInvoker(Function function, PyObject returnType, ParameterMarshaller[] marshallers) {
        CType cReturnType = CType.typeOf(returnType);
        if (cReturnType instanceof CType.Builtin) {
            return this.createInvoker(function, cReturnType.getNativeType(), marshallers);
        }
        throw Py.RuntimeError("Unsupported return type: " + returnType);
    }

    final Invoker createInvoker(Function function, NativeType returnType, ParameterMarshaller[] marshallers) {
        switch (returnType) {
            case VOID: {
                return new VoidInvoker(function, marshallers);
            }
            case BYTE: {
                return new Signed8Invoker(function, marshallers);
            }
            case UBYTE: {
                return new Unsigned8Invoker(function, marshallers);
            }
            case SHORT: {
                return new Signed16Invoker(function, marshallers);
            }
            case USHORT: {
                return new Unsigned16Invoker(function, marshallers);
            }
            case INT: {
                return new Signed32Invoker(function, marshallers);
            }
            case UINT: {
                return new Unsigned32Invoker(function, marshallers);
            }
            case LONGLONG: {
                return new Signed64Invoker(function, marshallers);
            }
            case ULONGLONG: {
                return new Unsigned64Invoker(function, marshallers);
            }
            case LONG: {
                return Platform.getPlatform().longSize() == 32 ? new Signed32Invoker(function, marshallers) : new Signed64Invoker(function, marshallers);
            }
            case ULONG: {
                return Platform.getPlatform().longSize() == 32 ? new Unsigned32Invoker(function, marshallers) : new Unsigned64Invoker(function, marshallers);
            }
            case FLOAT: {
                return new FloatInvoker(function, marshallers);
            }
            case DOUBLE: {
                return new DoubleInvoker(function, marshallers);
            }
            case POINTER: {
                return new PointerInvoker(function, marshallers);
            }
            case STRING: {
                return new StringInvoker(function, marshallers);
            }
        }
        throw Py.RuntimeError("Unsupported return type: " + (Object)((Object)returnType));
    }

    static final ParameterMarshaller getMarshaller(NativeType type) {
        switch (type) {
            case BYTE: {
                return Signed8Marshaller.INSTANCE;
            }
            case UBYTE: {
                return Unsigned8Marshaller.INSTANCE;
            }
            case SHORT: {
                return Signed16Marshaller.INSTANCE;
            }
            case USHORT: {
                return Unsigned16Marshaller.INSTANCE;
            }
            case INT: {
                return Signed32Marshaller.INSTANCE;
            }
            case UINT: {
                return Unsigned32Marshaller.INSTANCE;
            }
            case LONGLONG: {
                return Signed64Marshaller.INSTANCE;
            }
            case ULONGLONG: {
                return Unsigned64Marshaller.INSTANCE;
            }
            case LONG: {
                return Platform.getPlatform().longSize() == 32 ? Signed32Marshaller.INSTANCE : Signed64Marshaller.INSTANCE;
            }
            case ULONG: {
                return Platform.getPlatform().longSize() == 32 ? Unsigned32Marshaller.INSTANCE : Unsigned64Marshaller.INSTANCE;
            }
            case FLOAT: {
                return FloatMarshaller.INSTANCE;
            }
            case DOUBLE: {
                return DoubleMarshaller.INSTANCE;
            }
            case POINTER: {
                return PointerMarshaller.INSTANCE;
            }
            case STRING: {
                return StringMarshaller.INSTANCE;
            }
        }
        throw Py.RuntimeError("Unsupported parameter type: " + (Object)((Object)type));
    }

    static final ParameterMarshaller getMarshaller(CType type) {
        if (type instanceof CType.Builtin) {
            return DefaultInvokerFactory.getMarshaller(type.getNativeType());
        }
        if (type instanceof CType.Pointer) {
            return PointerMarshaller.INSTANCE;
        }
        throw Py.RuntimeError("Unsupported parameter type: " + type);
    }

    static final ParameterMarshaller getMarshaller(PyObject type) {
        return DefaultInvokerFactory.getMarshaller(CType.typeOf(type));
    }

    private static final class SingletonHolder {
        public static final DefaultInvokerFactory INSTANCE = new DefaultInvokerFactory();

        private SingletonHolder() {
        }
    }

    static interface ParameterMarshaller {
        public void marshal(HeapInvocationBuffer var1, PyObject var2);
    }

    private static final class VoidInvoker
    extends BaseInvoker {
        public VoidInvoker(Function function, ParameterMarshaller[] marshallers) {
            super(function, marshallers);
        }

        @Override
        public final PyObject invoke(PyObject[] args) {
            this.jffiInvoker.invokeInt(this.jffiFunction, this.convertArguments(args));
            return Py.None;
        }
    }

    private static final class Signed8Invoker
    extends BaseInvoker {
        public Signed8Invoker(Function function, ParameterMarshaller[] marshallers) {
            super(function, marshallers);
        }

        @Override
        public final PyObject invoke(PyObject[] args) {
            return Util.newSigned8(this.jffiInvoker.invokeInt(this.jffiFunction, this.convertArguments(args)));
        }
    }

    private static final class Unsigned8Invoker
    extends BaseInvoker {
        public Unsigned8Invoker(Function function, ParameterMarshaller[] marshallers) {
            super(function, marshallers);
        }

        @Override
        public final PyObject invoke(PyObject[] args) {
            return Util.newUnsigned8(this.jffiInvoker.invokeInt(this.jffiFunction, this.convertArguments(args)));
        }
    }

    private static final class Signed16Invoker
    extends BaseInvoker {
        public Signed16Invoker(Function function, ParameterMarshaller[] marshallers) {
            super(function, marshallers);
        }

        @Override
        public final PyObject invoke(PyObject[] args) {
            return JITRuntime.newSigned16(this.jffiInvoker.invokeInt(this.jffiFunction, this.convertArguments(args)));
        }
    }

    private static final class Unsigned16Invoker
    extends BaseInvoker {
        public Unsigned16Invoker(Function function, ParameterMarshaller[] marshallers) {
            super(function, marshallers);
        }

        @Override
        public final PyObject invoke(PyObject[] args) {
            return JITRuntime.newUnsigned16(this.jffiInvoker.invokeInt(this.jffiFunction, this.convertArguments(args)));
        }
    }

    private static final class Signed32Invoker
    extends BaseInvoker {
        public Signed32Invoker(Function function, ParameterMarshaller[] marshallers) {
            super(function, marshallers);
        }

        @Override
        public final PyObject invoke(PyObject[] args) {
            return JITRuntime.newSigned32(this.jffiInvoker.invokeInt(this.jffiFunction, this.convertArguments(args)));
        }
    }

    private static final class Unsigned32Invoker
    extends BaseInvoker {
        public Unsigned32Invoker(Function function, ParameterMarshaller[] marshallers) {
            super(function, marshallers);
        }

        @Override
        public final PyObject invoke(PyObject[] args) {
            return JITRuntime.newUnsigned32(this.jffiInvoker.invokeInt(this.jffiFunction, this.convertArguments(args)));
        }
    }

    private static final class Signed64Invoker
    extends BaseInvoker {
        public Signed64Invoker(Function function, ParameterMarshaller[] marshallers) {
            super(function, marshallers);
        }

        @Override
        public final PyObject invoke(PyObject[] args) {
            return JITRuntime.newSigned64(this.jffiInvoker.invokeLong(this.jffiFunction, this.convertArguments(args)));
        }
    }

    private static final class Unsigned64Invoker
    extends BaseInvoker {
        public Unsigned64Invoker(Function function, ParameterMarshaller[] marshallers) {
            super(function, marshallers);
        }

        @Override
        public final PyObject invoke(PyObject[] args) {
            return JITRuntime.newUnsigned64(this.jffiInvoker.invokeLong(this.jffiFunction, this.convertArguments(args)));
        }
    }

    private static final class FloatInvoker
    extends BaseInvoker {
        public FloatInvoker(Function function, ParameterMarshaller[] marshallers) {
            super(function, marshallers);
        }

        @Override
        public final PyObject invoke(PyObject[] args) {
            return Py.newFloat(this.jffiInvoker.invokeFloat(this.jffiFunction, this.convertArguments(args)));
        }
    }

    private static final class DoubleInvoker
    extends BaseInvoker {
        public DoubleInvoker(Function function, ParameterMarshaller[] marshallers) {
            super(function, marshallers);
        }

        @Override
        public final PyObject invoke(PyObject[] args) {
            return Py.newFloat(this.jffiInvoker.invokeDouble(this.jffiFunction, this.convertArguments(args)));
        }
    }

    private static final class PointerInvoker
    extends BaseInvoker {
        public PointerInvoker(Function function, ParameterMarshaller[] marshallers) {
            super(function, marshallers);
        }

        @Override
        public final PyObject invoke(PyObject[] args) {
            return Py.newLong(this.jffiInvoker.invokeAddress(this.jffiFunction, this.convertArguments(args)));
        }
    }

    private static final class StringInvoker
    extends BaseInvoker {
        private static final MemoryIO IO = MemoryIO.getInstance();

        public StringInvoker(Function function, ParameterMarshaller[] marshallers) {
            super(function, marshallers);
        }

        @Override
        public final PyObject invoke(PyObject[] args) {
            return JITRuntime.newString(this.jffiInvoker.invokeAddress(this.jffiFunction, this.convertArguments(args)));
        }
    }

    private static class Signed8Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Signed8Marshaller();

        private Signed8Marshaller() {
        }

        @Override
        public void marshal(HeapInvocationBuffer buffer, PyObject arg) {
            buffer.putByte(Util.int8Value(arg));
        }
    }

    private static class Unsigned8Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Unsigned8Marshaller();

        private Unsigned8Marshaller() {
        }

        @Override
        public void marshal(HeapInvocationBuffer buffer, PyObject arg) {
            buffer.putByte(Util.uint8Value(arg));
        }
    }

    private static class Signed16Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Signed16Marshaller();

        private Signed16Marshaller() {
        }

        @Override
        public void marshal(HeapInvocationBuffer buffer, PyObject arg) {
            buffer.putShort(Util.int16Value(arg));
        }
    }

    private static class Unsigned16Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Unsigned16Marshaller();

        private Unsigned16Marshaller() {
        }

        @Override
        public void marshal(HeapInvocationBuffer buffer, PyObject arg) {
            buffer.putShort(Util.uint16Value(arg));
        }
    }

    private static class Signed32Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Signed32Marshaller();

        private Signed32Marshaller() {
        }

        @Override
        public void marshal(HeapInvocationBuffer buffer, PyObject arg) {
            buffer.putInt(Util.int32Value(arg));
        }
    }

    private static class Unsigned32Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Unsigned32Marshaller();

        private Unsigned32Marshaller() {
        }

        @Override
        public void marshal(HeapInvocationBuffer buffer, PyObject arg) {
            buffer.putInt(Util.uint32Value(arg));
        }
    }

    private static class Signed64Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Signed64Marshaller();

        private Signed64Marshaller() {
        }

        @Override
        public void marshal(HeapInvocationBuffer buffer, PyObject arg) {
            buffer.putLong(Util.int64Value(arg));
        }
    }

    private static class Unsigned64Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Unsigned64Marshaller();

        private Unsigned64Marshaller() {
        }

        @Override
        public void marshal(HeapInvocationBuffer buffer, PyObject arg) {
            buffer.putLong(Util.uint64Value(arg));
        }
    }

    private static class FloatMarshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new FloatMarshaller();

        private FloatMarshaller() {
        }

        @Override
        public void marshal(HeapInvocationBuffer buffer, PyObject arg) {
            buffer.putFloat((float)arg.asDouble());
        }
    }

    private static class DoubleMarshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new DoubleMarshaller();

        private DoubleMarshaller() {
        }

        @Override
        public void marshal(HeapInvocationBuffer buffer, PyObject arg) {
            buffer.putDouble(arg.asDouble());
        }
    }

    private static class PointerMarshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new PointerMarshaller();

        private PointerMarshaller() {
        }

        @Override
        public void marshal(HeapInvocationBuffer buffer, PyObject parameter) {
            if (parameter instanceof Pointer) {
                buffer.putAddress(((Pointer)((Object)parameter)).getMemory().getAddress());
            } else if (parameter == Py.None) {
                buffer.putAddress(0L);
            } else {
                throw Py.TypeError("expected pointer argument");
            }
        }
    }

    private static class StringMarshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new StringMarshaller();

        private StringMarshaller() {
        }

        @Override
        public void marshal(HeapInvocationBuffer buffer, PyObject parameter) {
            if (parameter instanceof StringCData) {
                buffer.putAddress(((StringCData)parameter).getMemory().getAddress());
            } else if (parameter instanceof PyNone) {
                buffer.putAddress(0L);
            } else {
                byte[] bytes = parameter.toString().getBytes();
                buffer.putArray(bytes, 0, bytes.length, 5);
            }
        }
    }

    static abstract class BaseMarshaller
    implements ParameterMarshaller {
        BaseMarshaller() {
        }
    }

    private static abstract class BaseInvoker
    extends Invoker {
        final Function jffiFunction;
        final com.kenai.jffi.Invoker jffiInvoker = com.kenai.jffi.Invoker.getInstance();
        final ParameterMarshaller[] marshallers;
        final int arity;

        public BaseInvoker(Function function, ParameterMarshaller[] marshallers) {
            this.jffiFunction = function;
            this.marshallers = marshallers;
            this.arity = marshallers.length;
        }

        final HeapInvocationBuffer convertArguments(PyObject[] args) {
            this.checkArity(args);
            HeapInvocationBuffer buffer = new HeapInvocationBuffer(this.jffiFunction);
            for (int i = 0; i < this.marshallers.length; ++i) {
                this.marshallers[i].marshal(buffer, args[i]);
            }
            return buffer;
        }

        @Override
        public final PyObject invoke() {
            return this.invoke(new PyObject[0]);
        }

        @Override
        public final PyObject invoke(PyObject arg0) {
            return this.invoke(new PyObject[]{arg0});
        }

        @Override
        public final PyObject invoke(PyObject arg0, PyObject arg1) {
            return this.invoke(new PyObject[]{arg0, arg1});
        }

        @Override
        public final PyObject invoke(PyObject arg0, PyObject arg1, PyObject arg2) {
            return this.invoke(new PyObject[]{arg0, arg1, arg2});
        }

        @Override
        public final PyObject invoke(PyObject arg0, PyObject arg1, PyObject arg2, PyObject arg3) {
            return this.invoke(new PyObject[]{arg0, arg1, arg2, arg3});
        }

        @Override
        public final PyObject invoke(PyObject arg0, PyObject arg1, PyObject arg2, PyObject arg3, PyObject arg4) {
            return this.invoke(new PyObject[]{arg0, arg1, arg2, arg3, arg4});
        }

        @Override
        public final PyObject invoke(PyObject arg0, PyObject arg1, PyObject arg2, PyObject arg3, PyObject arg4, PyObject arg5) {
            return this.invoke(new PyObject[]{arg0, arg1, arg2, arg3, arg4, arg5});
        }

        final void checkArity(PyObject[] args) {
            this.checkArity(args.length);
        }

        final void checkArity(int got) {
            if (got != this.arity) {
                throw Py.TypeError(String.format("expected %d args; got %d", this.arity, got));
            }
        }
    }
}

