/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.ldap;

import java.io.IOException;
import java.net.ServerSocket;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.springframework.security.ldap.server.ApacheDSContainer;
import org.springframework.security.ldap.server.UnboundIdContainer;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class LdapServerBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String CONTEXT_SOURCE_CLASS = "org.springframework.security.ldap.DefaultSpringSecurityContextSource";
    private static final String ATT_URL = "url";
    private static final String ATT_PRINCIPAL = "manager-dn";
    private static final String ATT_PASSWORD = "manager-password";
    public static final String ATT_ROOT_SUFFIX = "root";
    private static final String OPT_DEFAULT_ROOT_SUFFIX = "dc=springframework,dc=org";
    public static final String ATT_LDIF_FILE = "ldif";
    private static final String OPT_DEFAULT_LDIF_FILE = "classpath*:*.ldif";
    public static final String ATT_PORT = "port";
    private static final String RANDOM_PORT = "0";
    private static final int DEFAULT_PORT = 33389;
    private static final String APACHEDS_CLASSNAME = "org.apache.directory.server.core.DefaultDirectoryService";
    private static final String UNBOUNID_CLASSNAME = "com.unboundid.ldap.listener.InMemoryDirectoryServer";
    private static final String APACHEDS_CONTAINER_CLASSNAME = "org.springframework.security.ldap.server.ApacheDSContainer";
    private static final String UNBOUNDID_CONTAINER_CLASSNAME = "org.springframework.security.ldap.server.UnboundIdContainer";

    public BeanDefinition parse(Element elt, ParserContext parserContext) {
        String id;
        RootBeanDefinition contextSource;
        String url = elt.getAttribute(ATT_URL);
        if (!StringUtils.hasText((String)url)) {
            contextSource = this.createEmbeddedServer(elt, parserContext);
        } else {
            contextSource = new RootBeanDefinition();
            contextSource.setBeanClassName(CONTEXT_SOURCE_CLASS);
            contextSource.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)url);
        }
        contextSource.setSource(parserContext.extractSource((Object)elt));
        String managerDn = elt.getAttribute(ATT_PRINCIPAL);
        String managerPassword = elt.getAttribute(ATT_PASSWORD);
        if (StringUtils.hasText((String)managerDn)) {
            if (!StringUtils.hasText((String)managerPassword)) {
                parserContext.getReaderContext().error("You must specify the manager-password if you supply a " + managerDn, (Object)elt);
            }
            contextSource.getPropertyValues().addPropertyValue("userDn", (Object)managerDn);
            contextSource.getPropertyValues().addPropertyValue("password", (Object)managerPassword);
        }
        String contextSourceId = StringUtils.hasText((String)(id = elt.getAttribute("id"))) ? id : "org.springframework.security.securityContextSource";
        parserContext.getRegistry().registerBeanDefinition(contextSourceId, (BeanDefinition)contextSource);
        return null;
    }

    private RootBeanDefinition createEmbeddedServer(Element element, ParserContext parserContext) {
        String beanId;
        Object source = parserContext.extractSource((Object)element);
        String suffix = element.getAttribute(ATT_ROOT_SUFFIX);
        if (!StringUtils.hasText((String)suffix)) {
            suffix = OPT_DEFAULT_ROOT_SUFFIX;
        }
        BeanDefinitionBuilder contextSource = BeanDefinitionBuilder.rootBeanDefinition((String)CONTEXT_SOURCE_CLASS);
        contextSource.addConstructorArgValue((Object)suffix);
        contextSource.addPropertyValue("userDn", (Object)"uid=admin,ou=system");
        contextSource.addPropertyValue("password", (Object)"secret");
        AbstractBeanDefinition embeddedLdapServerConfigBean = BeanDefinitionBuilder.rootBeanDefinition(EmbeddedLdapServerConfigBean.class).getBeanDefinition();
        String embeddedLdapServerConfigBeanName = parserContext.getReaderContext().generateBeanName((BeanDefinition)embeddedLdapServerConfigBean);
        parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)embeddedLdapServerConfigBean, embeddedLdapServerConfigBeanName));
        contextSource.setFactoryMethodOnBean("createEmbeddedContextSource", embeddedLdapServerConfigBeanName);
        String mode = element.getAttribute("mode");
        RootBeanDefinition ldapContainer = this.getRootBeanDefinition(mode);
        ldapContainer.setSource(source);
        ldapContainer.getConstructorArgumentValues().addGenericArgumentValue((Object)suffix);
        String ldifs = element.getAttribute(ATT_LDIF_FILE);
        if (!StringUtils.hasText((String)ldifs)) {
            ldifs = OPT_DEFAULT_LDIF_FILE;
        }
        ldapContainer.getConstructorArgumentValues().addGenericArgumentValue((Object)ldifs);
        ldapContainer.getPropertyValues().addPropertyValue(ATT_PORT, (Object)this.getPort(element));
        if (parserContext.getRegistry().containsBeanDefinition("org.springframework.security.apacheDirectoryServerContainer") || parserContext.getRegistry().containsBeanDefinition("org.springframework.security.unboundidServerContainer")) {
            parserContext.getReaderContext().error("Only one embedded server bean is allowed per application context", (Object)element);
        }
        if ((beanId = this.resolveBeanId(mode)) != null) {
            parserContext.getRegistry().registerBeanDefinition(beanId, (BeanDefinition)ldapContainer);
        }
        return (RootBeanDefinition)contextSource.getBeanDefinition();
    }

    private RootBeanDefinition getRootBeanDefinition(String mode) {
        if (this.isApacheDsEnabled(mode)) {
            return new RootBeanDefinition(APACHEDS_CONTAINER_CLASSNAME, null, null);
        }
        if (this.isUnboundidEnabled(mode)) {
            return new RootBeanDefinition(UNBOUNDID_CONTAINER_CLASSNAME, null, null);
        }
        throw new IllegalStateException("Embedded LDAP server is not provided");
    }

    private String resolveBeanId(String mode) {
        if (this.isApacheDsEnabled(mode)) {
            return "org.springframework.security.apacheDirectoryServerContainer";
        }
        if (this.isUnboundidEnabled(mode)) {
            return "org.springframework.security.unboundidServerContainer";
        }
        return null;
    }

    private boolean isApacheDsEnabled(String mode) {
        return "apacheds".equals(mode) || ClassUtils.isPresent((String)APACHEDS_CLASSNAME, (ClassLoader)this.getClass().getClassLoader());
    }

    private boolean isUnboundidEnabled(String mode) {
        return "unboundid".equals(mode) || ClassUtils.isPresent((String)UNBOUNID_CLASSNAME, (ClassLoader)this.getClass().getClassLoader());
    }

    private String getPort(Element element) {
        String port = element.getAttribute(ATT_PORT);
        return StringUtils.hasText((String)port) ? port : this.getDefaultPort();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getDefaultPort() {
        try (ServerSocket serverSocket = new ServerSocket(33389);){
            String string = String.valueOf(serverSocket.getLocalPort());
            return string;
        }
        catch (IOException ex) {
            return RANDOM_PORT;
        }
    }

    private static class EmbeddedLdapServerConfigBean
    implements ApplicationContextAware {
        private ApplicationContext applicationContext;

        private EmbeddedLdapServerConfigBean() {
        }

        public void setApplicationContext(ApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }

        private DefaultSpringSecurityContextSource createEmbeddedContextSource(String suffix) {
            int port = this.getPort();
            String providerUrl = "ldap://127.0.0.1:" + port + "/" + suffix;
            return new DefaultSpringSecurityContextSource(providerUrl);
        }

        private int getPort() {
            if (ClassUtils.isPresent((String)LdapServerBeanDefinitionParser.APACHEDS_CLASSNAME, (ClassLoader)this.getClass().getClassLoader())) {
                ApacheDSContainer apacheDSContainer = (ApacheDSContainer)this.applicationContext.getBean(ApacheDSContainer.class);
                return apacheDSContainer.getLocalPort();
            }
            if (ClassUtils.isPresent((String)LdapServerBeanDefinitionParser.UNBOUNID_CLASSNAME, (ClassLoader)this.getClass().getClassLoader())) {
                UnboundIdContainer unboundIdContainer = (UnboundIdContainer)this.applicationContext.getBean(UnboundIdContainer.class);
                return unboundIdContainer.getPort();
            }
            throw new IllegalStateException("Embedded LDAP server is not provided");
        }
    }
}

