/*
 * Decompiled with CFR 0.152.
 */
package akka.http.shaded.com.twitter.hpack;

import akka.http.impl.util.StringTools;
import akka.http.shaded.com.twitter.hpack.HeaderField;
import akka.http.shaded.com.twitter.hpack.HpackUtil;
import akka.http.shaded.com.twitter.hpack.Huffman;
import akka.http.shaded.com.twitter.hpack.StaticTable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class Encoder {
    private static final int BUCKET_SIZE = 17;
    private static final String EMPTY = "";
    private final boolean useIndexing;
    private final boolean forceHuffmanOn;
    private final boolean forceHuffmanOff;
    private final HeaderEntry[] headerFields = new HeaderEntry[17];
    private final HeaderEntry head = new HeaderEntry(-1, "", "", Integer.MAX_VALUE, null);
    private int size;
    private int capacity;

    public Encoder(int n) {
        this(n, true, false, false);
    }

    Encoder(int n, boolean bl, boolean bl2, boolean bl3) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.useIndexing = bl;
        this.forceHuffmanOn = bl2;
        this.forceHuffmanOff = bl3;
        this.capacity = n;
        this.head.before = this.head.after = this.head;
    }

    public void encodeHeader(OutputStream outputStream, String string, String string2, boolean bl) throws IOException {
        if (bl) {
            int n = this.getNameIndex(string);
            this.encodeLiteral(outputStream, string, string2, HpackUtil.IndexType.NEVER, n);
            return;
        }
        if (this.capacity == 0) {
            int n = StaticTable.getIndex(string, string2);
            if (n == -1) {
                int n2 = StaticTable.getIndex(string);
                this.encodeLiteral(outputStream, string, string2, HpackUtil.IndexType.NONE, n2);
            } else {
                Encoder.encodeInteger(outputStream, 128, 7, n);
            }
            return;
        }
        HeaderEntry headerEntry = this.getEntry(string, string2);
        if (headerEntry != null) {
            int n = this.getIndex(headerEntry.index) + StaticTable.length;
            Encoder.encodeInteger(outputStream, 128, 7, n);
        } else {
            int n = HeaderField.sizeOf(string, string2);
            if (n > this.capacity) {
                int n3 = this.getNameIndex(string);
                this.encodeLiteral(outputStream, string, string2, HpackUtil.IndexType.NONE, n3);
            } else {
                int n4 = StaticTable.getIndex(string, string2);
                if (n4 != -1) {
                    Encoder.encodeInteger(outputStream, 128, 7, n4);
                } else {
                    int n5 = this.getNameIndex(string);
                    if (this.useIndexing) {
                        this.ensureCapacity(n);
                    }
                    HpackUtil.IndexType indexType = this.useIndexing ? HpackUtil.IndexType.INCREMENTAL : HpackUtil.IndexType.NONE;
                    this.encodeLiteral(outputStream, string, string2, indexType, n5);
                    if (this.useIndexing) {
                        this.add(string, string2);
                    }
                }
            }
        }
    }

    public void setMaxHeaderTableSize(OutputStream outputStream, int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        if (this.capacity == n) {
            return;
        }
        this.capacity = n;
        this.ensureCapacity(0);
        Encoder.encodeInteger(outputStream, 32, 5, n);
    }

    public int getMaxHeaderTableSize() {
        return this.capacity;
    }

    private static void encodeInteger(OutputStream outputStream, int n, int n2, int n3) throws IOException {
        if (n2 < 0 || n2 > 8) {
            throw new IllegalArgumentException("N: " + n2);
        }
        int n4 = 255 >>> 8 - n2;
        if (n3 >= n4) {
            outputStream.write(n | n4);
            int n5 = n3 - n4;
            while (true) {
                if ((n5 & 0xFFFFFF80) == 0) {
                    outputStream.write(n5);
                    return;
                }
                outputStream.write(n5 & 0x7F | 0x80);
                n5 >>>= 7;
            }
        }
        outputStream.write(n | n3);
    }

    private void encodeStringLiteral(OutputStream outputStream, String string) throws IOException {
        int n = string.length();
        int n2 = Huffman.ENCODER.getEncodedLength(string);
        if (n2 < n && !this.forceHuffmanOff || this.forceHuffmanOn) {
            Encoder.encodeInteger(outputStream, 128, 7, n2);
            Huffman.ENCODER.encode(outputStream, string);
        } else {
            byte[] byArray = StringTools.asciiStringBytes(string);
            Encoder.encodeInteger(outputStream, 0, 7, n);
            outputStream.write(byArray, 0, byArray.length);
        }
    }

    private void encodeLiteral(OutputStream outputStream, String string, String string2, HpackUtil.IndexType indexType, int n) throws IOException {
        int n2;
        int n3;
        switch (indexType) {
            case INCREMENTAL: {
                n3 = 64;
                n2 = 6;
                break;
            }
            case NONE: {
                n3 = 0;
                n2 = 4;
                break;
            }
            case NEVER: {
                n3 = 16;
                n2 = 4;
                break;
            }
            default: {
                throw new IllegalStateException("should not reach here");
            }
        }
        Encoder.encodeInteger(outputStream, n3, n2, n == -1 ? 0 : n);
        if (n == -1) {
            this.encodeStringLiteral(outputStream, string);
        }
        this.encodeStringLiteral(outputStream, string2);
    }

    private int getNameIndex(String string) {
        int n = StaticTable.getIndex(string);
        if (n == -1 && (n = this.getIndex(string)) >= 0) {
            n += StaticTable.length;
        }
        return n;
    }

    private void ensureCapacity(int n) throws IOException {
        int n2;
        while (this.size + n > this.capacity && (n2 = this.length()) != 0) {
            this.remove();
        }
    }

    int length() {
        return this.size == 0 ? 0 : this.head.after.index - this.head.before.index + 1;
    }

    int size() {
        return this.size;
    }

    HeaderField getHeaderField(int n) {
        HeaderEntry headerEntry = this.head;
        while (n-- >= 0) {
            headerEntry = headerEntry.before;
        }
        return headerEntry;
    }

    private HeaderEntry getEntry(String string, String string2) {
        if (this.length() == 0 || string == null || string2 == null) {
            return null;
        }
        int n = Encoder.hash(string);
        int n2 = Encoder.index(n);
        HeaderEntry headerEntry = this.headerFields[n2];
        while (headerEntry != null) {
            if (headerEntry.hash == n && string.equals(headerEntry.name) && string2.equals(headerEntry.value)) {
                return headerEntry;
            }
            headerEntry = headerEntry.next;
        }
        return null;
    }

    private int getIndex(String string) {
        if (this.length() == 0 || string == null) {
            return -1;
        }
        int n = Encoder.hash(string);
        int n2 = Encoder.index(n);
        int n3 = -1;
        HeaderEntry headerEntry = this.headerFields[n2];
        while (headerEntry != null) {
            if (headerEntry.hash == n && string.equals(headerEntry.name)) {
                n3 = headerEntry.index;
                break;
            }
            headerEntry = headerEntry.next;
        }
        return this.getIndex(n3);
    }

    private int getIndex(int n) {
        if (n == -1) {
            return n;
        }
        return n - this.head.before.index + 1;
    }

    private void add(String string, String string2) {
        HeaderEntry headerEntry;
        int n = HeaderField.sizeOf(string, string2);
        if (n > this.capacity) {
            this.clear();
            return;
        }
        while (this.size + n > this.capacity) {
            this.remove();
        }
        int n2 = Encoder.hash(string);
        int n3 = Encoder.index(n2);
        HeaderEntry headerEntry2 = this.headerFields[n3];
        this.headerFields[n3] = headerEntry = new HeaderEntry(n2, string, string2, this.head.before.index - 1, headerEntry2);
        headerEntry.addBefore(this.head);
        this.size += n;
    }

    private HeaderField remove() {
        HeaderEntry headerEntry;
        if (this.size == 0) {
            return null;
        }
        HeaderEntry headerEntry2 = this.head.after;
        int n = headerEntry2.hash;
        int n2 = Encoder.index(n);
        HeaderEntry headerEntry3 = headerEntry = this.headerFields[n2];
        while (headerEntry3 != null) {
            HeaderEntry headerEntry4 = headerEntry3.next;
            if (headerEntry3 == headerEntry2) {
                if (headerEntry == headerEntry2) {
                    this.headerFields[n2] = headerEntry4;
                } else {
                    headerEntry.next = headerEntry4;
                }
                headerEntry2.remove();
                this.size -= headerEntry2.size();
                return headerEntry2;
            }
            headerEntry = headerEntry3;
            headerEntry3 = headerEntry4;
        }
        return null;
    }

    private void clear() {
        Arrays.fill(this.headerFields, null);
        this.head.before = this.head.after = this.head;
        this.size = 0;
    }

    private static int hash(String string) {
        int n = string.hashCode();
        if (n > 0) {
            return n;
        }
        if (n == Integer.MIN_VALUE) {
            return Integer.MAX_VALUE;
        }
        return -n;
    }

    private static int index(int n) {
        return n % 17;
    }

    private static class HeaderEntry
    extends HeaderField {
        HeaderEntry before;
        HeaderEntry after;
        HeaderEntry next;
        int hash;
        int index;

        HeaderEntry(int n, String string, String string2, int n2, HeaderEntry headerEntry) {
            super(string, string2);
            this.index = n2;
            this.hash = n;
            this.next = headerEntry;
        }

        private void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
            this.before = null;
            this.after = null;
            this.next = null;
        }

        private void addBefore(HeaderEntry headerEntry) {
            this.after = headerEntry;
            this.before = headerEntry.before;
            this.before.after = this;
            this.after.before = this;
        }
    }
}

