/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.client;

import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;
import org.springframework.cloud.commons.ConfigDataMissingEnvironmentPostProcessor;
import org.springframework.cloud.util.PropertyUtils;
import org.springframework.core.env.Environment;

public class ConfigServerConfigDataMissingEnvironmentPostProcessor
extends ConfigDataMissingEnvironmentPostProcessor {
    public static final int ORDER = -2147482638;

    public int getOrder() {
        return -2147482638;
    }

    protected String getPrefix() {
        return "configserver:";
    }

    protected boolean shouldProcessEnvironment(Environment environment) {
        if (PropertyUtils.bootstrapEnabled((Environment)environment) || PropertyUtils.useLegacyProcessing((Environment)environment)) {
            return false;
        }
        boolean configEnabled = (Boolean)environment.getProperty("spring.cloud.config.enabled", Boolean.class, (Object)true);
        boolean importCheckEnabled = (Boolean)environment.getProperty("spring.cloud.config.import-check.enabled", Boolean.class, (Object)true);
        return configEnabled && importCheckEnabled;
    }

    static class ImportExceptionFailureAnalyzer
    extends AbstractFailureAnalyzer<ConfigDataMissingEnvironmentPostProcessor.ImportException> {
        ImportExceptionFailureAnalyzer() {
        }

        protected FailureAnalysis analyze(Throwable rootFailure, ConfigDataMissingEnvironmentPostProcessor.ImportException cause) {
            String description = cause.missingPrefix ? "The spring.config.import property is missing a configserver: entry" : "No spring.config.import property has been defined";
            String action = "Add a spring.config.import=configserver: property to your configuration.\n\tIf configuration is not required add spring.config.import=optional:configserver: instead.\n\tTo disable this check, set spring.cloud.config.enabled=false or \n\tspring.cloud.config.import-check.enabled=false.";
            return new FailureAnalysis(description, action, (Throwable)cause);
        }
    }
}

