/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules._threading;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.python.core.ContextManager;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.ThreadState;
import org.python.core.Untraversable;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules._threading.ConditionSupportingLock;
import org.python.modules._threading.RLock$PyExposer;
import org.python.modules._threading.RLockImplementation;

@Untraversable
@ExposedType(name="_threading.RLock")
public class RLock
extends PyObject
implements ContextManager,
ConditionSupportingLock {
    public static final PyType TYPE;
    private final RLockImplementation _lock = new RLockImplementation();

    @Override
    public Lock getLock() {
        return this._lock;
    }

    @ExposedNew
    static final PyObject RLock___new__(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        int nargs = args.length;
        return new RLock();
    }

    final boolean RLock_acquire(boolean blocking) {
        if (blocking) {
            this._lock.lock();
            return true;
        }
        return this._lock.tryLock();
    }

    @Override
    public boolean acquire() {
        return this.RLock_acquire(true);
    }

    @Override
    public boolean acquire(boolean blocking) {
        return this.RLock_acquire(blocking);
    }

    final PyObject RLock___enter__() {
        this._lock.lock();
        return this;
    }

    @Override
    public PyObject __enter__(ThreadState ts) {
        this._lock.lock();
        return this;
    }

    final void RLock_release() {
        if (!this._lock.isHeldByCurrentThread() || this._lock.getHoldCount() <= 0) {
            throw Py.RuntimeError("cannot release un-acquired lock");
        }
        this._lock.unlock();
    }

    @Override
    public void release() {
        this.RLock_release();
    }

    final boolean RLock___exit__(PyObject type, PyObject value, PyObject traceback2) {
        this._lock.unlock();
        return false;
    }

    @Override
    public boolean __exit__(ThreadState ts, PyException exception) {
        this._lock.unlock();
        return false;
    }

    final boolean RLock_locked() {
        return this._lock.isLocked();
    }

    public boolean locked() {
        return this.RLock_locked();
    }

    final boolean RLock__is_owned() {
        return this._lock.isHeldByCurrentThread();
    }

    @Override
    public boolean _is_owned() {
        return this.RLock__is_owned();
    }

    @Override
    public int getWaitQueueLength(Condition condition) {
        return this._lock.getWaitQueueLength(condition);
    }

    @Override
    public String toString() {
        String owner = this._lock.getOwnerName();
        return Py.newString("<_threading.RLock owner=%r count=%d>").__mod__(new PyTuple(owner != null ? Py.newStringOrUnicode(owner) : Py.None, Py.newInteger(this._lock.getHoldCount()))).toString();
    }

    static {
        PyType.addBuilder(RLock.class, new RLock$PyExposer());
        TYPE = PyType.fromClass(RLock.class);
    }
}

