/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Opaque;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;

public abstract class AbstractVariable
implements Variable,
Serializable {
    private static final long serialVersionUID = 1395840752909725320L;
    public static final String SMISYNTAXES_PROPERTIES = "org.snmp4j.smisyntaxes";
    private static final String SMISYNTAXES_PROPERTIES_DEFAULT = "smisyntaxes.properties";
    private static final Object[][] SYNTAX_NAME_MAPPING = new Object[][]{{"Integer32", new Integer(2)}, {"BIT STRING", new Integer(3)}, {"OCTET STRING", new Integer(4)}, {"OBJECT IDENTIFIER", new Integer(6)}, {"TimeTicks", new Integer(67)}, {"Counter", new Integer(65)}, {"Counter64", new Integer(70)}, {"EndOfMibView", new Integer(130)}, {"Gauge", new Integer(66)}, {"IpAddress", new Integer(64)}, {"NoSuchInstance", new Integer(129)}, {"NoSuchObject", new Integer(128)}, {"Null", new Integer(5)}, {"Opaque", new Integer(68)}};
    private static Hashtable registeredSyntaxes = null;
    private static final LogAdapter logger = LogFactory.getLogger(AbstractVariable.class);

    public abstract boolean equals(Object var1);

    public abstract int compareTo(Object var1);

    public abstract int hashCode();

    public abstract int getBERLength();

    public int getBERPayloadLength() {
        return this.getBERLength();
    }

    public abstract void decodeBER(BERInputStream var1) throws IOException;

    public abstract void encodeBER(OutputStream var1) throws IOException;

    public static Variable createFromBER(BERInputStream bERInputStream) throws IOException {
        Variable variable;
        if (!bERInputStream.markSupported()) {
            throw new IOException("InputStream for decoding a Variable must support marks");
        }
        if (SNMP4JSettings.isExtensibilityEnabled() && registeredSyntaxes == null) {
            AbstractVariable.registerSyntaxes();
        }
        bERInputStream.mark(2);
        int n = bERInputStream.read();
        if (SNMP4JSettings.isExtensibilityEnabled()) {
            Class clazz = (Class)registeredSyntaxes.get(new Integer(n));
            if (clazz == null) {
                throw new IOException("Encountered unsupported variable syntax: " + n);
            }
            try {
                variable = (Variable)clazz.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IOException("Could not access variable syntax class for: " + clazz.getName());
            }
            catch (InstantiationException instantiationException) {
                throw new IOException("Could not instantiate variable syntax class for: " + clazz.getName());
            }
        } else {
            variable = AbstractVariable.createVariable(n);
        }
        bERInputStream.reset();
        variable.decodeBER(bERInputStream);
        return variable;
    }

    private static Variable createVariable(int n) {
        switch (n) {
            case 6: {
                return new OID();
            }
            case 2: {
                return new Integer32();
            }
            case 4: {
                return new OctetString();
            }
            case 66: {
                return new Gauge32();
            }
            case 65: {
                return new Counter32();
            }
            case 70: {
                return new Counter64();
            }
            case 5: {
                return new Null();
            }
            case 67: {
                return new TimeTicks();
            }
            case 130: {
                return new Null(130);
            }
            case 129: {
                return new Null(129);
            }
            case 128: {
                return new Null(128);
            }
            case 68: {
                return new Opaque();
            }
            case 64: {
                return new IpAddress();
            }
        }
        throw new IllegalArgumentException("Unsupported variable syntax: " + n);
    }

    public static Variable createFromSyntax(int n) {
        Class clazz;
        if (!SNMP4JSettings.isExtensibilityEnabled()) {
            return AbstractVariable.createVariable(n);
        }
        if (registeredSyntaxes == null) {
            AbstractVariable.registerSyntaxes();
        }
        if ((clazz = (Class)registeredSyntaxes.get(new Integer(n))) == null) {
            throw new IllegalArgumentException("Unsupported variable syntax: " + n);
        }
        try {
            Variable variable = (Variable)clazz.newInstance();
            return variable;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Could not access variable syntax class for: " + clazz.getName());
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException("Could not instantiate variable syntax class for: " + clazz.getName());
        }
    }

    private static synchronized void registerSyntaxes() {
        String string;
        InputStream inputStream = Variable.class.getResourceAsStream(string = System.getProperty(SMISYNTAXES_PROPERTIES, SMISYNTAXES_PROPERTIES_DEFAULT));
        if (inputStream == null) {
            throw new InternalError("Could not read '" + string + "' from classpath!");
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            Hashtable hashtable = new Hashtable(properties.size());
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = properties.getProperty(string2);
                try {
                    Class<?> clazz = Class.forName(string3);
                    hashtable.put(new Integer(string2), clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    logger.error(classNotFoundException);
                }
            }
            registeredSyntaxes = hashtable;
        }
        catch (IOException iOException) {
            String string4 = "Could not read '" + string + "': " + iOException.getMessage();
            logger.error(string4);
            throw new InternalError(string4);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                logger.warn(iOException);
            }
        }
    }

    public abstract int getSyntax();

    public boolean isException() {
        return Null.isExceptionSyntax(this.getSyntax());
    }

    public abstract String toString();

    public abstract int toInt();

    public abstract long toLong();

    public abstract Object clone();

    public static String getSyntaxString(int n) {
        switch (n) {
            case 2: {
                return "Integer32";
            }
            case 3: {
                return "BIT STRING";
            }
            case 4: {
                return "OCTET STRING";
            }
            case 6: {
                return "OBJECT IDENTIFIER";
            }
            case 67: {
                return "TimeTicks";
            }
            case 65: {
                return "Counter";
            }
            case 70: {
                return "Counter64";
            }
            case 130: {
                return "EndOfMibView";
            }
            case 66: {
                return "Gauge";
            }
            case 64: {
                return "IpAddress";
            }
            case 129: {
                return "NoSuchInstance";
            }
            case 128: {
                return "NoSuchObject";
            }
            case 5: {
                return "Null";
            }
            case 68: {
                return "Opaque";
            }
        }
        return "?";
    }

    public final String getSyntaxString() {
        return AbstractVariable.getSyntaxString(this.getSyntax());
    }

    public static int getSyntaxFromString(String string) {
        for (int i = 0; i < SYNTAX_NAME_MAPPING.length; ++i) {
            if (!SYNTAX_NAME_MAPPING[i][0].equals(string)) continue;
            return (Integer)SYNTAX_NAME_MAPPING[i][1];
        }
        return 5;
    }

    public abstract OID toSubIndex(boolean var1);

    public abstract void fromSubIndex(OID var1, boolean var2);

    public boolean isDynamic() {
        return false;
    }
}

