/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.proxy;

import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.impl.conn.DefaultRoutePlanner;
import org.apache.http.protocol.HttpContext;
import org.springframework.cloud.config.server.proxy.ProxyHostProperties;

public class SchemeBasedRoutePlanner
extends DefaultRoutePlanner {
    private final HttpHost httpsProxy;
    private final HttpHost defaultSchemeProxy;

    public SchemeBasedRoutePlanner(ProxyHostProperties httpsProxy, ProxyHostProperties httpProxy) {
        super(null);
        this.httpsProxy = this.buildProxy(httpsProxy, "https");
        this.defaultSchemeProxy = this.buildProxy(httpProxy, "http");
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) {
        return "https".equals(target.getSchemeName()) ? this.determineProxy(this.httpsProxy, this.defaultSchemeProxy) : this.determineProxy(this.defaultSchemeProxy, this.httpsProxy);
    }

    private HttpHost determineProxy(HttpHost proxy, HttpHost fallbackProxy) {
        return proxy != null ? proxy : fallbackProxy;
    }

    private HttpHost buildProxy(ProxyHostProperties properties, String scheme) {
        if (properties == null || !properties.connectionInformationProvided()) {
            return null;
        }
        return new HttpHost(properties.getHost(), properties.getPort(), scheme);
    }
}

