/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import org.springframework.aop.Advisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.authorization.AuthorizationEventPublisher;
import org.springframework.security.authorization.SpringAuthorizationEventPublisher;
import org.springframework.security.authorization.method.AuthorizationManagerAfterMethodInterceptor;
import org.springframework.security.authorization.method.AuthorizationManagerBeforeMethodInterceptor;
import org.springframework.security.authorization.method.PostAuthorizeAuthorizationManager;
import org.springframework.security.authorization.method.PostFilterAuthorizationMethodInterceptor;
import org.springframework.security.authorization.method.PreAuthorizeAuthorizationManager;
import org.springframework.security.authorization.method.PreFilterAuthorizationMethodInterceptor;
import org.springframework.security.config.core.GrantedAuthorityDefaults;
import org.springframework.security.core.context.SecurityContextHolderStrategy;

@Configuration(proxyBeanMethods=false)
@Role(value=2)
final class PrePostMethodSecurityConfiguration {
    private final PreFilterAuthorizationMethodInterceptor preFilterAuthorizationMethodInterceptor = new PreFilterAuthorizationMethodInterceptor();
    private final AuthorizationManagerBeforeMethodInterceptor preAuthorizeAuthorizationMethodInterceptor;
    private final PreAuthorizeAuthorizationManager preAuthorizeAuthorizationManager = new PreAuthorizeAuthorizationManager();
    private final AuthorizationManagerAfterMethodInterceptor postAuthorizeAuthorizaitonMethodInterceptor;
    private final PostAuthorizeAuthorizationManager postAuthorizeAuthorizationManager = new PostAuthorizeAuthorizationManager();
    private final PostFilterAuthorizationMethodInterceptor postFilterAuthorizationMethodInterceptor = new PostFilterAuthorizationMethodInterceptor();
    private final DefaultMethodSecurityExpressionHandler expressionHandler = new DefaultMethodSecurityExpressionHandler();

    @Autowired
    PrePostMethodSecurityConfiguration(ApplicationContext context) {
        this.preAuthorizeAuthorizationManager.setExpressionHandler((MethodSecurityExpressionHandler)this.expressionHandler);
        this.preAuthorizeAuthorizationMethodInterceptor = AuthorizationManagerBeforeMethodInterceptor.preAuthorize((PreAuthorizeAuthorizationManager)this.preAuthorizeAuthorizationManager);
        this.postAuthorizeAuthorizationManager.setExpressionHandler((MethodSecurityExpressionHandler)this.expressionHandler);
        this.postAuthorizeAuthorizaitonMethodInterceptor = AuthorizationManagerAfterMethodInterceptor.postAuthorize((PostAuthorizeAuthorizationManager)this.postAuthorizeAuthorizationManager);
        this.preFilterAuthorizationMethodInterceptor.setExpressionHandler((MethodSecurityExpressionHandler)this.expressionHandler);
        this.postFilterAuthorizationMethodInterceptor.setExpressionHandler((MethodSecurityExpressionHandler)this.expressionHandler);
        this.expressionHandler.setApplicationContext(context);
        SpringAuthorizationEventPublisher publisher = new SpringAuthorizationEventPublisher((ApplicationEventPublisher)context);
        this.preAuthorizeAuthorizationMethodInterceptor.setAuthorizationEventPublisher((AuthorizationEventPublisher)publisher);
        this.postAuthorizeAuthorizaitonMethodInterceptor.setAuthorizationEventPublisher((AuthorizationEventPublisher)publisher);
    }

    @Bean
    @Role(value=2)
    Advisor preFilterAuthorizationMethodInterceptor() {
        return this.preFilterAuthorizationMethodInterceptor;
    }

    @Bean
    @Role(value=2)
    Advisor preAuthorizeAuthorizationMethodInterceptor() {
        return this.preAuthorizeAuthorizationMethodInterceptor;
    }

    @Bean
    @Role(value=2)
    Advisor postAuthorizeAuthorizationMethodInterceptor() {
        return this.postAuthorizeAuthorizaitonMethodInterceptor;
    }

    @Bean
    @Role(value=2)
    Advisor postFilterAuthorizationMethodInterceptor() {
        return this.postFilterAuthorizationMethodInterceptor;
    }

    @Autowired(required=false)
    void setMethodSecurityExpressionHandler(MethodSecurityExpressionHandler methodSecurityExpressionHandler) {
        this.preFilterAuthorizationMethodInterceptor.setExpressionHandler(methodSecurityExpressionHandler);
        this.preAuthorizeAuthorizationManager.setExpressionHandler(methodSecurityExpressionHandler);
        this.postAuthorizeAuthorizationManager.setExpressionHandler(methodSecurityExpressionHandler);
        this.postFilterAuthorizationMethodInterceptor.setExpressionHandler(methodSecurityExpressionHandler);
    }

    @Autowired(required=false)
    void setSecurityContextHolderStrategy(SecurityContextHolderStrategy strategy) {
        this.preFilterAuthorizationMethodInterceptor.setSecurityContextHolderStrategy(strategy);
        this.preAuthorizeAuthorizationMethodInterceptor.setSecurityContextHolderStrategy(strategy);
        this.postAuthorizeAuthorizaitonMethodInterceptor.setSecurityContextHolderStrategy(strategy);
        this.postFilterAuthorizationMethodInterceptor.setSecurityContextHolderStrategy(strategy);
    }

    @Autowired(required=false)
    void setGrantedAuthorityDefaults(GrantedAuthorityDefaults grantedAuthorityDefaults) {
        this.expressionHandler.setDefaultRolePrefix(grantedAuthorityDefaults.getRolePrefix());
    }

    @Autowired(required=false)
    void setAuthorizationEventPublisher(AuthorizationEventPublisher eventPublisher) {
        this.preAuthorizeAuthorizationMethodInterceptor.setAuthorizationEventPublisher(eventPublisher);
        this.postAuthorizeAuthorizaitonMethodInterceptor.setAuthorizationEventPublisher(eventPublisher);
    }
}

