/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.springsecurity;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;

public class UsernameStoringAuthenticationFailureHandler
extends SimpleUrlAuthenticationFailureHandler {
    public static final String LAST_USERNAME_KEY = "SPRING_SECURITY_LAST_USERNAME";
    private final String usernameParameter;

    public UsernameStoringAuthenticationFailureHandler(String usernameParameter) {
        this.usernameParameter = usernameParameter;
    }

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        this.storeUsername(request, request.getParameter(this.usernameParameter));
        super.onAuthenticationFailure(request, response, exception);
    }

    protected void storeUsername(HttpServletRequest request, String username) {
        HttpSession session;
        if (username != null && (session = request.getSession(false)) != null) {
            request.getSession().setAttribute(LAST_USERNAME_KEY, (Object)username);
        }
    }
}

