/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;

public final class FileUtil {
    private FileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getContent(FileObject file) throws IOException {
        FileContent content = file.getContent();
        int size = (int)content.getSize();
        byte[] buf = new byte[size];
        try (InputStream in = content.getInputStream();){
            int read = 0;
            for (int pos = 0; pos < size && read >= 0; pos += read) {
                read = in.read(buf, pos, size - pos);
            }
        }
        return buf;
    }

    public static void writeContent(FileObject file, OutputStream output) throws IOException {
        file.getContent().write(output);
    }

    public static void copyContent(FileObject srcFile, FileObject destFile) throws IOException {
        srcFile.getContent().write(destFile);
    }
}

