/*
 * Decompiled with CFR 0.152.
 */
package akka.util;

import akka.annotation.InternalApi;
import akka.util.DoubleLinkedList;
import akka.util.OptionVal;
import akka.util.OptionVal$;
import akka.util.OptionVal$Some$;
import akka.util.RecencyList$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00055xA\u0002\u00192\u0011\u0003\u0019TG\u0002\u00048c!\u00051\u0007\u000f\u0005\u0006\u007f\u0005!\t!\u0011\u0005\u0006\u0005\u0006!\ta\u0011\u0004\u0005c\u00061!\u000f\u0003\u0005u\t\t\u0015\r\u0011\"\u0001v\u0011!AHA!A!\u0002\u00131\b\"B \u0005\t\u0003I\bbB?\u0005\u0001\u0004%\tA \u0005\n\u0003\u000b!\u0001\u0019!C\u0001\u0003\u000fAq!a\u0005\u0005A\u0003&q\u0010\u0003\u0005\u0002\u0016\u0011\u0001\r\u0011\"\u0001\u007f\u0011%\t9\u0002\u0002a\u0001\n\u0003\tI\u0002C\u0004\u0002\u001e\u0011\u0001\u000b\u0015B@\t\u0013\u0005}A\u00011A\u0005\u0002\u0005\u0005\u0002\"CA\u0012\t\u0001\u0007I\u0011AA\u0013\u0011\u001d\tI\u0003\u0002Q!\n=3qaS\u0001\u0011\u0002G\u0005A\nC\u0003N#\u0019\u0005a\nC\u0003S#\u0019\u00051K\u0002\u0004\u0002\\\u0006\u0011\u0011Q\u001c\u0005\u0007\u007fQ!\t!!9\t\u000b5#B\u0011\t(\t\rI#B\u0011IAs\r\u00159\u0014GA\u001aG\u0011!A\u0005D!A!\u0002\u0013I\u0005\"B \u0019\t\u0003i\u0006bB6\u0019\u0005\u0004%I\u0001\u001c\u0005\b\u0003WA\u0002\u0015!\u0003n\u0011%\ti\u0003\u0007b\u0001\n\u0013\ty\u0003\u0003\u0005\u0002Ba\u0001\u000b\u0011BA\u0019\u0011\u001d\t\u0019\u0005\u0007C\u0001\u0003\u000bBq!!\u0014\u0019\t\u0003\ty\u0005C\u0004\u0002Ta!\t!!\u0016\t\u000f\u0005e\u0003\u0004\"\u0001\u0002\\!9\u0011Q\r\r\u0005\u0002\u0005\u001d\u0004bBA61\u0011\u0005\u0011q\r\u0005\b\u0003[BB\u0011AA8\u0011\u001d\tI\t\u0007C\u0001\u0003_Bq!a#\u0019\t\u0003\ti\tC\u0004\u0002\fb!\t!a(\t\u000f\u0005-\u0005\u0004\"\u0001\u0002(\"9\u0011\u0011\u0016\r\u0005\u0002\u0005-\u0006bBAU1\u0011\u0005\u0011q\u0016\u0005\b\u0003SCB\u0011AAT\u0011\u001d\t)\f\u0007C\u0001\u0003oCq!a/\u0019\t\u0003\ti\fC\u0004\u0002Bb!I!a1\u0002\u0017I+7-\u001a8ds2K7\u000f\u001e\u0006\u0003eM\nA!\u001e;jY*\tA'\u0001\u0003bW.\f\u0007C\u0001\u001c\u0002\u001b\u0005\t$a\u0003*fG\u0016t7-\u001f'jgR\u001c\"!A\u001d\u0011\u0005ijT\"A\u001e\u000b\u0003q\nQa]2bY\u0006L!AP\u001e\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}\r\u0001A#A\u001b\u0002\u000b\u0015l\u0007\u000f^=\u0016\u0007\u0011\u000bI.F\u0001F!\u00111\u0004$a6\u0016\u0005\u001d\u000b7C\u0001\r:\u0003\u0015\u0019Gn\\2l!\tQ\u0015C\u0004\u00027\u0001\t)1\t\\8dWN\u0011\u0011#O\u0001\fGV\u0014(/\u001a8u)&lW\rF\u0001P!\tQ\u0004+\u0003\u0002Rw\t!Aj\u001c8h\u0003-)\u0017M\u001d7jKJ$\u0016.\\3\u0015\u0005=#\u0006\"B+\u0014\u0001\u00041\u0016\u0001\u00033ve\u0006$\u0018n\u001c8\u0011\u0005][V\"\u0001-\u000b\u0005UK&B\u0001.<\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u00039b\u0013aBR5oSR,G)\u001e:bi&|g\u000e\u0006\u0002_UB\u0019a\u0007G0\u0011\u0005\u0001\fG\u0002\u0001\u0003\u0006Eb\u0011\ra\u0019\u0002\u0002\u0003F\u0011Am\u001a\t\u0003u\u0015L!AZ\u001e\u0003\u000f9{G\u000f[5oOB\u0011!\b[\u0005\u0003Sn\u00121!\u00118z\u0011\u0015A%\u00041\u0001J\u0003\u001d\u0011XmY3oGf,\u0012!\u001c\t\u0004m9\u0004\u0018BA82\u0005A!u.\u001e2mK2Kgn[3e\u0019&\u001cH\u000fE\u0002K\t}\u0013AAT8eKV\u00111o^\n\u0003\te\nQA^1mk\u0016,\u0012A\u001e\t\u0003A^$QA\u0019\u0003C\u0002\r\faA^1mk\u0016\u0004CC\u0001>}!\rYHA^\u0007\u0002\u0003!)Ao\u0002a\u0001m\u0006QA.Z:t%\u0016\u001cWM\u001c;\u0016\u0003}\u0004BANA\u0001u&\u0019\u00111A\u0019\u0003\u0013=\u0003H/[8o-\u0006d\u0017A\u00047fgN\u0014VmY3oi~#S-\u001d\u000b\u0005\u0003\u0013\ty\u0001E\u0002;\u0003\u0017I1!!\u0004<\u0005\u0011)f.\u001b;\t\u0011\u0005E\u0011\"!AA\u0002}\f1\u0001\u001f\u00132\u0003-aWm]:SK\u000e,g\u000e\u001e\u0011\u0002\u00155|'/\u001a*fG\u0016tG/\u0001\bn_J,'+Z2f]R|F%Z9\u0015\t\u0005%\u00111\u0004\u0005\t\u0003#a\u0011\u0011!a\u0001\u007f\u0006YQn\u001c:f%\u0016\u001cWM\u001c;!\u0003%!\u0018.\\3ti\u0006l\u0007/F\u0001P\u00035!\u0018.\\3ti\u0006l\u0007o\u0018\u0013fcR!\u0011\u0011BA\u0014\u0011!\t\tbDA\u0001\u0002\u0004y\u0015A\u0003;j[\u0016\u001cH/Y7qA\u0005A!/Z2f]\u000eL\b%\u0001\u0006m_>\\W\u000f\u001d(pI\u0016,\"!!\r\u0011\r\u0005M\u0012QH0q\u001b\t\t)D\u0003\u0003\u00028\u0005e\u0012aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003wY\u0014AC2pY2,7\r^5p]&!\u0011qHA\u001b\u0005\ri\u0015\r]\u0001\fY>|7.\u001e9O_\u0012,\u0007%\u0001\u0003tSj,WCAA$!\rQ\u0014\u0011J\u0005\u0004\u0003\u0017Z$aA%oi\u00061Q\u000f\u001d3bi\u0016$2AXA)\u0011\u0015!\b\u00051\u0001`\u0003\u0019\u0011X-\\8wKR\u0019a,a\u0016\t\u000bQ\f\u0003\u0019A0\u0002\u0011\r|g\u000e^1j]N$B!!\u0018\u0002dA\u0019!(a\u0018\n\u0007\u0005\u00054HA\u0004C_>dW-\u00198\t\u000bQ\u0014\u0003\u0019A0\u0002\u00171,\u0017m\u001d;SK\u000e,g\u000e^\u000b\u0003\u0003S\u0002BANA\u0001?\u0006QQn\\:u%\u0016\u001cWM\u001c;\u0002#1,\u0017m\u001d;U_6{7\u000f\u001e*fG\u0016tG/\u0006\u0002\u0002rA)\u00111OAB?:!\u0011QOA@\u001d\u0011\t9(! \u000e\u0005\u0005e$bAA>\u0001\u00061AH]8pizJ\u0011\u0001P\u0005\u0004\u0003\u0003[\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003\u000b\u000b9I\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\r\t\tiO\u0001\u0012[>\u001cH\u000fV8MK\u0006\u001cHOU3dK:$\u0018!\u0005:f[>4X\rT3bgR\u0014VmY3oiR!\u0011qRAN!\u0015\t\t*a&`\u001b\t\t\u0019J\u0003\u0003\u0002\u0016\u0006e\u0012!C5n[V$\u0018M\u00197f\u0013\u0011\tI*a%\u0003\u0007M+\u0017\u000fC\u0004\u0002\u001e\u001e\u0002\r!a\u0012\u0002\u00039$b!a$\u0002\"\u0006\r\u0006bBAOQ\u0001\u0007\u0011q\t\u0005\b\u0003KC\u0003\u0019AA$\u0003\u0011\u00198.\u001b9\u0015\u0005\u0005=\u0015\u0001\u0005:f[>4X-T8tiJ+7-\u001a8u)\u0011\ty)!,\t\u000f\u0005u%\u00061\u0001\u0002HQ1\u0011qRAY\u0003gCq!!(,\u0001\u0004\t9\u0005C\u0004\u0002&.\u0002\r!a\u0012\u00021I,Wn\u001c<f\u0019\u0016\f7\u000f\u001e*fG\u0016tGoT;ug&$W\r\u0006\u0003\u0002\u0010\u0006e\u0006\"B+.\u0001\u00041\u0016A\u0006:f[>4X-T8tiJ+7-\u001a8u/&$\b.\u001b8\u0015\t\u0005=\u0015q\u0018\u0005\u0006+:\u0002\rAV\u0001\u000be\u0016lwN^3O_\u0012,GcA0\u0002F\"1\u0011qY\u0018A\u0002A\fAA\\8eK\"\u001a\u0001$a3\u0011\t\u00055\u00171[\u0007\u0003\u0003\u001fT1!!54\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003+\fyMA\u0006J]R,'O\\1m\u0003BL\u0007c\u00011\u0002Z\u0012)!m\u0001b\u0001G\nIa*\u00198p\u00072|7m[\n\u0005)e\ny\u000e\u0005\u0002|#Q\u0011\u00111\u001d\t\u0003wR!2aTAt\u0011\u0015)v\u00031\u0001WQ\r\t\u00111\u001a\u0015\u0004\u0001\u0005-\u0007")
@InternalApi
public final class RecencyList<A> {
    private final Clock clock;
    private final DoubleLinkedList<Node<A>> recency;
    private final Map<A, Node<A>> lookupNode;

    public static <A> RecencyList<A> empty() {
        return RecencyList$.MODULE$.empty();
    }

    private DoubleLinkedList<Node<A>> recency() {
        return this.recency;
    }

    private Map<A, Node<A>> lookupNode() {
        return this.lookupNode;
    }

    public int size() {
        return this.lookupNode().size();
    }

    public RecencyList<A> update(A value) {
        Node node;
        if (this.lookupNode().contains(value)) {
            Node node2 = (Node)this.lookupNode().apply(value);
            node2.timestamp_$eq(this.clock.currentTime());
            node = this.recency().moveToBack(node2);
        } else {
            Node<A> node3 = new Node<A>(value);
            node3.timestamp_$eq(this.clock.currentTime());
            this.recency().append(node3);
            node = this.lookupNode().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(value), node3));
        }
        return this;
    }

    public RecencyList<A> remove(A value) {
        Object object = this.lookupNode().contains(value) ? this.removeNode((Node)this.lookupNode().apply(value)) : BoxedUnit.UNIT;
        return this;
    }

    public boolean contains(A value) {
        return this.lookupNode().contains(value);
    }

    public A leastRecent() {
        Object a;
        Node<A> node = this.recency().getFirst();
        Node<A> node2 = OptionVal$Some$.MODULE$.unapply(node);
        if (!OptionVal$.MODULE$.isEmpty$extension(node2)) {
            Node<A> first = OptionVal$.MODULE$.get$extension(node2);
            a = OptionVal$Some$.MODULE$.apply(first.value());
        } else {
            a = OptionVal$.MODULE$.none();
        }
        return a;
    }

    public A mostRecent() {
        Object a;
        Node<A> node = this.recency().getLast();
        Node<A> node2 = OptionVal$Some$.MODULE$.unapply(node);
        if (!OptionVal$.MODULE$.isEmpty$extension(node2)) {
            Node<A> last = OptionVal$.MODULE$.get$extension(node2);
            a = OptionVal$Some$.MODULE$.apply(last.value());
        } else {
            a = OptionVal$.MODULE$.none();
        }
        return a;
    }

    public Iterator<A> leastToMostRecent() {
        return this.recency().forwardIterator().map((Function1 & Serializable)x$3 -> x$3.value());
    }

    public Iterator<A> mostToLeastRecent() {
        return this.recency().backwardIterator().map((Function1 & Serializable)x$4 -> x$4.value());
    }

    public Seq<A> removeLeastRecent(int n) {
        return n == 1 ? this.removeLeastRecent() : this.recency().forwardIterator().take(n).map((Function1 & Serializable)node -> this.removeNode((Node)node)).toList();
    }

    public Seq<A> removeLeastRecent(int n, int skip) {
        return this.recency().forwardIterator().slice(skip, skip + n).map((Function1 & Serializable)node -> this.removeNode((Node)node)).toList();
    }

    public Seq<A> removeLeastRecent() {
        Nil$ nil$;
        Node<A> node = this.recency().getFirst();
        Node<A> node2 = OptionVal$Some$.MODULE$.unapply(node);
        if (!OptionVal$.MODULE$.isEmpty$extension(node2)) {
            Node<A> first = OptionVal$.MODULE$.get$extension(node2);
            nil$ = (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.removeNode(first)}));
        } else {
            nil$ = package$.MODULE$.Nil();
        }
        return nil$;
    }

    public Seq<A> removeMostRecent(int n) {
        return n == 1 ? this.removeMostRecent() : this.recency().backwardIterator().take(n).map((Function1 & Serializable)node -> this.removeNode((Node)node)).toList();
    }

    public Seq<A> removeMostRecent(int n, int skip) {
        return this.recency().backwardIterator().slice(skip, skip + n).map((Function1 & Serializable)node -> this.removeNode((Node)node)).toList();
    }

    public Seq<A> removeMostRecent() {
        Nil$ nil$;
        Node<A> node = this.recency().getLast();
        Node<A> node2 = OptionVal$Some$.MODULE$.unapply(node);
        if (!OptionVal$.MODULE$.isEmpty$extension(node2)) {
            Node<A> last = OptionVal$.MODULE$.get$extension(node2);
            nil$ = (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.removeNode(last)}));
        } else {
            nil$ = package$.MODULE$.Nil();
        }
        return nil$;
    }

    public Seq<A> removeLeastRecentOutside(FiniteDuration duration) {
        long min = this.clock.earlierTime(duration);
        return this.recency().forwardIterator().takeWhile((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)RecencyList.$anonfun$removeLeastRecentOutside$1(min, x$5))).map((Function1 & Serializable)node -> this.removeNode((Node)node)).toList();
    }

    public Seq<A> removeMostRecentWithin(FiniteDuration duration) {
        long max = this.clock.earlierTime(duration);
        return this.recency().backwardIterator().takeWhile((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)RecencyList.$anonfun$removeMostRecentWithin$1(max, x$6))).map((Function1 & Serializable)node -> this.removeNode((Node)node)).toList();
    }

    /*
     * WARNING - void declaration
     */
    private A removeNode(Node<A> node) {
        void var2_2;
        A value = node.value();
        this.recency().remove(node);
        this.lookupNode().$minus$eq(value);
        return var2_2;
    }

    public static final /* synthetic */ boolean $anonfun$removeLeastRecentOutside$1(long min$1, Node x$5) {
        return x$5.timestamp() < min$1;
    }

    public static final /* synthetic */ boolean $anonfun$removeMostRecentWithin$1(long max$1, Node x$6) {
        return x$6.timestamp() > max$1;
    }

    public RecencyList(Clock clock) {
        this.clock = clock;
        this.recency = new DoubleLinkedList((Function1 & Serializable)x$1 -> new OptionVal<Node>(x$1.lessRecent()), (Function1 & Serializable)x$2 -> new OptionVal<Node>(x$2.moreRecent()), (Function2 & Serializable)(node, previous) -> {
            node.lessRecent_$eq((Node)((OptionVal)previous).x());
            return BoxedUnit.UNIT;
        }, (Function2 & Serializable)(node, next) -> {
            node.moreRecent_$eq((Node)((OptionVal)next).x());
            return BoxedUnit.UNIT;
        });
        this.lookupNode = (Map)Map$.MODULE$.empty();
    }

    public static interface Clock {
        public long currentTime();

        public long earlierTime(FiniteDuration var1);
    }

    public static final class NanoClock
    implements Clock {
        @Override
        public long currentTime() {
            return System.nanoTime();
        }

        @Override
        public long earlierTime(FiniteDuration duration) {
            return this.currentTime() - duration.toNanos();
        }
    }

    private static final class Node<A> {
        private final A value;
        private Node<A> lessRecent;
        private Node<A> moreRecent;
        private long timestamp;

        public A value() {
            return this.value;
        }

        public Node<A> lessRecent() {
            return this.lessRecent;
        }

        public void lessRecent_$eq(Node<A> x$1) {
            this.lessRecent = x$1;
        }

        public Node<A> moreRecent() {
            return this.moreRecent;
        }

        public void moreRecent_$eq(Node<A> x$1) {
            this.moreRecent = x$1;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public void timestamp_$eq(long x$1) {
            this.timestamp = x$1;
        }

        public Node(A value) {
            this.value = value;
            OptionVal$.MODULE$.None();
            this.lessRecent = null;
            OptionVal$.MODULE$.None();
            this.moreRecent = null;
            this.timestamp = 0L;
        }
    }
}

