/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.ConfigSyntax;
import com.xebialabs.deployit.security.SecretKeyHolder;
import com.xebialabs.xlplatform.config.package$;
import com.xebialabs.xlplatform.config.package$ConfigPasswordUtils$;
import com.xebialabs.xlplatform.utils.ClassLoaderUtils$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.slf4j.Marker;
import org.springframework.util.ResourceUtils;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

public final class ConfigLoader$
implements Logging {
    public static final ConfigLoader$ MODULE$ = new ConfigLoader$();
    private static transient Logger grizzled$slf4j$Logging$$_logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ConfigLoader$ configLoader$ = this;
        synchronized (configLoader$) {
            if (!bitmap$trans$0) {
                grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                bitmap$trans$0 = true;
            }
        }
        return grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return grizzled$slf4j$Logging$$_logger;
    }

    public Config loadWithDynamic(String configResource) {
        return this.loadWithDynamic(ConfigFactory.parseResources((String)configResource), this.loadWithDynamic$default$2());
    }

    public Config loadWithDynamic(InputStream inputStream) {
        return this.loadWithDynamic(ConfigFactory.parseReader((Reader)new InputStreamReader(inputStream)), this.loadWithDynamic$default$2());
    }

    public Config loadWithDynamic(Config config, Config defaultReference) {
        return this.resolveWithDynamic(config.withFallback((ConfigMergeable)defaultReference));
    }

    public Config loadWithDynamic$default$2() {
        return ConfigFactory.defaultReference();
    }

    public Config loadSecuredWithDynamic(String configResource, SecretKeyHolder keyHolder, Function1<String, Option<File>> findResourceFile, Config defaultReference) {
        this.replacePlainTextIfNeeded(configResource, keyHolder, findResourceFile);
        return package$ConfigPasswordUtils$.MODULE$.decrypted$extension(package$.MODULE$.ConfigPasswordUtils(this.loadWithDynamic(ConfigFactory.parseResources((String)configResource), defaultReference)), keyHolder);
    }

    public Function1<String, Option<File>> loadSecuredWithDynamic$default$3() {
        return (Function1 & Serializable)resource -> MODULE$.findFirstInClassPath((String)resource);
    }

    public Config loadSecuredWithDynamic$default$4() {
        return ConfigFactory.defaultReference();
    }

    public Config loadFromInputSecuredWithDynamic(InputStream inputStream, SecretKeyHolder keyHolder, Config defaultReference) {
        Config config = ConfigFactory.parseReader((Reader)new InputStreamReader(inputStream));
        return package$ConfigPasswordUtils$.MODULE$.decrypted$extension(package$.MODULE$.ConfigPasswordUtils(this.loadWithDynamic(config, defaultReference)), keyHolder);
    }

    public Config loadFromInputSecuredWithDynamic$default$3() {
        return ConfigFactory.defaultReference();
    }

    private void replacePlainTextIfNeeded(String configResource, SecretKeyHolder keyHolder, Function1<String, Option<File>> findResourceFile) {
        Config config = ConfigFactory.parseResources((String)configResource, (ConfigParseOptions)ConfigParseOptions.defaults().setAllowMissing(true));
        if (package$ConfigPasswordUtils$.MODULE$.hasPlainPasswords$extension(package$.MODULE$.ConfigPasswordUtils(config), keyHolder)) {
            this.warn((Function0<Object>)(Function0 & Serializable)() -> new StringBuilder(49).append("Configuration file ").append(configResource).append(" contains plain text passwords").toString());
            Option option = (Option)findResourceFile.apply((Object)configResource);
            if (option instanceof Some) {
                Some some = (Some)option;
                File file = (File)some.value();
                this.info((Function0<Object>)(Function0 & Serializable)() -> new StringBuilder(38).append("Writing secured configuration file to ").append(file.getAbsolutePath()).toString());
                Files.write(file.toPath(), (Iterable<? extends CharSequence>)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)package$ConfigPasswordUtils$.MODULE$.encrypted$extension(package$.MODULE$.ConfigPasswordUtils(config), keyHolder).resolve(ConfigResolveOptions.defaults().setAllowUnresolved(true)).root().render(ConfigRenderOptions.defaults().setFormatted(true).setJson(false).setOriginComments(false).setComments(true)), (List)Nil$.MODULE$)).asJava(), new OpenOption[0]);
                return;
            }
            if (None$.MODULE$.equals(option)) {
                this.warn((Function0<Object>)(Function0 & Serializable)() -> new StringBuilder(71).append("Configuration file ").append(configResource).append(" cannot be found in file system. Encryption aborted!").toString());
                return;
            }
            throw new MatchError((Object)option);
        }
    }

    private Config resolveWithDynamic(Config config) {
        Config config2;
        if (config.hasPath("xl.conf-file.location")) {
            String serverConfigLocation = config.getString("xl.conf-file.location");
            File serverConfigFile = ResourceUtils.getFile((String)serverConfigLocation);
            config2 = ConfigFactory.parseFile((File)serverConfigFile, (ConfigParseOptions)ConfigParseOptions.defaults().setSyntax(ConfigSyntax.PROPERTIES));
        } else {
            config2 = ConfigFactory.empty();
        }
        Config serverConfig = config2;
        return ConfigFactory.parseResources((String)"dynamic-reference.conf").withFallback((ConfigMergeable)config).withFallback((ConfigMergeable)serverConfig).resolve();
    }

    private Option<File> findFirstInClassPath(String resource) {
        return CollectionConverters$.MODULE$.EnumerationHasAsScala(ClassLoaderUtils$.MODULE$.classLoader().getResources(resource)).asScala().map((Function1 & Serializable)url -> Try$.MODULE$.apply((Function0 & Serializable)() -> new File(url.toURI())).toOption()).find((Function1 & Serializable)maybeFile -> BoxesRunTime.boxToBoolean((boolean)ConfigLoader$.fileExists$1(maybeFile))).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private static final boolean fileExists$1(Option maybeFile) {
        return maybeFile.exists((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.exists()));
    }

    private ConfigLoader$() {
    }
}

