/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.saml2;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.core.Version;
import org.springframework.context.ApplicationContext;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.LogoutConfigurer;
import org.springframework.security.config.annotation.web.configurers.saml2.Saml2LoginConfigurer;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticatedPrincipal;
import org.springframework.security.saml2.provider.service.authentication.logout.OpenSamlLogoutRequestValidator;
import org.springframework.security.saml2.provider.service.authentication.logout.OpenSamlLogoutResponseValidator;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutRequestValidator;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutResponseValidator;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.web.DefaultRelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.HttpSessionLogoutRequestRepository;
import org.springframework.security.saml2.provider.service.web.authentication.logout.OpenSaml3LogoutRequestResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.OpenSaml3LogoutResponseResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutRequestFilter;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutRequestRepository;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutRequestResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutResponseFilter;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutResponseResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2RelyingPartyInitiatedLogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessEventPublishingLogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public final class Saml2LogoutConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<Saml2LogoutConfigurer<H>, H> {
    private static final String OPEN_SAML_4_VERSION = "4";
    private ApplicationContext context;
    private RelyingPartyRegistrationRepository relyingPartyRegistrationRepository;
    private String logoutUrl = "/logout";
    private List<LogoutHandler> logoutHandlers = new ArrayList<LogoutHandler>();
    private LogoutSuccessHandler logoutSuccessHandler;
    private LogoutRequestConfigurer logoutRequestConfigurer;
    private LogoutResponseConfigurer logoutResponseConfigurer;

    public Saml2LogoutConfigurer(ApplicationContext context) {
        this.context = context;
        this.logoutHandlers.add((LogoutHandler)new SecurityContextLogoutHandler());
        this.logoutHandlers.add((LogoutHandler)new LogoutSuccessEventPublishingLogoutHandler());
        SimpleUrlLogoutSuccessHandler logoutSuccessHandler = new SimpleUrlLogoutSuccessHandler();
        logoutSuccessHandler.setDefaultTargetUrl("/login?logout");
        this.logoutSuccessHandler = logoutSuccessHandler;
        this.logoutRequestConfigurer = new LogoutRequestConfigurer();
        this.logoutResponseConfigurer = new LogoutResponseConfigurer();
    }

    public Saml2LogoutConfigurer<H> logoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
        return this;
    }

    public Saml2LogoutConfigurer<H> relyingPartyRegistrationRepository(RelyingPartyRegistrationRepository repo) {
        this.relyingPartyRegistrationRepository = repo;
        return this;
    }

    public LogoutRequestConfigurer logoutRequest() {
        return this.logoutRequestConfigurer;
    }

    public Saml2LogoutConfigurer<H> logoutRequest(Customizer<LogoutRequestConfigurer> logoutRequestConfigurerCustomizer) {
        logoutRequestConfigurerCustomizer.customize(this.logoutRequestConfigurer);
        return this;
    }

    public LogoutResponseConfigurer logoutResponse() {
        return this.logoutResponseConfigurer;
    }

    public Saml2LogoutConfigurer<H> logoutResponse(Customizer<LogoutResponseConfigurer> logoutResponseConfigurerCustomizer) {
        logoutResponseConfigurerCustomizer.customize(this.logoutResponseConfigurer);
        return this;
    }

    @Override
    public void configure(H http) throws Exception {
        LogoutConfigurer logout = http.getConfigurer(LogoutConfigurer.class);
        if (logout != null) {
            this.logoutHandlers = logout.getLogoutHandlers();
            this.logoutSuccessHandler = logout.getLogoutSuccessHandler();
        }
        RelyingPartyRegistrationResolver registrations = this.relyingPartyRegistrationResolver(http);
        http.addFilterBefore((Filter)this.createLogoutRequestProcessingFilter(registrations), CsrfFilter.class);
        http.addFilterBefore((Filter)this.createLogoutResponseProcessingFilter(registrations), CsrfFilter.class);
        http.addFilterBefore((Filter)this.createRelyingPartyLogoutFilter(registrations), LogoutFilter.class);
    }

    private RelyingPartyRegistrationResolver relyingPartyRegistrationResolver(H http) {
        RelyingPartyRegistrationRepository registrations = this.getRelyingPartyRegistrationRepository(http);
        return new DefaultRelyingPartyRegistrationResolver(registrations);
    }

    private RelyingPartyRegistrationRepository getRelyingPartyRegistrationRepository(H http) {
        if (this.relyingPartyRegistrationRepository != null) {
            return this.relyingPartyRegistrationRepository;
        }
        Saml2LoginConfigurer login = http.getConfigurer(Saml2LoginConfigurer.class);
        this.relyingPartyRegistrationRepository = login != null ? login.relyingPartyRegistrationRepository(http) : this.getBeanOrNull(RelyingPartyRegistrationRepository.class);
        return this.relyingPartyRegistrationRepository;
    }

    private Saml2LogoutRequestFilter createLogoutRequestProcessingFilter(RelyingPartyRegistrationResolver registrations) {
        LogoutHandler[] logoutHandlers = this.logoutHandlers.toArray(new LogoutHandler[0]);
        Saml2LogoutResponseResolver logoutResponseResolver = this.createSaml2LogoutResponseResolver(registrations);
        Saml2LogoutRequestFilter filter = new Saml2LogoutRequestFilter(registrations, this.logoutRequestConfigurer.logoutRequestValidator(), logoutResponseResolver, logoutHandlers);
        filter.setLogoutRequestMatcher(this.createLogoutRequestMatcher());
        filter.setSecurityContextHolderStrategy(this.getSecurityContextHolderStrategy());
        return this.postProcess(filter);
    }

    private Saml2LogoutResponseFilter createLogoutResponseProcessingFilter(RelyingPartyRegistrationResolver registrations) {
        Saml2LogoutResponseFilter logoutResponseFilter = new Saml2LogoutResponseFilter(registrations, this.logoutResponseConfigurer.logoutResponseValidator(), this.logoutSuccessHandler);
        logoutResponseFilter.setLogoutRequestMatcher(this.createLogoutResponseMatcher());
        logoutResponseFilter.setLogoutRequestRepository(this.logoutRequestConfigurer.logoutRequestRepository);
        return this.postProcess(logoutResponseFilter);
    }

    private LogoutFilter createRelyingPartyLogoutFilter(RelyingPartyRegistrationResolver registrations) {
        LogoutHandler[] logoutHandlers = this.logoutHandlers.toArray(new LogoutHandler[0]);
        Saml2RelyingPartyInitiatedLogoutSuccessHandler logoutRequestSuccessHandler = this.createSaml2LogoutRequestSuccessHandler(registrations);
        logoutRequestSuccessHandler.setLogoutRequestRepository(this.logoutRequestConfigurer.logoutRequestRepository);
        LogoutFilter logoutFilter = new LogoutFilter((LogoutSuccessHandler)logoutRequestSuccessHandler, logoutHandlers);
        logoutFilter.setLogoutRequestMatcher(this.createLogoutMatcher());
        return this.postProcess(logoutFilter);
    }

    private RequestMatcher createLogoutMatcher() {
        AntPathRequestMatcher logout = new AntPathRequestMatcher(this.logoutUrl, "POST");
        Saml2RequestMatcher saml2 = new Saml2RequestMatcher(this.getSecurityContextHolderStrategy());
        return new AndRequestMatcher(new RequestMatcher[]{logout, saml2});
    }

    private RequestMatcher createLogoutRequestMatcher() {
        AntPathRequestMatcher logout = new AntPathRequestMatcher(this.logoutRequestConfigurer.logoutUrl);
        ParameterRequestMatcher samlRequest = new ParameterRequestMatcher("SAMLRequest");
        return new AndRequestMatcher(new RequestMatcher[]{logout, samlRequest});
    }

    private RequestMatcher createLogoutResponseMatcher() {
        AntPathRequestMatcher logout = new AntPathRequestMatcher(this.logoutResponseConfigurer.logoutUrl);
        ParameterRequestMatcher samlResponse = new ParameterRequestMatcher("SAMLResponse");
        return new AndRequestMatcher(new RequestMatcher[]{logout, samlResponse});
    }

    private Saml2RelyingPartyInitiatedLogoutSuccessHandler createSaml2LogoutRequestSuccessHandler(RelyingPartyRegistrationResolver relyingPartyRegistrationResolver) {
        Saml2LogoutRequestResolver logoutRequestResolver = this.logoutRequestConfigurer.logoutRequestResolver(relyingPartyRegistrationResolver);
        return new Saml2RelyingPartyInitiatedLogoutSuccessHandler(logoutRequestResolver);
    }

    private Saml2LogoutResponseResolver createSaml2LogoutResponseResolver(RelyingPartyRegistrationResolver relyingPartyRegistrationResolver) {
        return this.logoutResponseConfigurer.logoutResponseResolver(relyingPartyRegistrationResolver);
    }

    private String version() {
        String version = Version.getVersion();
        if (StringUtils.hasText((String)version)) {
            return version;
        }
        boolean openSaml4ClassPresent = ClassUtils.isPresent((String)"org.opensaml.core.xml.persist.impl.PassthroughSourceStrategy", null);
        if (openSaml4ClassPresent) {
            return OPEN_SAML_4_VERSION;
        }
        throw new IllegalStateException("cannot determine OpenSAML version");
    }

    private <C> C getBeanOrNull(Class<C> clazz) {
        if (this.context == null) {
            return null;
        }
        if (this.context.getBeanNamesForType(clazz).length == 0) {
            return null;
        }
        return (C)this.context.getBean(clazz);
    }

    private static class OpenSaml4LogoutSupportFactory {
        private OpenSaml4LogoutSupportFactory() {
        }

        private static Saml2LogoutResponseResolver getLogoutResponseResolver(RelyingPartyRegistrationResolver relyingPartyRegistrationResolver) {
            try {
                Class logoutResponseResolver = ClassUtils.forName((String)"org.springframework.security.saml2.provider.service.web.authentication.logout.OpenSaml4LogoutResponseResolver", (ClassLoader)OpenSaml4LogoutSupportFactory.class.getClassLoader());
                return (Saml2LogoutResponseResolver)logoutResponseResolver.getDeclaredConstructor(RelyingPartyRegistrationResolver.class).newInstance(relyingPartyRegistrationResolver);
            }
            catch (ReflectiveOperationException ex) {
                throw new IllegalStateException("Could not instantiate OpenSaml4LogoutResponseResolver", ex);
            }
        }

        private static Saml2LogoutRequestResolver getLogoutRequestResolver(RelyingPartyRegistrationResolver relyingPartyRegistrationResolver) {
            try {
                Class logoutRequestResolver = ClassUtils.forName((String)"org.springframework.security.saml2.provider.service.web.authentication.logout.OpenSaml4LogoutRequestResolver", (ClassLoader)OpenSaml4LogoutSupportFactory.class.getClassLoader());
                return (Saml2LogoutRequestResolver)logoutRequestResolver.getDeclaredConstructor(RelyingPartyRegistrationResolver.class).newInstance(relyingPartyRegistrationResolver);
            }
            catch (ReflectiveOperationException ex) {
                throw new IllegalStateException("Could not instantiate OpenSaml4LogoutRequestResolver", ex);
            }
        }
    }

    private static class NoopLogoutHandler
    implements LogoutHandler {
        private NoopLogoutHandler() {
        }

        public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        }
    }

    private static class ParameterRequestMatcher
    implements RequestMatcher {
        Predicate<String> test = Objects::nonNull;
        String name;

        ParameterRequestMatcher(String name) {
            this.name = name;
        }

        public boolean matches(HttpServletRequest request) {
            return this.test.test(request.getParameter(this.name));
        }
    }

    private static class Saml2RequestMatcher
    implements RequestMatcher {
        private final SecurityContextHolderStrategy securityContextHolderStrategy;

        Saml2RequestMatcher(SecurityContextHolderStrategy securityContextHolderStrategy) {
            this.securityContextHolderStrategy = securityContextHolderStrategy;
        }

        public boolean matches(HttpServletRequest request) {
            Authentication authentication = this.securityContextHolderStrategy.getContext().getAuthentication();
            if (authentication == null) {
                return false;
            }
            return authentication.getPrincipal() instanceof Saml2AuthenticatedPrincipal;
        }
    }

    public final class LogoutResponseConfigurer {
        private String logoutUrl = "/logout/saml2/slo";
        private Saml2LogoutResponseValidator logoutResponseValidator;
        private Saml2LogoutResponseResolver logoutResponseResolver;

        LogoutResponseConfigurer() {
        }

        public LogoutResponseConfigurer logoutUrl(String logoutUrl) {
            this.logoutUrl = logoutUrl;
            return this;
        }

        public LogoutResponseConfigurer logoutResponseValidator(Saml2LogoutResponseValidator authenticator) {
            this.logoutResponseValidator = authenticator;
            return this;
        }

        public LogoutResponseConfigurer logoutResponseResolver(Saml2LogoutResponseResolver logoutResponseResolver) {
            this.logoutResponseResolver = logoutResponseResolver;
            return this;
        }

        public Saml2LogoutConfigurer<H> and() {
            return Saml2LogoutConfigurer.this;
        }

        private Saml2LogoutResponseValidator logoutResponseValidator() {
            if (this.logoutResponseValidator == null) {
                return new OpenSamlLogoutResponseValidator();
            }
            return this.logoutResponseValidator;
        }

        private Saml2LogoutResponseResolver logoutResponseResolver(RelyingPartyRegistrationResolver relyingPartyRegistrationResolver) {
            if (this.logoutResponseResolver != null) {
                return this.logoutResponseResolver;
            }
            if (Saml2LogoutConfigurer.this.version().startsWith(Saml2LogoutConfigurer.OPEN_SAML_4_VERSION)) {
                return OpenSaml4LogoutSupportFactory.getLogoutResponseResolver(relyingPartyRegistrationResolver);
            }
            return new OpenSaml3LogoutResponseResolver(relyingPartyRegistrationResolver);
        }
    }

    public final class LogoutRequestConfigurer {
        private String logoutUrl = "/logout/saml2/slo";
        private Saml2LogoutRequestValidator logoutRequestValidator;
        private Saml2LogoutRequestResolver logoutRequestResolver;
        private Saml2LogoutRequestRepository logoutRequestRepository = new HttpSessionLogoutRequestRepository();

        LogoutRequestConfigurer() {
        }

        public LogoutRequestConfigurer logoutUrl(String logoutUrl) {
            this.logoutUrl = logoutUrl;
            return this;
        }

        public LogoutRequestConfigurer logoutRequestValidator(Saml2LogoutRequestValidator authenticator) {
            this.logoutRequestValidator = authenticator;
            return this;
        }

        public LogoutRequestConfigurer logoutRequestResolver(Saml2LogoutRequestResolver logoutRequestResolver) {
            this.logoutRequestResolver = logoutRequestResolver;
            return this;
        }

        public LogoutRequestConfigurer logoutRequestRepository(Saml2LogoutRequestRepository logoutRequestRepository) {
            this.logoutRequestRepository = logoutRequestRepository;
            return this;
        }

        public Saml2LogoutConfigurer<H> and() {
            return Saml2LogoutConfigurer.this;
        }

        private Saml2LogoutRequestValidator logoutRequestValidator() {
            if (this.logoutRequestValidator == null) {
                return new OpenSamlLogoutRequestValidator();
            }
            return this.logoutRequestValidator;
        }

        private Saml2LogoutRequestResolver logoutRequestResolver(RelyingPartyRegistrationResolver relyingPartyRegistrationResolver) {
            if (this.logoutRequestResolver != null) {
                return this.logoutRequestResolver;
            }
            if (Saml2LogoutConfigurer.this.version().startsWith(Saml2LogoutConfigurer.OPEN_SAML_4_VERSION)) {
                return OpenSaml4LogoutSupportFactory.getLogoutRequestResolver(relyingPartyRegistrationResolver);
            }
            return new OpenSaml3LogoutRequestResolver(relyingPartyRegistrationResolver);
        }
    }
}

