/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.config.ConfigDataLoader;
import org.springframework.boot.context.config.ConfigDataLoaderContext;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginTrackedValue;
import org.springframework.cloud.config.client.ConfigClientFailFastException;
import org.springframework.cloud.config.client.ConfigClientProperties;
import org.springframework.cloud.config.client.ConfigClientRequestTemplateFactory;
import org.springframework.cloud.config.client.ConfigClientStateHolder;
import org.springframework.cloud.config.client.ConfigServerBootstrapper;
import org.springframework.cloud.config.client.ConfigServerConfigDataResource;
import org.springframework.cloud.config.client.ConfigServerInstanceMonitor;
import org.springframework.cloud.config.client.ConfigServicePropertySourceLocator;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.core.Ordered;
import org.springframework.core.env.MapPropertySource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

public class ConfigServerConfigDataLoader
implements ConfigDataLoader<ConfigServerConfigDataResource>,
Ordered {
    public static final String CONFIG_CLIENT_PROPERTYSOURCE_NAME = "configClient";
    private static final EnumSet<ConfigData.Option> ALL_OPTIONS = EnumSet.allOf(ConfigData.Option.class);
    protected final Log logger;

    public ConfigServerConfigDataLoader(DeferredLogFactory logFactory) {
        this.logger = logFactory.getLog(this.getClass());
    }

    public int getOrder() {
        return -1;
    }

    public ConfigData load(ConfigDataLoaderContext context, ConfigServerConfigDataResource resource) {
        ConfigServerBootstrapper.LoaderInterceptor interceptor;
        if (context.getBootstrapContext().isRegistered(ConfigServerInstanceMonitor.class)) {
            context.getBootstrapContext().get(ConfigServerInstanceMonitor.class);
        }
        if (context.getBootstrapContext().isRegistered(ConfigServerBootstrapper.LoaderInterceptor.class) && (interceptor = (ConfigServerBootstrapper.LoaderInterceptor)context.getBootstrapContext().get(ConfigServerBootstrapper.LoaderInterceptor.class)) != null) {
            Binder binder = (Binder)context.getBootstrapContext().get(Binder.class);
            try {
                return (ConfigData)interceptor.apply(new ConfigServerBootstrapper.LoadContext(context, resource, binder, this::doLoad));
            }
            catch (ConfigClientFailFastException e) {
                context.getBootstrapContext().addCloseListener(event -> event.getApplicationContext().getBeanFactory().registerSingleton(ConfigClientFailFastException.class.getSimpleName(), (Object)e));
                return new ConfigData(Collections.emptyList(), new ConfigData.Option[0]);
            }
        }
        return this.doLoad(context, resource);
    }

    public ConfigData doLoad(ConfigDataLoaderContext context, ConfigServerConfigDataResource resource) {
        ConfigClientProperties properties = resource.getProperties();
        ArrayList<Object> propertySources = new ArrayList<Object>();
        Throwable error = null;
        String errorBody = null;
        try {
            Object[] labels = new String[]{""};
            if (StringUtils.hasText((String)properties.getLabel())) {
                labels = StringUtils.commaDelimitedListToStringArray((String)properties.getLabel());
            }
            String state = ConfigClientStateHolder.getState();
            for (String string : labels) {
                Environment result = this.getRemoteEnvironment(context, resource, string.trim(), state);
                if (result == null) continue;
                this.log(result);
                if (result.getPropertySources() != null) {
                    for (PropertySource source : result.getPropertySources()) {
                        Map<String, Object> map = this.translateOrigins(source.getName(), source.getSource());
                        propertySources.add(0, new OriginTrackedMapPropertySource("configserver:" + source.getName(), map));
                    }
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (StringUtils.hasText((String)result.getState())) {
                    this.putValue(map, "config.client.state", result.getState());
                }
                if (StringUtils.hasText((String)result.getVersion())) {
                    this.putValue(map, "config.client.version", result.getVersion());
                }
                propertySources.add(0, new MapPropertySource(CONFIG_CLIENT_PROPERTYSOURCE_NAME, map));
                if (ALL_OPTIONS.size() == 1) {
                    return new ConfigData(propertySources, new ConfigData.Option[0]);
                }
                if (ALL_OPTIONS.size() == 2) {
                    return new ConfigData(propertySources, new ConfigData.Option[]{ConfigData.Option.IGNORE_IMPORTS, ConfigData.Option.IGNORE_PROFILES});
                }
                if (ALL_OPTIONS.size() <= 2) continue;
                return new ConfigData(propertySources, propertySource -> {
                    String propertySourceName = propertySource.getName();
                    ArrayList<ConfigData.Option> options = new ArrayList<ConfigData.Option>();
                    options.add(ConfigData.Option.IGNORE_IMPORTS);
                    options.add(ConfigData.Option.IGNORE_PROFILES);
                    for (String profile : resource.getAcceptedProfiles()) {
                        if (!propertySourceName.matches(".*[-,]" + profile + ".*")) continue;
                        options.add(ConfigData.Option.PROFILE_SPECIFIC);
                    }
                    return ConfigData.Options.of((ConfigData.Option[])options.toArray(new ConfigData.Option[0]));
                });
            }
            errorBody = String.format("None of labels %s found", Arrays.toString(labels));
        }
        catch (HttpServerErrorException e) {
            error = e;
            if (MediaType.APPLICATION_JSON.includes(e.getResponseHeaders().getContentType())) {
                errorBody = e.getResponseBodyAsString();
            }
        }
        catch (Exception e) {
            error = e;
        }
        if (properties.isFailFast() || !resource.isOptional()) {
            String reason = properties.isFailFast() ? "the fail fast property is set" : "the resource is not optional";
            throw new ConfigClientFailFastException("Could not locate PropertySource and " + reason + ", failing" + (errorBody == null ? "" : ": " + errorBody), (Exception)error);
        }
        this.logger.warn((Object)("Could not locate PropertySource (" + (Object)((Object)resource) + "): " + (error != null ? error.getMessage() : errorBody)));
        return null;
    }

    protected void log(Environment result) {
        List<PropertySource> propertySourceList;
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)String.format("Located environment: name=%s, profiles=%s, label=%s, version=%s, state=%s", result.getName(), result.getProfiles() == null ? "" : Arrays.asList(result.getProfiles()), result.getLabel(), result.getVersion(), result.getState()));
        }
        if (this.logger.isDebugEnabled() && (propertySourceList = result.getPropertySources()) != null) {
            int propertyCount = 0;
            for (PropertySource propertySource : propertySourceList) {
                propertyCount += propertySource.getSource().size();
            }
            this.logger.debug((Object)String.format("Environment %s has %d property sources with %d properties.", result.getName(), result.getPropertySources().size(), propertyCount));
        }
    }

    protected Map<String, Object> translateOrigins(String name, Map<String, Object> source) {
        LinkedHashMap<String, Object> withOrigins = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            Map value;
            boolean hasOrigin = false;
            if (entry.getValue() instanceof Map && (value = (Map)entry.getValue()).size() == 2 && value.containsKey("origin") && value.containsKey("value")) {
                ConfigServicePropertySourceLocator.ConfigServiceOrigin origin = new ConfigServicePropertySourceLocator.ConfigServiceOrigin(name, value.get("origin"));
                OriginTrackedValue trackedValue = OriginTrackedValue.of(value.get("value"), (Origin)origin);
                withOrigins.put(entry.getKey(), trackedValue);
                hasOrigin = true;
            }
            if (hasOrigin) continue;
            withOrigins.put(entry.getKey(), entry.getValue());
        }
        return withOrigins;
    }

    protected void putValue(HashMap<String, Object> map, String key, String value) {
        if (StringUtils.hasText((String)value)) {
            map.put(key, value);
        }
    }

    protected Environment getRemoteEnvironment(ConfigDataLoaderContext context, ConfigServerConfigDataResource resource, String label, String state) {
        ConfigClientProperties properties = resource.getProperties();
        RestTemplate restTemplate = (RestTemplate)context.getBootstrapContext().get(RestTemplate.class);
        String path = "/{name}/{profile}";
        String name = properties.getName();
        String profile = resource.getProfiles();
        String token = properties.getToken();
        int noOfUrls = properties.getUri().length;
        if (noOfUrls > 1) {
            this.logger.info((Object)"Multiple Config Server Urls found listed.");
        }
        Object[] args = new String[]{name, profile};
        if (StringUtils.hasText((String)label)) {
            label = Environment.denormalize(label);
            args = new String[]{name, profile, label};
            path = path + "/{label}";
        }
        ResponseEntity response = null;
        List<MediaType> acceptHeader = Collections.singletonList(MediaType.parseMediaType((String)properties.getMediaType()));
        ConfigClientRequestTemplateFactory requestTemplateFactory = (ConfigClientRequestTemplateFactory)context.getBootstrapContext().get(ConfigClientRequestTemplateFactory.class);
        for (int i = 0; i < noOfUrls; ++i) {
            ConfigClientProperties.Credentials credentials = properties.getCredentials(i);
            String uri = credentials.getUri();
            String username = credentials.getUsername();
            String password = credentials.getPassword();
            this.logger.info((Object)("Fetching config from server at : " + uri));
            try {
                HttpHeaders headers = new HttpHeaders();
                headers.setAccept(acceptHeader);
                requestTemplateFactory.addAuthorizationToken(headers, username, password);
                if (StringUtils.hasText((String)token)) {
                    headers.add("X-Config-Token", token);
                }
                if (StringUtils.hasText((String)state) && properties.isSendState()) {
                    headers.add("X-Config-State", state);
                }
                HttpEntity entity = new HttpEntity((Object)null, (MultiValueMap)headers);
                response = restTemplate.exchange(uri + path, HttpMethod.GET, entity, Environment.class, args);
            }
            catch (HttpClientErrorException e) {
                if (e.getStatusCode() != HttpStatus.NOT_FOUND) {
                    throw e;
                }
            }
            catch (ResourceAccessException e) {
                this.logger.info((Object)("Connect Timeout Exception on Url - " + uri + ". Will be trying the next url if available"));
                if (i != noOfUrls - 1) continue;
                throw e;
            }
            if (response == null || response.getStatusCode() != HttpStatus.OK) {
                return null;
            }
            Environment result = (Environment)response.getBody();
            return result;
        }
        return null;
    }

    @Deprecated
    protected void addAuthorizationToken(ConfigClientProperties configClientProperties, HttpHeaders httpHeaders, String username, String password) {
    }
}

