/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.encryption;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.config.server.encryption.DecryptionNotSupportedException;
import org.springframework.cloud.config.server.encryption.EncryptionTooWeakException;
import org.springframework.cloud.config.server.encryption.EnvironmentPrefixHelper;
import org.springframework.cloud.config.server.encryption.InvalidCipherException;
import org.springframework.cloud.config.server.encryption.KeyNotAvailableException;
import org.springframework.cloud.config.server.encryption.KeyNotInstalledException;
import org.springframework.cloud.config.server.encryption.TextEncryptorLocator;
import org.springframework.cloud.context.encrypt.KeyFormatException;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.codec.Hex;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.security.rsa.crypto.RsaKeyHolder;
import org.springframework.security.rsa.crypto.RsaSecretEncryptor;
import org.springframework.util.Base64Utils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"${spring.cloud.config.server.prefix:}"})
public class EncryptionController {
    private static Log logger = LogFactory.getLog(EncryptionController.class);
    private volatile TextEncryptorLocator encryptorLocator;
    private EnvironmentPrefixHelper helper = new EnvironmentPrefixHelper();
    private String defaultApplicationName = "application";
    private String defaultProfile = "default";

    public EncryptionController(TextEncryptorLocator encryptorLocator) {
        this.encryptorLocator = encryptorLocator;
    }

    public void setDefaultApplicationName(String defaultApplicationName) {
        this.defaultApplicationName = defaultApplicationName;
    }

    public void setDefaultProfile(String defaultProfile) {
        this.defaultProfile = defaultProfile;
    }

    @GetMapping(value={"/key"})
    public String getPublicKey() {
        return this.getPublicKey(this.defaultApplicationName, this.defaultProfile);
    }

    @GetMapping(value={"/key/{name}/{profiles}"})
    public String getPublicKey(@PathVariable String name, @PathVariable String profiles) {
        TextEncryptor encryptor = this.getEncryptor(name, profiles, "");
        if (!(encryptor instanceof RsaKeyHolder)) {
            throw new KeyNotAvailableException();
        }
        return ((RsaKeyHolder)encryptor).getPublicKey();
    }

    @GetMapping(value={"encrypt/status"})
    public Map<String, Object> status() {
        TextEncryptor encryptor = this.getEncryptor(this.defaultApplicationName, this.defaultProfile, "");
        this.validateEncryptionWeakness(encryptor);
        return Collections.singletonMap("status", "OK");
    }

    @PostMapping(value={"encrypt"})
    public String encrypt(@RequestBody String data, @RequestHeader(value="Content-Type") MediaType type) {
        return this.encrypt(this.defaultApplicationName, this.defaultProfile, data, type);
    }

    @PostMapping(value={"/encrypt/{name}/{profiles}"})
    public String encrypt(@PathVariable String name, @PathVariable String profiles, @RequestBody String data, @RequestHeader(value="Content-Type") MediaType type) {
        TextEncryptor encryptor = this.getEncryptor(name, profiles, "");
        this.validateEncryptionWeakness(encryptor);
        String input = this.stripFormData(data, type, false);
        Map<String, String> keys = this.helper.getEncryptorKeys(name, profiles, input);
        String textToEncrypt = this.helper.stripPrefix(input);
        String encrypted = this.helper.addPrefix(keys, this.encryptorLocator.locate(keys).encrypt(textToEncrypt));
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Encrypted data");
        }
        return encrypted;
    }

    @PostMapping(value={"decrypt"})
    public String decrypt(@RequestBody String data, @RequestHeader(value="Content-Type") MediaType type) {
        return this.decrypt(this.defaultApplicationName, this.defaultProfile, data, type);
    }

    @PostMapping(value={"/decrypt/{name}/{profiles}"})
    public String decrypt(@PathVariable String name, @PathVariable String profiles, @RequestBody String data, @RequestHeader(value="Content-Type") MediaType type) {
        TextEncryptor encryptor = this.getEncryptor(name, profiles, "");
        this.checkDecryptionPossible(encryptor);
        this.validateEncryptionWeakness(encryptor);
        try {
            encryptor = this.getEncryptor(name, profiles, data);
            String input = this.stripFormData(this.helper.stripPrefix(data), type, true);
            String decrypted = encryptor.decrypt(input);
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Decrypted cipher data");
            }
            return decrypted;
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)("Cannot decrypt key:" + name + ", value:" + data), (Throwable)e);
            }
            throw new InvalidCipherException();
        }
    }

    private TextEncryptor getEncryptor(String name, String profiles, String data) {
        if (this.encryptorLocator == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Text encryptorLocator is null.");
            }
            throw new KeyNotInstalledException();
        }
        TextEncryptor encryptor = this.encryptorLocator.locate(this.helper.getEncryptorKeys(name, profiles, data));
        if (encryptor == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"TextEncryptor is null.");
            }
            throw new KeyNotInstalledException();
        }
        return encryptor;
    }

    private void validateEncryptionWeakness(TextEncryptor textEncryptor) {
        if (textEncryptor.encrypt("FOO").equals("FOO")) {
            throw new EncryptionTooWeakException();
        }
    }

    private void checkDecryptionPossible(TextEncryptor textEncryptor) {
        if (textEncryptor instanceof RsaSecretEncryptor && !((RsaSecretEncryptor)textEncryptor).canDecrypt()) {
            throw new DecryptionNotSupportedException();
        }
    }

    private String stripFormData(String data, MediaType type, boolean cipher) {
        if (data.endsWith("=") && !type.equals((Object)MediaType.TEXT_PLAIN)) {
            try {
                data = URLDecoder.decode(data, "UTF-8");
                if (cipher) {
                    data = data.replace(" ", "+");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            String candidate = data.substring(0, data.length() - 1);
            if (cipher) {
                if (data.endsWith("=") && data.length() / 2 != (data.length() + 1) / 2) {
                    try {
                        Hex.decode((CharSequence)candidate);
                        return candidate;
                    }
                    catch (IllegalArgumentException e) {
                        try {
                            Base64Utils.decode((byte[])candidate.getBytes());
                            return candidate;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }
                return data;
            }
            data = candidate;
        }
        return data;
    }

    @ExceptionHandler(value={KeyFormatException.class})
    public ResponseEntity<Map<String, Object>> keyFormat() {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("status", "BAD_REQUEST");
        body.put("description", "Key data not in correct format (PEM or jks keystore)");
        return new ResponseEntity(body, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={KeyNotAvailableException.class})
    public ResponseEntity<Map<String, Object>> keyUnavailable() {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("status", "NOT_FOUND");
        body.put("description", "No public key available");
        return new ResponseEntity(body, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={DecryptionNotSupportedException.class})
    public ResponseEntity<Map<String, Object>> decryptionDisabled() {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("status", "BAD_REQUEST");
        body.put("description", "Server-side decryption is not supported");
        return new ResponseEntity(body, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={KeyNotInstalledException.class})
    public ResponseEntity<Map<String, Object>> notInstalled() {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("status", "NO_KEY");
        body.put("description", "No key was installed for encryption service");
        return new ResponseEntity(body, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={EncryptionTooWeakException.class})
    public ResponseEntity<Map<String, Object>> encryptionTooWeak() {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("status", "INVALID");
        body.put("description", "The encryption algorithm is not strong enough");
        return new ResponseEntity(body, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={InvalidCipherException.class})
    public ResponseEntity<Map<String, Object>> invalidCipher() {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("status", "INVALID");
        body.put("description", "Text not encrypted with this key");
        return new ResponseEntity(body, HttpStatus.BAD_REQUEST);
    }
}

