/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.json;

import com.xebialabs.deployit.engine.api.dto.GeneralUsageInfo;
import com.xebialabs.deployit.engine.api.dto.ServerInfo;
import com.xebialabs.deployit.engine.api.dto.ServerPluginInfo;
import com.xebialabs.xltype.serialization.json.JsonWriter;

public class ServerInfoJsonConverter {
    public String toJson(ServerInfo serverInfo) {
        JsonWriter writer = new JsonWriter();
        this.toJson(serverInfo, writer);
        return writer.toString();
    }

    public void toJson(ServerInfo serverInfo, JsonWriter writer) {
        writer.object();
        writer.key("version").value(serverInfo.getVersion());
        writer.key("server-url").value(serverInfo.getServerUrl());
        writer.key("database").value(serverInfo.getDatabaseInfo());
        writer.key("classpath-entries").array();
        serverInfo.getClasspathEntries().forEach(writer::value);
        writer.endArray();
        writer.key("plugins-info").array();
        for (ServerPluginInfo pluginInfo : serverInfo.getPluginsInfo()) {
            writer.object();
            writer.key("plugin").value(pluginInfo.getPlugin());
            writer.key("version").value(pluginInfo.getVersion());
            writer.endObject();
        }
        writer.endArray();
        GeneralUsageInfo generalInfo = serverInfo.getGeneralInfo();
        if (generalInfo != null) {
            writer.key("general-info").object();
            writer.key("deployVersion").value(generalInfo.getDeployVersion());
            writer.key("instanceName").value(generalInfo.getInstanceName());
            writer.key("nodeState").value(generalInfo.getIsNodeActive());
            writer.key("serverUrl").value(generalInfo.getServerUrl());
            writer.key("vmArguments").value(generalInfo.getVmArguments());
            writer.key("vmName").value(generalInfo.getVmName());
            writer.key("systemName").value(generalInfo.getSystemName());
            writer.key("upTime").value(generalInfo.getUpTime());
            writer.key("osName").value(generalInfo.getOsName());
            writer.key("osArchitecture").value(generalInfo.getOsArchitecture());
            writer.key("osAvailableProcessors").value(generalInfo.getOsAvailableProcessors());
            writer.key("maxMemory").value(generalInfo.getMaxMemory());
            writer.key("usedMemory").value(generalInfo.getUsedMemory());
            writer.key("databaseImplementation").value(generalInfo.getDatabaseImplementation());
            writer.key("reportingDatabaseImplementation").value(generalInfo.getReportingDatabaseImplementation());
            writer.key("noHitDBQueryDuration").value(generalInfo.getNoHitDBQueryDuration());
            writer.key("hitDBQueryDuration").value(generalInfo.getHitDBQueryDuration());
            writer.endObject();
        }
        writer.endObject();
    }
}

