/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.ws;

import akka.NotUsed;
import akka.annotation.InternalApi;
import akka.http.impl.engine.ws.FrameData;
import akka.http.impl.engine.ws.FrameError;
import akka.http.impl.engine.ws.FrameEvent;
import akka.http.impl.engine.ws.FrameEventOrError;
import akka.http.impl.engine.ws.FrameEventParser$;
import akka.http.impl.engine.ws.FrameHeader;
import akka.http.impl.engine.ws.FrameStart;
import akka.http.impl.engine.ws.Masking$;
import akka.http.impl.engine.ws.Masking$Masker$;
import akka.http.impl.engine.ws.Protocol;
import akka.http.impl.engine.ws.ProtocolException;
import akka.stream.Attributes;
import akka.stream.FlowShape;
import akka.stream.Inlet;
import akka.stream.Inlet$;
import akka.stream.Outlet;
import akka.stream.Outlet$;
import akka.stream.scaladsl.BidiFlow;
import akka.stream.scaladsl.Flow;
import akka.stream.stage.GraphStage;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.InHandler;
import akka.stream.stage.OutHandler;
import akka.util.ByteString;
import java.util.Random;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005=uAB\u000f\u001f\u0011\u0003!\u0003F\u0002\u0004+=!\u0005Ae\u000b\u0005\u0006e\u0005!\t\u0001\u000e\u0005\u0006k\u0005!\tA\u000e\u0005\u00067\u0006!\t\u0001\u0018\u0005\u0006G\u0006!\t\u0001\u001a\u0004\u0005U\u00051q\rC\u0005\u0002@\u0019\u0011\t\u0011)A\u0005'\"1!G\u0002C\u0001\u0003\u0003Baa\u001e\u0004\u0005\u0002\u0005\u001d\u0003bBA\u0002\r\u0011\u0005\u00111\n\u0005\b\u0003#2A\u0011IA*\u000f\u001d\tY'\u0001E\u0005\u0003[2q!a\u001c\u0002\u0011\u0013\t\t\b\u0003\u00043\u001b\u0011\u0005\u00111\u000f\u0005\u0007o6!\t!!\u001e\t\u000f\u0005\rQ\u0002\"\u0001\u0002z!9\u0011\u0011K\u0007\u0005B\u0005Mc!\u00026\u0002\u0003\u0013Y\u0007\"\u0002\u001a\u0013\t\u00031\b\"B<\u0013\r\u0003A\bbBA\u0002%\u0019\u0005\u0011Q\u0001\u0005\n\u0003\u001b\u0011\"\u0019!C\u0001\u0003\u001fA\u0001\"a\u0006\u0013A\u0003%\u0011\u0011\u0003\u0005\n\u00033\u0011\"\u0019!C\u0001\u00037A\u0001\"a\t\u0013A\u0003%\u0011Q\u0004\u0005\n\u0003K\u0011\"\u0019!C!\u0003OAq!!\u000b\u0013A\u0003%!\u000fC\u0004\u0002,I!\t%!\f\u0002\u000f5\u000b7o[5oO*\u0011q\u0004I\u0001\u0003oNT!!\t\u0012\u0002\r\u0015tw-\u001b8f\u0015\t\u0019C%\u0001\u0003j[Bd'BA\u0013'\u0003\u0011AG\u000f\u001e9\u000b\u0003\u001d\nA!Y6lCB\u0011\u0011&A\u0007\u0002=\t9Q*Y:lS:<7CA\u0001-!\ti\u0003'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001)\u0003\u0015\t\u0007\u000f\u001d7z)\r9\u0014J\u0014\t\bquz$iP F\u001b\u0005I$B\u0001\u001e<\u0003!\u00198-\u00197bINd'B\u0001\u001f'\u0003\u0019\u0019HO]3b[&\u0011a(\u000f\u0002\t\u0005&$\u0017N\u00127poB\u0011\u0011\u0006Q\u0005\u0003\u0003z\u0011!B\u0012:b[\u0016,e/\u001a8u!\tI3)\u0003\u0002E=\t\tbI]1nK\u00163XM\u001c;Pe\u0016\u0013(o\u001c:\u0011\u0005\u0019;U\"\u0001\u0014\n\u0005!3#a\u0002(piV\u001bX\r\u001a\u0005\u0006\u0015\u000e\u0001\raS\u0001\u000bg\u0016\u0014h/\u001a:TS\u0012,\u0007CA\u0017M\u0013\tieFA\u0004C_>dW-\u00198\t\u000b=\u001b\u0001\u0019\u0001)\u0002\u00155\f7o\u001b*b]\u0012|W\u000eE\u0002.#NK!A\u0015\u0018\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004C\u0001+Z\u001b\u0005)&B\u0001,X\u0003\u0011)H/\u001b7\u000b\u0003a\u000bAA[1wC&\u0011!,\u0016\u0002\u0007%\u0006tGm\\7\u0002\r5\f7o[%g)\ri\u0006M\u0019\t\u0006qy{t(R\u0005\u0003?f\u0012AA\u00127po\")\u0011\r\u0002a\u0001\u0017\u0006I1m\u001c8eSRLwN\u001c\u0005\u0006\u001f\u0012\u0001\r\u0001U\u0001\tk:l\u0017m]6JMR\u0011QM\u001a\t\u0006qy{$)\u0012\u0005\u0006C\u0016\u0001\raS\n\u0003\r!\u0004\"!\u001b\n\u000e\u0003\u0005\u0011a!T1tW\u0016\u00148C\u0001\nm!\ri\u0007O]\u0007\u0002]*\u0011qnO\u0001\u0006gR\fw-Z\u0005\u0003c:\u0014!b\u0012:ba\"\u001cF/Y4f!\u0011\u0019Ho\u0010\"\u000e\u0003mJ!!^\u001e\u0003\u0013\u0019cwn^*iCB,G#\u00015\u0002\u0017\u0015DHO]1di6\u000b7o\u001b\u000b\u0003sr\u0004\"!\f>\n\u0005mt#aA%oi\")Q\u0010\u0006a\u0001}\u00061\u0001.Z1eKJ\u0004\"!K@\n\u0007\u0005\u0005aDA\u0006Ge\u0006lW\rS3bI\u0016\u0014\u0018AC:fi:+w/T1tWR)a0a\u0002\u0002\n!)Q0\u0006a\u0001}\"1\u00111B\u000bA\u0002e\fA!\\1tW\u0006\u0011\u0011N\\\u000b\u0003\u0003#\u0001Ba]A\n\u007f%\u0019\u0011QC\u001e\u0003\u000b%sG.\u001a;\u0002\u0007%t\u0007%A\u0002pkR,\"!!\b\u0011\tM\fyBQ\u0005\u0004\u0003CY$AB(vi2,G/\u0001\u0003pkR\u0004\u0013!B:iCB,W#\u0001:\u0002\rMD\u0017\r]3!\u0003-\u0019'/Z1uK2{w-[2\u0015\t\u0005=\u0012Q\u0007\t\u0004[\u0006E\u0012bAA\u001a]\nyqI]1qQN#\u0018mZ3M_\u001eL7\rC\u0004\u00028q\u0001\r!!\u000f\u0002'%t\u0007.\u001a:ji\u0016$\u0017\t\u001e;sS\n,H/Z:\u0011\u0007M\fY$C\u0002\u0002>m\u0012!\"\u0011;ue&\u0014W\u000f^3t\u0003\u0019\u0011\u0018M\u001c3p[R!\u00111IA#!\tIg\u0001\u0003\u0004\u0002@!\u0001\ra\u0015\u000b\u0004s\u0006%\u0003\"B?\n\u0001\u0004qH#\u0002@\u0002N\u0005=\u0003\"B?\u000b\u0001\u0004q\bBBA\u0006\u0015\u0001\u0007\u00110\u0001\u0005u_N#(/\u001b8h)\t\t)\u0006\u0005\u0003\u0002X\u0005\u0015d\u0002BA-\u0003C\u00022!a\u0017/\u001b\t\tiFC\u0002\u0002`M\na\u0001\u0010:p_Rt\u0014bAA2]\u00051\u0001K]3eK\u001aLA!a\u001a\u0002j\t11\u000b\u001e:j]\u001eT1!a\u0019/\u0003%)f.\\1tW&tw\r\u0005\u0002j\u001b\tIQK\\7bg.LgnZ\n\u0003\u001b!$\"!!\u001c\u0015\u0007e\f9\bC\u0003~\u001f\u0001\u0007a\u0010F\u0003\u007f\u0003w\ni\bC\u0003~!\u0001\u0007a\u0010\u0003\u0004\u0002\fA\u0001\r!\u001f\u0015\u0004\u0003\u0005\u0005\u0005\u0003BAB\u0003\u0013k!!!\"\u000b\u0007\u0005\u001de%\u0001\u0006b]:|G/\u0019;j_:LA!a#\u0002\u0006\nY\u0011J\u001c;fe:\fG.\u00119jQ\r\u0001\u0011\u0011\u0011")
@InternalApi
public final class Masking {
    public static Flow<FrameEvent, FrameEventOrError, NotUsed> unmaskIf(boolean condition) {
        return Masking$.MODULE$.unmaskIf(condition);
    }

    public static Flow<FrameEvent, FrameEvent, NotUsed> maskIf(boolean condition, Function0<Random> maskRandom) {
        return Masking$.MODULE$.maskIf(condition, maskRandom);
    }

    public static BidiFlow<FrameEvent, FrameEventOrError, FrameEvent, FrameEvent, NotUsed> apply(boolean serverSide, Function0<Random> maskRandom) {
        return Masking$.MODULE$.apply(serverSide, maskRandom);
    }

    private static abstract class Masker
    extends GraphStage<FlowShape<FrameEvent, FrameEventOrError>> {
        private final Inlet<FrameEvent> in = Inlet$.MODULE$.apply(new StringBuilder(3).append(this.toString()).append("-in").toString());
        private final Outlet<FrameEventOrError> out = Outlet$.MODULE$.apply(new StringBuilder(4).append(this.toString()).append("-out").toString());
        private final FlowShape<FrameEvent, FrameEventOrError> shape = new FlowShape(this.in(), this.out());

        public abstract int extractMask(FrameHeader var1);

        public abstract FrameHeader setNewMask(FrameHeader var1, int var2);

        public Inlet<FrameEvent> in() {
            return this.in;
        }

        public Outlet<FrameEventOrError> out() {
            return this.out;
        }

        public FlowShape<FrameEvent, FrameEventOrError> shape() {
            return this.shape;
        }

        public GraphStageLogic createLogic(Attributes inheritedAttributes) {
            return new OutHandler(this){
                private final /* synthetic */ Masker $outer;

                public void onUpstreamFinish() throws Exception {
                    InHandler.onUpstreamFinish$((InHandler)this);
                }

                public void onUpstreamFailure(Throwable ex) throws Exception {
                    InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
                }

                public void onDownstreamFinish() throws Exception {
                    OutHandler.onDownstreamFinish$((OutHandler)this);
                }

                public void onPush() {
                    FrameEvent frameEvent = (FrameEvent)this.grab(this.$outer.in());
                    if (frameEvent instanceof FrameStart) {
                        BoxedUnit boxedUnit;
                        FrameStart frameStart = (FrameStart)frameEvent;
                        FrameHeader header = frameStart.header();
                        ByteString data = frameStart.data();
                        try {
                            int mask = this.$outer.extractMask(header);
                            Tuple2<ByteString, Object> tuple2 = FrameEventParser$.MODULE$.mask(data, mask);
                            if (tuple2 == null) {
                                throw new MatchError(tuple2);
                            }
                            ByteString masked = (ByteString)tuple2._1();
                            int newMask = tuple2._2$mcI$sp();
                            Tuple2 tuple22 = new Tuple2((Object)masked, (Object)BoxesRunTime.boxToInteger((int)newMask));
                            Tuple2 tuple23 = tuple22;
                            ByteString masked2 = (ByteString)tuple23._1();
                            int newMask2 = tuple23._2$mcI$sp();
                            if (!frameStart.lastPart()) {
                                this.setHandler(this.$outer.in(), this.runningHandler(newMask2, this));
                            }
                            this.push(this.$outer.out(), frameStart.copy(this.$outer.setNewMask(header, mask), masked2));
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        catch (ProtocolException p) {
                            this.setHandler(this.$outer.in(), this.doneHandler());
                            this.push(this.$outer.out(), new FrameError(p));
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                    } else if (frameEvent instanceof FrameData) {
                        this.fail(this.$outer.out(), new IllegalStateException("unexpected FrameData (need FrameStart first)"));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)frameEvent);
                    }
                }

                private InHandler doneHandler() {
                    return new InHandler(this){
                        private final /* synthetic */ Masker$$anon$1 $outer;

                        public void onUpstreamFinish() throws Exception {
                            InHandler.onUpstreamFinish$((InHandler)this);
                        }

                        public void onUpstreamFailure(Throwable ex) throws Exception {
                            InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
                        }

                        public void onPush() {
                            this.$outer.pull(this.$outer.akka$http$impl$engine$ws$Masking$Masker$$anon$$$outer().in());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            InHandler.$init$((InHandler)this);
                        }
                    };
                }

                private InHandler runningHandler(int initialMask, InHandler nextState) {
                    return new InHandler(this, initialMask, nextState){
                        private int mask;
                        private final /* synthetic */ Masker$$anon$1 $outer;
                        private final InHandler nextState$1;

                        public void onUpstreamFinish() throws Exception {
                            InHandler.onUpstreamFinish$((InHandler)this);
                        }

                        public void onUpstreamFailure(Throwable ex) throws Exception {
                            InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
                        }

                        private int mask() {
                            return this.mask;
                        }

                        private void mask_$eq(int x$1) {
                            this.mask = x$1;
                        }

                        public void onPush() {
                            Tuple2<ByteString, Object> tuple2;
                            FrameEvent part = (FrameEvent)this.$outer.grab(this.$outer.akka$http$impl$engine$ws$Masking$Masker$$anon$$$outer().in());
                            if (part.lastPart()) {
                                this.$outer.setHandler(this.$outer.akka$http$impl$engine$ws$Masking$Masker$$anon$$$outer().in(), this.nextState$1);
                            }
                            if ((tuple2 = FrameEventParser$.MODULE$.mask(part.data(), this.mask())) == null) {
                                throw new MatchError(tuple2);
                            }
                            ByteString masked = (ByteString)tuple2._1();
                            int newMask = tuple2._2$mcI$sp();
                            Tuple2 tuple22 = new Tuple2((Object)masked, (Object)BoxesRunTime.boxToInteger((int)newMask));
                            Tuple2 tuple23 = tuple22;
                            ByteString masked2 = (ByteString)tuple23._1();
                            int newMask2 = tuple23._2$mcI$sp();
                            this.mask_$eq(newMask2);
                            this.$outer.push(this.$outer.akka$http$impl$engine$ws$Masking$Masker$$anon$$$outer().out(), part.withData(masked2));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.nextState$1 = nextState$1;
                            InHandler.$init$((InHandler)this);
                            this.mask = initialMask$1;
                        }
                    };
                }

                public void onPull() {
                    this.pull(this.$outer.in());
                }

                public /* synthetic */ Masker akka$http$impl$engine$ws$Masking$Masker$$anon$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    super($outer.shape());
                    OutHandler.$init$((OutHandler)this);
                    InHandler.$init$((InHandler)this);
                    this.setHandler($outer.in(), this);
                    this.setHandler($outer.out(), this);
                }
            };
        }
    }

    private static final class Masking
    extends Masker {
        private final Random random;

        @Override
        public int extractMask(FrameHeader header) {
            return this.random.nextInt();
        }

        @Override
        public FrameHeader setNewMask(FrameHeader header, int mask) {
            if (header.mask().isDefined()) {
                throw new ProtocolException("Frame mustn't already be masked");
            }
            Some x$1 = new Some((Object)BoxesRunTime.boxToInteger((int)mask));
            Protocol.Opcode x$2 = header.copy$default$1();
            long x$3 = header.copy$default$3();
            boolean x$4 = header.copy$default$4();
            boolean x$5 = header.copy$default$5();
            boolean x$6 = header.copy$default$6();
            boolean x$7 = header.copy$default$7();
            return header.copy(x$2, (Option<Object>)x$1, x$3, x$4, x$5, x$6, x$7);
        }

        public String toString() {
            return new StringBuilder(9).append("Masking(").append(this.random).append(")").toString();
        }

        public Masking(Random random) {
            this.random = random;
        }
    }
}

