/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.ast.expr.TupleExpression;

public class ConstructorCallExpression
extends Expression
implements MethodCall {
    private final Expression arguments;
    private boolean usesAnonymousInnerClass;

    public ConstructorCallExpression(ClassNode type, Expression arguments) {
        this.setType(type);
        if (!(arguments instanceof TupleExpression)) {
            this.arguments = new TupleExpression(arguments);
            this.arguments.setSourcePosition(arguments);
        } else {
            this.arguments = arguments;
        }
    }

    @Override
    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitConstructorCallExpression(this);
    }

    @Override
    public Expression transformExpression(ExpressionTransformer transformer) {
        ConstructorCallExpression answer = new ConstructorCallExpression(this.getType(), transformer.transform(this.arguments));
        answer.setUsingAnonymousInnerClass(this.isUsingAnonymousInnerClass());
        answer.setSourcePosition(this);
        answer.copyNodeMetaData(this);
        return answer;
    }

    @Override
    public ASTNode getReceiver() {
        return null;
    }

    @Override
    public String getMethodAsString() {
        return "<init>";
    }

    @Override
    public Expression getArguments() {
        return this.arguments;
    }

    @Override
    public String getText() {
        String text = this.isSuperCall() ? "super " : (this.isThisCall() ? "this " : "new " + this.getType().toString(false));
        return text + this.getArguments().getText();
    }

    public boolean isSpecialCall() {
        return this.isThisCall() || this.isSuperCall();
    }

    public boolean isSuperCall() {
        return this.getType() == ClassNode.SUPER;
    }

    public boolean isThisCall() {
        return this.getType() == ClassNode.THIS;
    }

    public boolean isUsingAnonymousInnerClass() {
        return this.usesAnonymousInnerClass;
    }

    public void setUsingAnonymousInnerClass(boolean usage) {
        this.usesAnonymousInnerClass = usage;
    }

    public String toString() {
        return super.toString() + "[type: " + this.getType() + " arguments: " + this.arguments + "]";
    }
}

