/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.resource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.springframework.cloud.config.server.environment.SearchPathLocator;
import org.springframework.cloud.config.server.resource.NoSuchResourceException;
import org.springframework.cloud.config.server.resource.ResourceRepository;
import org.springframework.cloud.config.server.support.PathUtils;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;

public class GenericResourceRepository
implements ResourceRepository,
ResourceLoaderAware {
    private ResourceLoader resourceLoader;
    private SearchPathLocator service;

    public GenericResourceRepository(SearchPathLocator service) {
        this.service = service;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Override
    public synchronized Resource findOne(String application, String profile, String label, String path) {
        if (StringUtils.hasText((String)path)) {
            String[] locations = this.service.getLocations(application, profile, label).getLocations();
            ArrayList<Resource> locationResources = new ArrayList<Resource>();
            for (String location : locations) {
                if (PathUtils.isInvalidEncodedLocation(location)) continue;
                locationResources.add(this.resourceLoader.getResource(location.replaceFirst("optional:", "")));
            }
            try {
                for (Resource location : locationResources) {
                    for (String local : this.getProfilePaths(profile, path)) {
                        Resource file;
                        if (PathUtils.isInvalidPath(local) || PathUtils.isInvalidEncodedPath(local) || !(file = location.createRelative(local)).exists() || !file.isReadable() || !PathUtils.checkResource(file, location, locationResources)) continue;
                        return file;
                    }
                }
            }
            catch (IOException e) {
                throw new NoSuchResourceException("Error : " + path + ". (" + e.getMessage() + ")");
            }
        }
        throw new NoSuchResourceException("Not found: " + path);
    }

    private Collection<String> getProfilePaths(String profiles, String path) {
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        for (String profile : StringUtils.commaDelimitedListToSet((String)profiles)) {
            if (!StringUtils.hasText((String)profile) || "default".equals(profile)) {
                paths.add(path);
                continue;
            }
            String ext = StringUtils.getFilenameExtension((String)path);
            String file = path;
            if (ext != null) {
                ext = "." + ext;
                file = StringUtils.stripFilenameExtension((String)path);
            } else {
                ext = "";
            }
            paths.add(file + "-" + profile + ext);
        }
        paths.add(path);
        return paths;
    }
}

