/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.itertools;

import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyIterator;
import org.python.core.PyObject;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.Visitproc;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules.itertools.combinationsWithReplacement$PyExposer;
import org.python.modules.itertools.itertools;

@ExposedType(name="itertools.combinations_with_replacement", base=PyObject.class, doc="combinations_with_replacement(iterable, r) --> combinations_with_replacement object\n\nReturn successive r-length combinations of elements in the iterable\nallowing individual elements to have successive repeats.\ncombinations_with_replacement('ABC', 2) --> AA AB AC BB BC CC")
public class combinationsWithReplacement
extends PyIterator {
    public static final PyType TYPE;
    private itertools.ItertoolsIterator iter;
    public static final String combinations_with_replacement_doc = "combinations_with_replacement(iterable, r) --> combinations_with_replacement object\n\nReturn successive r-length combinations of elements in the iterable\nallowing individual elements to have successive repeats.\ncombinations_with_replacement('ABC', 2) --> AA AB AC BB BC CC";

    public combinationsWithReplacement() {
    }

    public combinationsWithReplacement(PyType subType) {
        super(subType);
    }

    public combinationsWithReplacement(PyObject iterable, int r) {
        this.combinationsWithReplacement___init__(iterable, r);
    }

    @ExposedNew
    final void combinationsWithReplacement___init__(PyObject[] args, String[] kwds) {
        if (args.length > 2) {
            throw Py.TypeError("combinations_with_replacement() takes at most 2 arguments (3 given)");
        }
        ArgParser ap = new ArgParser("combinations_with_replacement", args, kwds, "iterable", "r");
        PyObject iterable = ap.getPyObject(0);
        int r = ap.getInt(1);
        if (r < 0) {
            throw Py.ValueError("r must be non-negative");
        }
        this.combinationsWithReplacement___init__(iterable, r);
    }

    private void combinationsWithReplacement___init__(PyObject iterable, final int r) {
        final PyTuple pool = PyTuple.fromIterable(iterable);
        final int n = pool.__len__();
        final int[] indices = new int[r];
        for (int i = 0; i < r; ++i) {
            indices[i] = 0;
        }
        this.iter = new itertools.ItertoolsIterator(){
            boolean firstthru = true;

            @Override
            public PyObject __iternext__() {
                int i;
                if (this.firstthru) {
                    this.firstthru = false;
                    if (n == 0 && r > 0) {
                        return null;
                    }
                    return itertools.makeIndexedTuple(pool, indices);
                }
                for (i = r - 1; i >= 0 && indices[i] == n - 1; --i) {
                }
                if (i < 0) {
                    return null;
                }
                int n2 = i;
                indices[n2] = indices[n2] + 1;
                for (int j = i + 1; j < r; ++j) {
                    indices[j] = indices[j - 1];
                }
                return itertools.makeIndexedTuple(pool, indices);
            }
        };
    }

    @Override
    public PyObject __iternext__() {
        return this.iter.__iternext__();
    }

    @Override
    public PyObject next() {
        return this.doNext(this.__iternext__());
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        int retVal = super.traverse(visit, arg);
        if (retVal != 0) {
            return retVal;
        }
        return this.iter != null ? visit.visit(this.iter, arg) : 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && (this.iter == ob || super.refersDirectlyTo(ob));
    }

    static {
        PyType.addBuilder(combinationsWithReplacement.class, new combinationsWithReplacement$PyExposer());
        TYPE = PyType.fromClass(combinationsWithReplacement.class);
    }
}

