/*
 * Decompiled with CFR 0.152.
 */
package akka.http.shaded.com.twitter.hpack;

import akka.http.shaded.com.twitter.hpack.HeaderField;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class StaticTable {
    private static final String EMPTY = "";
    private static final List<HeaderField> STATIC_TABLE = Arrays.asList(new HeaderField(":authority", ""), new HeaderField(":method", "GET"), new HeaderField(":method", "POST"), new HeaderField(":path", "/"), new HeaderField(":path", "/index.html"), new HeaderField(":scheme", "http"), new HeaderField(":scheme", "https"), new HeaderField(":status", "200"), new HeaderField(":status", "204"), new HeaderField(":status", "206"), new HeaderField(":status", "304"), new HeaderField(":status", "400"), new HeaderField(":status", "404"), new HeaderField(":status", "500"), new HeaderField("accept-charset", ""), new HeaderField("accept-encoding", "gzip, deflate"), new HeaderField("accept-language", ""), new HeaderField("accept-ranges", ""), new HeaderField("accept", ""), new HeaderField("access-control-allow-origin", ""), new HeaderField("age", ""), new HeaderField("allow", ""), new HeaderField("authorization", ""), new HeaderField("cache-control", ""), new HeaderField("content-disposition", ""), new HeaderField("content-encoding", ""), new HeaderField("content-language", ""), new HeaderField("content-length", ""), new HeaderField("content-location", ""), new HeaderField("content-range", ""), new HeaderField("content-type", ""), new HeaderField("cookie", ""), new HeaderField("date", ""), new HeaderField("etag", ""), new HeaderField("expect", ""), new HeaderField("expires", ""), new HeaderField("from", ""), new HeaderField("host", ""), new HeaderField("if-match", ""), new HeaderField("if-modified-since", ""), new HeaderField("if-none-match", ""), new HeaderField("if-range", ""), new HeaderField("if-unmodified-since", ""), new HeaderField("last-modified", ""), new HeaderField("link", ""), new HeaderField("location", ""), new HeaderField("max-forwards", ""), new HeaderField("proxy-authenticate", ""), new HeaderField("proxy-authorization", ""), new HeaderField("range", ""), new HeaderField("referer", ""), new HeaderField("refresh", ""), new HeaderField("retry-after", ""), new HeaderField("server", ""), new HeaderField("set-cookie", ""), new HeaderField("strict-transport-security", ""), new HeaderField("transfer-encoding", ""), new HeaderField("user-agent", ""), new HeaderField("vary", ""), new HeaderField("via", ""), new HeaderField("www-authenticate", ""));
    private static final Map<String, Integer> STATIC_INDEX_BY_NAME = StaticTable.createMap();
    static final int length = STATIC_TABLE.size();

    static HeaderField getEntry(int n) {
        return STATIC_TABLE.get(n - 1);
    }

    static int getIndex(String string) {
        Integer n = STATIC_INDEX_BY_NAME.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    static int getIndex(String string, String string2) {
        int n = StaticTable.getIndex(string);
        if (n == -1) {
            return -1;
        }
        while (n <= length) {
            HeaderField headerField = StaticTable.getEntry(n);
            if (string.equals(headerField.name) && string2.equals(headerField.value)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private static Map<String, Integer> createMap() {
        int n = STATIC_TABLE.size();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(n);
        for (int i = n; i > 0; --i) {
            HeaderField headerField = StaticTable.getEntry(i);
            hashMap.put(headerField.name, i);
        }
        return hashMap;
    }

    private StaticTable() {
    }
}

