/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.vfs2.CacheStrategy;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VfsLog;
import org.apache.commons.vfs2.impl.DefaultFileReplicator;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.impl.PrivilegedFileReplicator;
import org.apache.commons.vfs2.operations.FileOperationProvider;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.FileReplicator;
import org.apache.commons.vfs2.provider.TemporaryFileStore;
import org.apache.commons.vfs2.util.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StandardFileSystemManager
extends DefaultFileSystemManager {
    private static final String CONFIG_RESOURCE = "providers.xml";
    private static final String PLUGIN_CONFIG_RESOURCE = "META-INF/vfs-providers.xml";
    private URL configUri;
    private ClassLoader classLoader;

    public void setConfiguration(String configUri) {
        try {
            this.setConfiguration(new URL(configUri));
        }
        catch (MalformedURLException e) {
            this.getLogger().warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void setConfiguration(URL configUri) {
        this.configUri = configUri;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void init() throws FileSystemException {
        DefaultFileReplicator replicator = this.createDefaultFileReplicator();
        this.setReplicator((FileReplicator)new PrivilegedFileReplicator((FileReplicator)replicator));
        this.setTemporaryFileStore((TemporaryFileStore)replicator);
        if (this.configUri == null) {
            URL url = ((Object)((Object)this)).getClass().getResource(CONFIG_RESOURCE);
            if (url == null) {
                throw new FileSystemException("vfs.impl/find-config-file.error", (Object)CONFIG_RESOURCE);
            }
            this.configUri = url;
        }
        this.configure(this.configUri);
        this.setCacheStrategy(CacheStrategy.ON_CALL);
        super.init();
    }

    protected void configurePlugins() throws FileSystemException {
        Enumeration<URL> enumResources;
        ClassLoader cl = this.findClassLoader();
        try {
            enumResources = cl.getResources(PLUGIN_CONFIG_RESOURCE);
        }
        catch (IOException e) {
            throw new FileSystemException((Throwable)e);
        }
        while (enumResources.hasMoreElements()) {
            URL url = enumResources.nextElement();
            this.configure(url);
        }
    }

    private ClassLoader findClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ((Object)((Object)this)).getClass().getClassLoader();
        }
        return cl;
    }

    protected DefaultFileReplicator createDefaultFileReplicator() {
        return new DefaultFileReplicator();
    }

    private void configure(URL configUri) throws FileSystemException {
        InputStream configStream = null;
        try {
            this.hardCodedConfiguration();
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.impl/load-config.error", (Object)configUri.toString(), (Throwable)e);
        }
        finally {
            if (configStream != null) {
                try {
                    configStream.close();
                }
                catch (IOException e) {
                    this.getLogger().warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }

    private void hardCodedConfiguration() throws FileSystemException {
        this.addProvider("org.apache.commons.vfs2.provider.url.UrlFileProvider", null, null, null, true);
        this.addProvider("org.apache.commons.vfs2.provider.local.DefaultLocalFileProvider", new String[]{"file"}, null, null, false);
        this.addProvider("org.apache.commons.vfs2.provider.zip.ZipFileProvider", new String[]{"zip"}, null, null, false);
        this.addProvider("org.apache.commons.vfs2.provider.tar.TarFileProvider", new String[]{"tar"}, new String[]{"org.apache.commons.vfs2.provider.tar.TarInputStream"}, null, false);
        this.addProvider("org.apache.commons.vfs2.provider.bzip2.Bzip2FileProvider", new String[]{"bz2"}, new String[]{"org.apache.commons.vfs2.provider.bzip2.CBZip2InputStream"}, null, false);
        this.addProvider("org.apache.commons.vfs2.provider.gzip.GzipFileProvider", new String[]{"gz"}, null, null, false);
        this.addProvider("org.apache.commons.vfs2.provider.jar.JarFileProvider", new String[]{"jar", "sar", "ear", "par", "ejb3", "war"}, null, null, false);
        this.addProvider("org.apache.commons.vfs2.provider.temp.TemporaryFileProvider", new String[]{"tmp"}, null, null, false);
        this.addProvider("org.apache.commons.vfs2.provider.ftp.FtpFileProvider", new String[]{"ftp"}, new String[]{"org.apache.commons.net.ftp.FTPFile"}, null, false);
        try {
            this.addProvider("org.rzo.vfs.dropbox.DropboxFileProvider", new String[]{"dbx"}, new String[]{"com.dropbox.core.DbxClient"}, null, false);
        }
        catch (Error ex) {
            this.getLogger().info((Object)("could not load vfs-dbx provider: " + ex.getMessage()));
        }
        catch (Exception ex) {
            this.getLogger().info((Object)("could not load vfs-dbx provider: " + ex.getMessage()));
        }
        this.addProvider("org.apache.commons.vfs2.provider.ftps.FtpsFileProvider", new String[]{"ftps"}, new String[]{"org.apache.commons.net.ftp.FTPFile"}, null, false);
        this.addProvider("org.apache.commons.vfs2.provider.http.HttpFileProvider", new String[]{"http"}, new String[]{"org.apache.commons.httpclient.HttpClient"}, null, false);
        this.addProvider("org.apache.commons.vfs2.provider.https.HttpsFileProvider", new String[]{"https"}, new String[]{"org.apache.commons.httpclient.HttpClient"}, null, false);
        this.addProvider("org.apache.commons.vfs2.provider.sftp.SftpFileProvider", new String[]{"sftp"}, new String[]{"javax.crypto.Cipher", "com.jcraft.jsch.JSch"}, null, false);
        this.addProvider("org.apache.commons.vfs2.provider.res.ResourceFileProvider", new String[]{"res"}, null, null, false);
        this.addProvider("org.apache.commons.vfs2.provider.webdav.WebdavFileProvider", new String[]{"webdav"}, new String[]{"org.apache.commons.httpclient.HttpClient", "org.apache.jackrabbit.webdav.client.methods.DavMethod"}, null, false);
        this.addProvider("org.apache.commons.vfs2.provider.tar.TarFileProvider", new String[]{"tbz2"}, null, new String[]{"bz2", "tar"}, false);
        this.addProvider("org.apache.commons.vfs2.provider.ram.RamFileProvider", new String[]{"ram"}, null, null, false);
        if (this.findClass("org.apache.commons.vfs2.provider.smb.SmbFileProvider")) {
            this.addProvider("org.apache.commons.vfs2.provider.smb.SmbFileProvider", new String[]{"smb"}, new String[]{"jcifs.smb.SmbFile"}, null, false);
        }
        this.addMimeTypeMap("application/zip", "zip");
        this.addMimeTypeMap("application/x-tar", "tar");
        this.addMimeTypeMap("application/x-gzip", "gz");
        this.addExtensionMap("zip", "zip");
        this.addExtensionMap("tar", "tar");
        this.addExtensionMap("jar", "jar");
        this.addExtensionMap("bz2", "bz2");
        this.addExtensionMap("gz", "gz");
        this.addExtensionMap("tgz", "tar");
        this.addExtensionMap("tbz2", "tar");
        this.addExtensionMap("jar", "jar");
    }

    private void addProvider(String providerClassName, String[] schemas, String[] requiredClasses, String[] requiredSchemes, boolean isDefault) throws FileSystemException {
        int i;
        if (requiredSchemes != null) {
            for (i = 0; i < requiredSchemes.length; ++i) {
                String requiredScheme = requiredSchemes[i];
                if (this.hasProvider(requiredScheme)) continue;
                String msg = Messages.getString((String)"vfs.impl/skipping-provider-scheme.debug", (Object[])new String[]{providerClassName, requiredScheme});
                VfsLog.debug((Log)this.getLogger(), (Log)this.getLogger(), (String)msg);
                return;
            }
        }
        if (requiredClasses != null) {
            for (i = 0; i < requiredClasses.length; ++i) {
                String requiredClass = requiredClasses[i];
                if (this.findClass(requiredClass)) continue;
                String msg = Messages.getString((String)"vfs.impl/skipping-provider.debug", (Object[])new String[]{providerClassName, requiredClass});
                VfsLog.debug((Log)this.getLogger(), (Log)this.getLogger(), (String)msg);
                return;
            }
        }
        FileProvider provider = (FileProvider)this.createInstance(providerClassName);
        if (schemas != null && schemas.length > 0) {
            this.addProvider(schemas, provider);
        }
        if (isDefault) {
            this.setDefaultProvider(provider);
        }
    }

    private void configure(String configUri, InputStream configStream) throws FileSystemException {
        try {
            DocumentBuilder builder = this.createDocumentBuilder();
            Element config = builder.parse(configStream).getDocumentElement();
            this.configure(config);
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.impl/load-config.error", (Object)configUri, (Throwable)e);
        }
    }

    private DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setIgnoringComments(true);
        factory.setExpandEntityReferences(true);
        return factory.newDocumentBuilder();
    }

    private void configure(Element config) throws FileSystemException {
        NodeList providers = config.getElementsByTagName("provider");
        int count = providers.getLength();
        for (int i = 0; i < count; ++i) {
            Element provider = (Element)providers.item(i);
            this.addProvider(provider, false);
        }
        NodeList operationProviders = config.getElementsByTagName("operationProvider");
        for (int i = 0; i < operationProviders.getLength(); ++i) {
            Element operationProvider = (Element)operationProviders.item(i);
            this.addOperationProvider(operationProvider);
        }
        NodeList defProviders = config.getElementsByTagName("default-provider");
        if (defProviders.getLength() > 0) {
            Element provider = (Element)defProviders.item(0);
            this.addProvider(provider, true);
        }
        NodeList mimeTypes = config.getElementsByTagName("mime-type-map");
        for (int i = 0; i < mimeTypes.getLength(); ++i) {
            Element map = (Element)mimeTypes.item(i);
            this.addMimeTypeMap(map);
        }
        NodeList extensions = config.getElementsByTagName("extension-map");
        for (int i = 0; i < extensions.getLength(); ++i) {
            Element map = (Element)extensions.item(i);
            this.addExtensionMap(map);
        }
    }

    private void addExtensionMap(Element map) {
        String extension = map.getAttribute("extension");
        String scheme = map.getAttribute("scheme");
        if (scheme != null && scheme.length() > 0) {
            this.addExtensionMap(extension, scheme);
        }
    }

    private void addMimeTypeMap(Element map) {
        String mimeType = map.getAttribute("mime-type");
        String scheme = map.getAttribute("scheme");
        this.addMimeTypeMap(mimeType, scheme);
    }

    private void addProvider(Element providerDef, boolean isDefault) throws FileSystemException {
        String classname = providerDef.getAttribute("class-name");
        String[] requiredSchemes = this.getRequiredSchemes(providerDef);
        for (int i = 0; i < requiredSchemes.length; ++i) {
            String requiredScheme = requiredSchemes[i];
            if (this.hasProvider(requiredScheme)) continue;
            String msg = Messages.getString((String)"vfs.impl/skipping-provider-scheme.debug", (Object[])new String[]{classname, requiredScheme});
            VfsLog.debug((Log)this.getLogger(), (Log)this.getLogger(), (String)msg);
            return;
        }
        String[] requiredClasses = this.getRequiredClasses(providerDef);
        for (int i = 0; i < requiredClasses.length; ++i) {
            String requiredClass = requiredClasses[i];
            if (this.findClass(requiredClass)) continue;
            String msg = Messages.getString((String)"vfs.impl/skipping-provider.debug", (Object[])new String[]{classname, requiredClass});
            VfsLog.debug((Log)this.getLogger(), (Log)this.getLogger(), (String)msg);
            return;
        }
        FileProvider provider = (FileProvider)this.createInstance(classname);
        String[] schemas = this.getSchemas(providerDef);
        if (schemas.length > 0) {
            this.addProvider(schemas, provider);
        }
        if (isDefault) {
            this.setDefaultProvider(provider);
        }
    }

    private void addOperationProvider(Element providerDef) throws FileSystemException {
        String classname = providerDef.getAttribute("class-name");
        String[] schemas = this.getSchemas(providerDef);
        for (int i = 0; i < schemas.length; ++i) {
            String schema = schemas[i];
            if (!this.hasProvider(schema)) continue;
            FileOperationProvider operationProvider = (FileOperationProvider)this.createInstance(classname);
            this.addOperationProvider(schema, operationProvider);
        }
    }

    private boolean findClass(String className) {
        try {
            this.findClassLoader().loadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private String[] getRequiredClasses(Element providerDef) {
        ArrayList<String> classes = new ArrayList<String>();
        NodeList deps = providerDef.getElementsByTagName("if-available");
        int count = deps.getLength();
        for (int i = 0; i < count; ++i) {
            Element dep = (Element)deps.item(i);
            String className = dep.getAttribute("class-name");
            if (className == null || className.length() <= 0) continue;
            classes.add(className);
        }
        return classes.toArray(new String[classes.size()]);
    }

    private String[] getRequiredSchemes(Element providerDef) {
        ArrayList<String> schemes = new ArrayList<String>();
        NodeList deps = providerDef.getElementsByTagName("if-available");
        int count = deps.getLength();
        for (int i = 0; i < count; ++i) {
            Element dep = (Element)deps.item(i);
            String scheme = dep.getAttribute("scheme");
            if (scheme == null || scheme.length() <= 0) continue;
            schemes.add(scheme);
        }
        return schemes.toArray(new String[schemes.size()]);
    }

    private String[] getSchemas(Element provider) {
        ArrayList<String> schemas = new ArrayList<String>();
        NodeList schemaElements = provider.getElementsByTagName("scheme");
        int count = schemaElements.getLength();
        for (int i = 0; i < count; ++i) {
            Element scheme = (Element)schemaElements.item(i);
            schemas.add(scheme.getAttribute("name"));
        }
        return schemas.toArray(new String[schemas.size()]);
    }

    private Object createInstance(String className) throws FileSystemException {
        try {
            Class<?> clazz = this.findClassLoader().loadClass(className);
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.impl/create-provider.error", (Object)className, (Throwable)e);
        }
    }
}

