/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.export.signalfx;

import io.micrometer.core.instrument.Clock;
import io.micrometer.signalfx.SignalFxConfig;
import io.micrometer.signalfx.SignalFxMeterRegistry;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.ConditionalOnEnabledMetricsExport;
import org.springframework.boot.actuate.autoconfigure.metrics.export.signalfx.SignalFxProperties;
import org.springframework.boot.actuate.autoconfigure.metrics.export.signalfx.SignalFxPropertiesConfigAdapter;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={SignalFxMeterRegistry.class})
@ConditionalOnEnabledMetricsExport(value="signalfx")
@EnableConfigurationProperties(value={SignalFxProperties.class})
public class SignalFxMetricsExportAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public SignalFxConfig signalfxConfig(SignalFxProperties props) {
        return new SignalFxPropertiesConfigAdapter(props);
    }

    @Bean
    @ConditionalOnMissingBean
    public SignalFxMeterRegistry signalFxMeterRegistry(SignalFxConfig config, Clock clock) {
        return new SignalFxMeterRegistry(config, clock);
    }
}

