/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.shell;

import java.util.Stack;
import org.hyperic.sigar.shell.SIGINT;
import org.hyperic.sigar.shell.ShellBase;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class ShellIntHandler
implements SignalHandler {
    private static ShellBase handlerShell;
    private static Stack handlers;

    public static void register(ShellBase shell) {
        Signal signal;
        handlerShell = shell;
        handlers = new Stack();
        try {
            signal = new Signal("INT");
        }
        catch (IllegalArgumentException e) {
            return;
        }
        try {
            Signal.handle(signal, new ShellIntHandler());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void handle(Signal signal) {
        if (handlers.empty()) {
            handlerShell.shutdown();
            Runtime.getRuntime().halt(0);
        } else {
            SIGINT handler = (SIGINT)handlers.peek();
            handler.handleSIGINT();
        }
    }

    public static void push(SIGINT handler) {
        handlers.push(handler);
    }

    public static void pop() {
        handlers.pop();
    }
}

