/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.OperationArgumentResolver;
import org.springframework.boot.actuate.endpoint.SecurityContext;
import org.springframework.boot.actuate.endpoint.http.ApiVersion;
import org.springframework.util.Assert;

public class InvocationContext {
    private final Map<String, Object> arguments;
    private final List<OperationArgumentResolver> argumentResolvers;

    public InvocationContext(SecurityContext securityContext, Map<String, Object> arguments) {
        this(null, securityContext, arguments);
    }

    @Deprecated
    public InvocationContext(ApiVersion apiVersion, SecurityContext securityContext, Map<String, Object> arguments) {
        this(securityContext, arguments, OperationArgumentResolver.of(org.springframework.boot.actuate.endpoint.ApiVersion.class, () -> apiVersion != null ? org.springframework.boot.actuate.endpoint.ApiVersion.valueOf(apiVersion.name()) : null));
    }

    public InvocationContext(SecurityContext securityContext, Map<String, Object> arguments, OperationArgumentResolver ... argumentResolvers) {
        Assert.notNull((Object)securityContext, (String)"SecurityContext must not be null");
        Assert.notNull(arguments, (String)"Arguments must not be null");
        this.arguments = arguments;
        this.argumentResolvers = new ArrayList<OperationArgumentResolver>();
        if (argumentResolvers != null) {
            this.argumentResolvers.addAll(Arrays.asList(argumentResolvers));
        }
        this.argumentResolvers.add(OperationArgumentResolver.of(SecurityContext.class, () -> securityContext));
        this.argumentResolvers.add(OperationArgumentResolver.of(Principal.class, securityContext::getPrincipal));
        this.argumentResolvers.add(OperationArgumentResolver.of(org.springframework.boot.actuate.endpoint.ApiVersion.class, () -> org.springframework.boot.actuate.endpoint.ApiVersion.LATEST));
    }

    @Deprecated
    public ApiVersion getApiVersion() {
        org.springframework.boot.actuate.endpoint.ApiVersion version = this.resolveArgument(org.springframework.boot.actuate.endpoint.ApiVersion.class);
        return version != null ? ApiVersion.valueOf(version.name()) : ApiVersion.LATEST;
    }

    @Deprecated
    public SecurityContext getSecurityContext() {
        return this.resolveArgument(SecurityContext.class);
    }

    public Map<String, Object> getArguments() {
        return this.arguments;
    }

    public <T> T resolveArgument(Class<T> argumentType) {
        for (OperationArgumentResolver argumentResolver : this.argumentResolvers) {
            T result;
            if (!argumentResolver.canResolve(argumentType) || (result = argumentResolver.resolve(argumentType)) == null) continue;
            return result;
        }
        return null;
    }

    public boolean canResolve(Class<?> type) {
        for (OperationArgumentResolver argumentResolver : this.argumentResolvers) {
            if (!argumentResolver.canResolve(type)) continue;
            return true;
        }
        return false;
    }
}

