/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.vfs.dropbox;

import com.dropbox.core.DbxEntry;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileNotFolderException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.util.FileObjectUtils;
import org.apache.commons.vfs2.util.Messages;
import org.rzo.vfs.dropbox.DropboxClient;
import org.rzo.vfs.dropbox.DropboxFileSystem;

public class DropboxFileObject
extends AbstractFileObject {
    private static final Map<String, DbxEntry> EMPTY_DBX_FILE_MAP = Collections.unmodifiableMap(new TreeMap());
    private static final DbxEntry UNKNOWN = new DbxEntry.Folder("/", "", false);
    private final Log log = LogFactory.getLog(DropboxFileObject.class);
    private final DropboxFileSystem dbxFs;
    private final String relPath;
    private DbxEntry fileInfo;
    private Map<String, DbxEntry> children;
    private FileObject linkDestination;
    private boolean inRefresh;

    protected DropboxFileObject(AbstractFileName name, DropboxFileSystem fileSystem, FileName rootName) throws FileSystemException {
        super(name, (AbstractFileSystem)fileSystem);
        String relPath;
        this.dbxFs = fileSystem;
        this.relPath = relPath = UriParser.decode((String)rootName.getRelativeName((FileName)name));
    }

    private DbxEntry getChildFile(String name, boolean flush) throws IOException {
        if (flush && !this.inRefresh) {
            this.children = null;
        }
        this.doGetChildren();
        if (this.children == null) {
            return null;
        }
        DbxEntry DbxEntry2 = this.children.get(name);
        return DbxEntry2;
    }

    private void doGetChildren() throws IOException {
        if (this.children != null) {
            return;
        }
        DropboxClient client = this.dbxFs.getClient();
        try {
            String path = this.relPath;
            DbxEntry[] tmpChildren = client.listFiles(this.getAbsPath());
            if (tmpChildren == null || tmpChildren.length == 0) {
                this.children = EMPTY_DBX_FILE_MAP;
            } else {
                this.children = new TreeMap<String, DbxEntry>();
                int i = 0;
                while (i < tmpChildren.length) {
                    DbxEntry child = tmpChildren[i];
                    if (child == null) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)Messages.getString((String)"vfs.provider.dbx/invalid-directory-entry.debug", (Object[])new Object[]{new Integer(i), this.relPath}));
                        }
                    } else if (!".".equals(child.name) && !"..".equals(child.name)) {
                        this.children.put(child.name, child);
                    }
                    ++i;
                }
            }
        }
        finally {
            this.dbxFs.putClient(client);
        }
    }

    protected void doAttach() throws IOException {
    }

    private void getInfo(boolean flush) throws IOException {
        DropboxFileObject parent = (DropboxFileObject)FileObjectUtils.getAbstractFileObject((FileObject)this.getParent());
        DbxEntry newFileInfo = parent != null ? parent.getChildFile(UriParser.decode((String)this.getName().getBaseName()), flush) : new DbxEntry.Folder("/", "", false);
        this.fileInfo = newFileInfo == null ? UNKNOWN : newFileInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws FileSystemException {
        if (!this.inRefresh) {
            try {
                this.inRefresh = true;
                super.refresh();
                FileSystem fileSystem = this.getFileSystem();
                synchronized (fileSystem) {
                    this.fileInfo = null;
                }
            }
            finally {
                this.inRefresh = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDetach() {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            this.fileInfo = null;
            this.children = null;
        }
    }

    protected void onChildrenChanged(FileName child, FileType newType) {
        if (this.children != null && newType.equals((Object)FileType.IMAGINARY)) {
            try {
                this.children.remove(UriParser.decode((String)child.getBaseName()));
            }
            catch (FileSystemException e) {
                throw new RuntimeException(e.getMessage());
            }
        } else {
            this.children = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onChange() throws IOException {
        this.children = null;
        if (this.getType().equals((Object)FileType.IMAGINARY)) {
            FileSystem fileSystem = this.getFileSystem();
            synchronized (fileSystem) {
                this.fileInfo = UNKNOWN;
            }
            return;
        }
        this.getInfo(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileType doGetType() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.fileInfo == null) {
                this.getInfo(false);
            }
            if (this.fileInfo == UNKNOWN) {
                return FileType.IMAGINARY;
            }
            if (this.fileInfo.isFolder()) {
                return FileType.FOLDER;
            }
            if (this.fileInfo.isFile()) {
                return FileType.FILE;
            }
        }
        throw new FileSystemException("vfs.provider.dbx/get-type.error", (Object)this.getName());
    }

    protected FileObject[] doListChildrenResolved() throws Exception {
        this.doGetChildren();
        if (this.children == null) {
            return null;
        }
        FileObject[] result = new FileObject[this.children.size()];
        int i = 0;
        for (DbxEntry entry : this.children.values()) {
            result[i] = this.dbxFs.resolveFile(entry.path);
            ++i;
        }
        return result;
    }

    public FileObject[] getChildren() throws FileSystemException {
        try {
            if (this.doGetType() != FileType.FOLDER) {
                throw new FileNotFolderException((Object)this.getName());
            }
        }
        catch (Exception ex) {
            throw new FileNotFolderException((Object)this.getName(), (Throwable)ex);
        }
        try {
            this.inRefresh = true;
            FileObject[] fileObjectArray = super.getChildren();
            return fileObjectArray;
        }
        finally {
            this.inRefresh = false;
        }
    }

    protected String[] doListChildren() throws Exception {
        this.doGetChildren();
        if (this.children == null) {
            return null;
        }
        String[] childNames = new String[this.children.size()];
        int childNum = -1;
        for (DbxEntry child : this.children.values()) {
            childNames[++childNum] = child.name;
        }
        return UriParser.encode((String[])childNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            boolean ok;
            DropboxClient dbxClient = this.dbxFs.getClient();
            try {
                ok = this.fileInfo.isFolder() ? dbxClient.removeDirectory(this.getAbsPath()) : dbxClient.deleteFile(this.getAbsPath());
            }
            finally {
                this.dbxFs.putClient(dbxClient);
            }
            if (!ok) {
                throw new FileSystemException("vfs.provider.dbx/delete-file.error", (Object)this.getName());
            }
            this.fileInfo = null;
            this.children = EMPTY_DBX_FILE_MAP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRename(FileObject newfile) throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            boolean ok;
            DropboxClient dbxClient = this.dbxFs.getClient();
            try {
                String oldName = this.getName().getPath();
                String newName = newfile.getName().getPath();
                ok = dbxClient.rename(oldName, newName);
            }
            finally {
                this.dbxFs.putClient(dbxClient);
            }
            if (!ok) {
                throw new FileSystemException("vfs.provider.dbx/rename-file.error", new Object[]{this.getName().toString(), newfile});
            }
            this.fileInfo = null;
            this.children = EMPTY_DBX_FILE_MAP;
        }
    }

    protected void doCreateFolder() throws Exception {
        boolean ok;
        DropboxClient client = this.dbxFs.getClient();
        try {
            ok = client.makeDirectory(this.getAbsPath());
        }
        finally {
            this.dbxFs.putClient(client);
        }
        if (!ok) {
            throw new FileSystemException("vfs.provider.dbx/create-folder.error", (Object)this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long doGetContentSize() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.fileInfo.isFile()) {
                return this.fileInfo.asFile().numBytes;
            }
            return this.fileInfo.asFolder().numBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long doGetLastModifiedTime() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.fileInfo.isFile()) {
                return this.fileInfo.asFile().lastModified.getTime();
            }
            if (this.fileInfo.asFolder().lastModified != null) {
                return this.fileInfo.asFolder().lastModified.getTime();
            }
            return 0L;
        }
    }

    protected InputStream doGetInputStream() throws Exception {
        DropboxClient client = this.dbxFs.getClient();
        try {
            InputStream instr = client.retrieveFileStream(this.getAbsPath());
            if (instr == null) {
                throw new FileNotFoundException(this.getName().toString());
            }
            return instr;
        }
        catch (Exception e) {
            this.dbxFs.putClient(client);
            throw e;
        }
    }

    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        DropboxClient client = this.dbxFs.getClient();
        try {
            OutputStream out = null;
            if (!bAppend) {
                out = client.storeFileStream(this.getAbsPath());
            }
            if (out == null) {
                throw new FileSystemException("vfs.provider.dbx/output-error.debug", new Object[]{this.getName()});
            }
            return out;
        }
        catch (Exception e) {
            this.dbxFs.putClient(client);
            throw e;
        }
    }

    String getRelPath() {
        return this.relPath;
    }

    String getAbsPath() {
        return super.getName().getPath();
    }
}

