/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.AwsS3EnvironmentProperties;
import org.springframework.cloud.config.server.environment.AwsS3EnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentRepositoryFactory;

public class AwsS3EnvironmentRepositoryFactory
implements EnvironmentRepositoryFactory<AwsS3EnvironmentRepository, AwsS3EnvironmentProperties> {
    private final ConfigServerProperties server;

    public AwsS3EnvironmentRepositoryFactory(ConfigServerProperties server) {
        this.server = server;
    }

    @Override
    public AwsS3EnvironmentRepository build(AwsS3EnvironmentProperties environmentProperties) {
        AmazonS3ClientBuilder clientBuilder = AmazonS3ClientBuilder.standard();
        if (environmentProperties.getRegion() != null) {
            if (environmentProperties.getEndpoint() != null) {
                AwsClientBuilder.EndpointConfiguration endpointConfiguration = new AwsClientBuilder.EndpointConfiguration(environmentProperties.getEndpoint(), environmentProperties.getRegion());
                clientBuilder.withEndpointConfiguration(endpointConfiguration);
            } else {
                clientBuilder.withRegion(environmentProperties.getRegion());
            }
        }
        AmazonS3 client = (AmazonS3)clientBuilder.build();
        AwsS3EnvironmentRepository repository = new AwsS3EnvironmentRepository(client, environmentProperties.getBucket(), this.server);
        return repository;
    }
}

