/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.mime;

import java.io.IOException;
import java.io.InputStream;
import org.python.bouncycastle.mime.BoundaryLimitedInputStream;
import org.python.bouncycastle.mime.Headers;
import org.python.bouncycastle.mime.LineReader;
import org.python.bouncycastle.mime.MimeContext;
import org.python.bouncycastle.mime.MimeMultipartContext;
import org.python.bouncycastle.mime.MimeParser;
import org.python.bouncycastle.mime.MimeParserContext;
import org.python.bouncycastle.mime.MimeParserListener;
import org.python.bouncycastle.mime.encoding.Base64InputStream;
import org.python.bouncycastle.mime.encoding.QuotedPrintableInputStream;

public class BasicMimeParser
implements MimeParser {
    private final InputStream src;
    private final MimeParserContext parserContext;
    private final String defaultContentTransferEncoding;
    private Headers headers;
    private boolean isMultipart = false;
    private final String boundary;

    public BasicMimeParser(InputStream inputStream) throws IOException {
        this(null, new Headers(inputStream, "7bit"), inputStream);
    }

    public BasicMimeParser(MimeParserContext mimeParserContext, InputStream inputStream) throws IOException {
        this(mimeParserContext, new Headers(inputStream, mimeParserContext.getDefaultContentTransferEncoding()), inputStream);
    }

    public BasicMimeParser(Headers headers2, InputStream inputStream) {
        this(null, headers2, inputStream);
    }

    public BasicMimeParser(MimeParserContext mimeParserContext, Headers headers2, InputStream inputStream) {
        if (headers2.isMultipart()) {
            this.isMultipart = true;
            this.boundary = headers2.getBoundary();
        } else {
            this.boundary = null;
        }
        this.headers = headers2;
        this.parserContext = mimeParserContext;
        this.src = inputStream;
        this.defaultContentTransferEncoding = mimeParserContext != null ? mimeParserContext.getDefaultContentTransferEncoding() : "7bit";
    }

    public void parse(MimeParserListener mimeParserListener) throws IOException {
        MimeContext mimeContext = mimeParserListener.createContext(this.parserContext, this.headers);
        if (this.isMultipart) {
            String string2;
            MimeMultipartContext mimeMultipartContext = (MimeMultipartContext)mimeContext;
            String string3 = "--" + this.boundary;
            boolean bl = false;
            int n = 0;
            LineReader lineReader = new LineReader(this.src);
            while ((string2 = lineReader.readLine()) != null && !"--".equals(string2)) {
                MimeContext mimeContext2;
                Headers headers2;
                InputStream inputStream;
                if (bl) {
                    inputStream = new BoundaryLimitedInputStream(this.src, this.boundary);
                    headers2 = new Headers(inputStream, this.defaultContentTransferEncoding);
                    mimeContext2 = mimeMultipartContext.createContext(n++);
                    inputStream = mimeContext2.applyContext(headers2, inputStream);
                    mimeParserListener.object(this.parserContext, headers2, this.processStream(headers2, inputStream));
                    if (inputStream.read() < 0) continue;
                    throw new IOException("MIME object not fully processed");
                }
                if (!string3.equals(string2)) continue;
                bl = true;
                inputStream = new BoundaryLimitedInputStream(this.src, this.boundary);
                headers2 = new Headers(inputStream, this.defaultContentTransferEncoding);
                mimeContext2 = mimeMultipartContext.createContext(n++);
                inputStream = mimeContext2.applyContext(headers2, inputStream);
                mimeParserListener.object(this.parserContext, headers2, this.processStream(headers2, inputStream));
                if (inputStream.read() < 0) continue;
                throw new IOException("MIME object not fully processed");
            }
        } else {
            InputStream inputStream = mimeContext.applyContext(this.headers, this.src);
            mimeParserListener.object(this.parserContext, this.headers, this.processStream(this.headers, inputStream));
        }
    }

    public boolean isMultipart() {
        return this.isMultipart;
    }

    private InputStream processStream(Headers headers2, InputStream inputStream) {
        if (headers2.getContentTransferEncoding().equals("base64")) {
            return new Base64InputStream(inputStream);
        }
        if (headers2.getContentTransferEncoding().equals("quoted-printable")) {
            return new QuotedPrintableInputStream(inputStream);
        }
        return inputStream;
    }
}

