/*
 * Decompiled with CFR 0.152.
 */
package akka.util;

import akka.annotation.InternalApi;
import akka.util.DoubleLinkedList;
import akka.util.OptionVal;
import akka.util.OptionVal$;
import akka.util.OptionVal$Some$;
import akka.util.RecencyList;
import akka.util.SegmentedRecencyList$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.IndexedSeq;
import scala.collection.mutable.IndexedSeq$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t]uA\u0002%J\u0011\u0003YUJ\u0002\u0004P\u0013\"\u00051\n\u0015\u0005\u0006/\u0006!\t!\u0017\u0005\u00065\u0006!\taW\u0004\b\u0005{\n\u0001\u0012\u0001B@\r\u001d\u0011\t)\u0001E\u0001\u0005\u0007CaaV\u0003\u0005\u0002\t\u0015\u0005B\u0002.\u0006\t\u0003\u00119I\u0002\u0004\u0002P\u00051\u0011\u0011\u000b\u0005\u000b\u0003+B!Q1A\u0005\u0002\u0005]\u0003BCA/\u0011\t\u0005\t\u0015!\u0003\u0002Z!1q\u000b\u0003C\u0001\u0003?B\u0011\"a\u001a\t\u0001\u0004%\t!!\u000b\t\u0013\u0005%\u0004\u00021A\u0005\u0002\u0005-\u0004bBA8\u0011\u0001\u0006K!\u001b\u0005\n\u0003cB\u0001\u0019!C\u0001\u0003gB\u0011\"a\u001f\t\u0001\u0004%\t!! \t\u0011\u0005\u0005\u0005\u0002)Q\u0005\u0003kB\u0011\"a!\t\u0001\u0004%\t!!\"\t\u0013\u0005%\u0005\u00021A\u0005\u0002\u0005-\u0005\u0002CAH\u0011\u0001\u0006K!a\"\t\u0013\u0005E\u0005\u00021A\u0005\u0002\u0005\u0015\u0005\"CAJ\u0011\u0001\u0007I\u0011AAK\u0011!\tI\n\u0003Q!\n\u0005\u001d\u0005\"CAN\u0011\u0001\u0007I\u0011AAC\u0011%\ti\n\u0003a\u0001\n\u0003\ty\n\u0003\u0005\u0002$\"\u0001\u000b\u0015BAD\u0011%\t)\u000b\u0003a\u0001\n\u0003\t)\tC\u0005\u0002(\"\u0001\r\u0011\"\u0001\u0002*\"A\u0011Q\u0016\u0005!B\u0013\t9IB\u0003P\u0013\nYe\f\u0003\u0005a=\t\u0005\t\u0015!\u0003b\u0011!agD!A!\u0002\u0013i\u0007\"B,\u001f\t\u00039\b\"CA\u0007=\u0001\u0007I\u0011BA\b\u0011%\t9B\ba\u0001\n\u0013\tI\u0002\u0003\u0005\u0002&y\u0001\u000b\u0015BA\t\u0011%\t9C\ba\u0001\n\u0013\tI\u0003C\u0005\u0002,y\u0001\r\u0011\"\u0003\u0002.!9\u0011\u0011\u0007\u0010!B\u0013I\u0007\"CA\u001a=\t\u0007I\u0011BA\u0015\u0011\u001d\t)D\bQ\u0001\n%D\u0011\"a\u000e\u001f\u0005\u0004%I!!\u000b\t\u000f\u0005eb\u0004)A\u0005S\"I\u00111\b\u0010C\u0002\u0013%\u0011\u0011\u0006\u0005\b\u0003{q\u0002\u0015!\u0003j\u0011%\tyD\bb\u0001\n\u0013\t\t\u0005\u0003\u0005\u00020z\u0001\u000b\u0011BA\"\u0011%\t\tL\bb\u0001\n\u0013\t\u0019\f\u0003\u0005\u0002@z\u0001\u000b\u0011BA[\u0011%\t\tM\bb\u0001\n\u0013\t\u0019\r\u0003\u0005\u0002Fz\u0001\u000b\u0011BA#\u0011%\t9M\bb\u0001\n\u0013\tI\r\u0003\u0005\u0002Rz\u0001\u000b\u0011BAf\u0011\u001d\t\u0019N\bC\u0001\u0003SAq!!6\u001f\t\u0003\t9\u000eC\u0004\u0002\\z!\t!!8\t\u000f\u0005\u0005h\u0004\"\u0001\u0002d\"9\u0011q\u001d\u0010\u0005\u0002\u0005%\bbBAz=\u0011\u0005\u0011Q\u001f\u0005\b\u0005#qB\u0011\u0001B\n\u0011\u001d\u00119B\bC\u0001\u0005'AqA!\u0007\u001f\t\u0003\u0011Y\u0002C\u0004\u00030y!\tA!\r\t\u000f\t]b\u0004\"\u0003\u0003:!9!1\b\u0010\u0005\n\tu\u0002b\u0002B!=\u0011%!1\t\u0005\b\u0005\u0013rB\u0011\u0002B&\u0011\u001d\u0011yE\bC\u0005\u0005#BqA!\u0016\u001f\t\u0013\u00119\u0006C\u0004\u0003^y!IAa\u0018\t\u000f\t\rd\u0004\"\u0003\u0003f\u0005!2+Z4nK:$X\r\u001a*fG\u0016t7-\u001f'jgRT!AS&\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u0019\u0006!\u0011m[6b!\tq\u0015!D\u0001J\u0005Q\u0019VmZ7f]R,GMU3dK:\u001c\u0017\u0010T5tiN\u0011\u0011!\u0015\t\u0003%Vk\u0011a\u0015\u0006\u0002)\u0006)1oY1mC&\u0011ak\u0015\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012!T\u0001\u0006K6\u0004H/_\u000b\u00049\neDcA/\u0003|A!aJ\bB<+\ty6p\u0005\u0002\u001f#\u0006i\u0011N\\5uS\u0006dG*[7jiN\u00042AY4j\u001b\u0005\u0019'B\u00013f\u0003%IW.\\;uC\ndWM\u0003\u0002g'\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005!\u001c'aA*fcB\u0011!K[\u0005\u0003WN\u00131!\u00138u\u0003\u0015\u0019Gn\\2l!\rqe\u000e]\u0005\u0003_&\u0013\u0011b\u00149uS>tg+\u00197\u0011\u0005E$hB\u0001(s\u0013\t\u0019\u0018*A\u0006SK\u000e,gnY=MSN$\u0018BA;w\u0005\u0015\u0019En\\2l\u0015\t\u0019\u0018\nF\u0003y\u0003\u0013\tY\u0001E\u0002O=e\u0004\"A_>\r\u0001\u0011)AP\bb\u0001{\n\t\u0011)E\u0002\u007f\u0003\u0007\u0001\"AU@\n\u0007\u0005\u00051KA\u0004O_RD\u0017N\\4\u0011\u0007I\u000b)!C\u0002\u0002\bM\u00131!\u00118z\u0011\u0015\u0001\u0017\u00051\u0001b\u0011\u0015a\u0017\u00051\u0001n\u0003\u0019a\u0017.\\5ugV\u0011\u0011\u0011\u0003\t\u0005E\u0006M\u0011.C\u0002\u0002\u0016\r\u0014!\"\u00138eKb,GmU3r\u0003)a\u0017.\\5ug~#S-\u001d\u000b\u0005\u00037\t\t\u0003E\u0002S\u0003;I1!a\bT\u0005\u0011)f.\u001b;\t\u0013\u0005\r2%!AA\u0002\u0005E\u0011a\u0001=%c\u00059A.[7jiN\u0004\u0013A\u0003;pi\u0006dG*[7jiV\t\u0011.\u0001\bu_R\fG\u000eT5nSR|F%Z9\u0015\t\u0005m\u0011q\u0006\u0005\t\u0003G1\u0013\u0011!a\u0001S\u0006YAo\u001c;bY2KW.\u001b;!\u0003\u0019aWM^3mg\u00069A.\u001a<fYN\u0004\u0013A\u00027po\u0016\u001cH/A\u0004m_^,7\u000f\u001e\u0011\u0002\u000f!Lw\r[3ti\u0006A\u0001.[4iKN$\b%\u0001\u0005tK\u001elWM\u001c;t+\t\t\u0019\u0005E\u0003c\u0003'\t)\u0005E\u0003O\u0003\u000f\nY%C\u0002\u0002J%\u0013\u0001\u0003R8vE2,G*\u001b8lK\u0012d\u0015n\u001d;\u0011\t\u00055\u0003\"\u001f\b\u0003\u001d\u0002\u0011AAT8eKV!\u00111KA.'\tA\u0011+A\u0003wC2,X-\u0006\u0002\u0002ZA\u0019!0a\u0017\u0005\u000bqD!\u0019A?\u0002\rY\fG.^3!)\u0011\t\t'!\u001a\u0011\u000b\u0005\r\u0004\"!\u0017\u000e\u0003\u0005Aq!!\u0016\f\u0001\u0004\tI&A\u0003mKZ,G.A\u0005mKZ,Gn\u0018\u0013fcR!\u00111DA7\u0011!\t\u0019#DA\u0001\u0002\u0004I\u0017A\u00027fm\u0016d\u0007%A\u0005uS6,7\u000f^1naV\u0011\u0011Q\u000f\t\u0004%\u0006]\u0014bAA='\n!Aj\u001c8h\u00035!\u0018.\\3ti\u0006l\u0007o\u0018\u0013fcR!\u00111DA@\u0011%\t\u0019\u0003EA\u0001\u0002\u0004\t)(\u0001\u0006uS6,7\u000f^1na\u0002\n!\u0002\\3tgJ+7-\u001a8u+\t\t9\t\u0005\u0003O]\u0006\u0005\u0014A\u00047fgN\u0014VmY3oi~#S-\u001d\u000b\u0005\u00037\ti\tC\u0005\u0002$M\t\t\u00111\u0001\u0002\b\u0006YA.Z:t%\u0016\u001cWM\u001c;!\u0003)iwN]3SK\u000e,g\u000e^\u0001\u000f[>\u0014XMU3dK:$x\fJ3r)\u0011\tY\"a&\t\u0013\u0005\rb#!AA\u0002\u0005\u001d\u0015aC7pe\u0016\u0014VmY3oi\u0002\n\u0011c\u001c<fe\u0006dG\u000eT3tgJ+7-\u001a8u\u0003Uyg/\u001a:bY2dUm]:SK\u000e,g\u000e^0%KF$B!a\u0007\u0002\"\"I\u00111E\r\u0002\u0002\u0003\u0007\u0011qQ\u0001\u0013_Z,'/\u00197m\u0019\u0016\u001c8OU3dK:$\b%A\tpm\u0016\u0014\u0018\r\u001c7N_J,'+Z2f]R\fQc\u001c<fe\u0006dG.T8sKJ+7-\u001a8u?\u0012*\u0017\u000f\u0006\u0003\u0002\u001c\u0005-\u0006\"CA\u00129\u0005\u0005\t\u0019AAD\u0003Iyg/\u001a:bY2luN]3SK\u000e,g\u000e\u001e\u0011\u0002\u0013M,w-\\3oiN\u0004\u0013!B:ju\u0016\u001cXCAA[!\u0015\t9,!0j\u001b\t\tILC\u0002\u0002<\u0016\fq!\\;uC\ndW-\u0003\u0003\u0002\u0016\u0005e\u0016AB:ju\u0016\u001c\b%\u0001\bpm\u0016\u0014\u0018\r\u001c7SK\u000e,gnY=\u0016\u0005\u0005\u0015\u0013aD8wKJ\fG\u000e\u001c*fG\u0016t7-\u001f\u0011\u0002\u00151|wn[;q\u001d>$W-\u0006\u0002\u0002LB9\u0011qWAgs\u0006-\u0013\u0002BAh\u0003s\u00131!T1q\u0003-awn\\6va:{G-\u001a\u0011\u0002\tML'0Z\u0001\u0007g&TXm\u00144\u0015\u0007%\fI\u000e\u0003\u0004\u0002h]\u0002\r![\u0001\u0007kB$\u0017\r^3\u0015\u0007a\fy\u000e\u0003\u0004\u0002Va\u0002\r!_\u0001\u0007e\u0016lwN^3\u0015\u0007a\f)\u000f\u0003\u0004\u0002Ve\u0002\r!_\u0001\tG>tG/Y5ogR!\u00111^Ay!\r\u0011\u0016Q^\u0005\u0004\u0003_\u001c&a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003+R\u0004\u0019A=\u0002'1,\u0017m\u001d;U_6{7\u000f\u001e*fG\u0016tGo\u00144\u0015\t\u0005](q\u0002\t\u0006\u0003s\u0014I!\u001f\b\u0005\u0003w\u0014)A\u0004\u0003\u0002~\n\rQBAA\u0000\u0015\r\u0011\t\u0001W\u0001\u0007yI|w\u000e\u001e \n\u0003QK1Aa\u0002T\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\u0003\u0003\u000e\tA\u0011\n^3sCR|'OC\u0002\u0003\bMCa!a\u001a<\u0001\u0004I\u0017A\u0007:f[>4X\rT3bgR\u0014VmY3oi>3XM\u001d'j[&$HC\u0001B\u000b!\r\u0011w-_\u0001\u0012e\u0016lwN^3MK\u0006\u001cHOU3dK:$\u0018a\b:f[>4Xm\u0014<fe\u0006dG\u000eT3bgR\u0014VmY3oi>+Ho]5eKR!!Q\u0003B\u000f\u0011\u001d\u0011yB\u0010a\u0001\u0005C\t\u0001\u0002Z;sCRLwN\u001c\t\u0005\u0005G\u0011Y#\u0004\u0002\u0003&)!!q\u0004B\u0014\u0015\r\u0011IcU\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002\u0002B\u0017\u0005K\u0011aBR5oSR,G)\u001e:bi&|g.\u0001\u0007va\u0012\fG/\u001a'j[&$8\u000f\u0006\u0003\u0002\u001c\tM\u0002B\u0002B\u001b\u007f\u0001\u0007\u0011-A\u0005oK^d\u0015.\\5ug\u0006)\u0012\r\u001a6vgR\u0004&o\u001c;fGR,G\rT3wK2\u001cHCAA\u000e\u0003\u0019\tGM[;tiR!\u00111\u0004B \u0011\u0019\t9'\u0011a\u0001S\u00061\u0011N\\:feR$B!a\u0007\u0003F!9!q\t\"A\u0002\u0005-\u0013\u0001\u00028pI\u0016\fq\u0001\u001d:p[>$X\r\u0006\u0003\u0002\u001c\t5\u0003b\u0002B$\u0007\u0002\u0007\u00111J\u0001\u0007I\u0016lw\u000e^3\u0015\t\u0005m!1\u000b\u0005\b\u0005\u000f\"\u0005\u0019AA&\u0003!\t\u0007\u000f]3oIR{GCBA\u000e\u00053\u0012Y\u0006\u0003\u0004\u0002h\u0015\u0003\r!\u001b\u0005\b\u0005\u000f*\u0005\u0019AA&\u0003Y\u0011X-\\8wK\u001a\u0013x.\\\"veJ,g\u000e\u001e'fm\u0016dG\u0003BA\u000e\u0005CBqAa\u0012G\u0001\u0004\tY%\u0001\u0006sK6|g/\u001a(pI\u0016$2!\u001fB4\u0011\u001d\u00119e\u0012a\u0001\u0003\u0017B3A\bB6!\u0011\u0011iGa\u001d\u000e\u0005\t=$b\u0001B9\u0017\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tU$q\u000e\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018\u000eE\u0002{\u0005s\"Q\u0001`\u0002C\u0002uDa!!\u0004\u0004\u0001\u0004\t\u0017AE<ji\"|e/\u001a:bY2\u0014VmY3oGf\u00042!a\u0019\u0006\u0005I9\u0018\u000e\u001e5Pm\u0016\u0014\u0018\r\u001c7SK\u000e,gnY=\u0014\u0005\u0015\tFC\u0001B@+\u0011\u0011IIa$\u0015\t\t-%\u0011\u0013\t\u0005\u001dz\u0011i\tE\u0002{\u0005\u001f#Q\u0001`\u0004C\u0002uDa!!\u0004\b\u0001\u0004\t\u0007fA\u0001\u0003l!\u001a\u0001Aa\u001b")
@InternalApi
public final class SegmentedRecencyList<A> {
    private final RecencyList.Clock clock;
    private scala.collection.immutable.IndexedSeq<Object> limits;
    private int totalLimit;
    private final int levels;
    private final int lowest;
    private final int highest;
    private final scala.collection.immutable.IndexedSeq<DoubleLinkedList<Node<A>>> segments;
    private final IndexedSeq<Object> sizes;
    private final DoubleLinkedList<Node<A>> overallRecency;
    private final Map<A, Node<A>> lookupNode;

    public static <A> SegmentedRecencyList<A> empty(Seq<Object> limits) {
        return SegmentedRecencyList$.MODULE$.empty(limits);
    }

    private scala.collection.immutable.IndexedSeq<Object> limits() {
        return this.limits;
    }

    private void limits_$eq(scala.collection.immutable.IndexedSeq<Object> x$1) {
        this.limits = x$1;
    }

    private int totalLimit() {
        return this.totalLimit;
    }

    private void totalLimit_$eq(int x$1) {
        this.totalLimit = x$1;
    }

    private int levels() {
        return this.levels;
    }

    private int lowest() {
        return this.lowest;
    }

    private int highest() {
        return this.highest;
    }

    private scala.collection.immutable.IndexedSeq<DoubleLinkedList<Node<A>>> segments() {
        return this.segments;
    }

    private IndexedSeq<Object> sizes() {
        return this.sizes;
    }

    private DoubleLinkedList<Node<A>> overallRecency() {
        return this.overallRecency;
    }

    private Map<A, Node<A>> lookupNode() {
        return this.lookupNode;
    }

    public int size() {
        return this.lookupNode().size();
    }

    public int sizeOf(int level) {
        return BoxesRunTime.unboxToInt((Object)this.sizes().apply(level));
    }

    public SegmentedRecencyList<A> update(A value) {
        if (this.lookupNode().contains(value)) {
            this.promote((Node)this.lookupNode().apply(value));
        } else {
            this.insert(new Node<A>(value));
        }
        return this;
    }

    public SegmentedRecencyList<A> remove(A value) {
        Object object = this.lookupNode().contains(value) ? this.removeNode((Node)this.lookupNode().apply(value)) : BoxedUnit.UNIT;
        return this;
    }

    public boolean contains(A value) {
        return this.lookupNode().contains(value);
    }

    public Iterator<A> leastToMostRecentOf(int level) {
        return ((DoubleLinkedList)this.segments().apply(level)).forwardIterator().map((Function1 & Serializable)x$5 -> x$5.value());
    }

    public Seq<A> removeLeastRecentOverLimit() {
        List list;
        if (this.size() > this.totalLimit()) {
            this.adjustProtectedLevels();
            int excess = this.size() - this.totalLimit();
            list = excess == 1 ? this.removeLeastRecent() : ((DoubleLinkedList)this.segments().apply(this.lowest())).forwardIterator().take(excess).map((Function1 & Serializable)node -> this.removeNode((Node)node)).toList();
        } else {
            list = package$.MODULE$.Nil();
        }
        return list;
    }

    public Seq<A> removeLeastRecent() {
        Nil$ nil$;
        Node node = (Node)((DoubleLinkedList)this.segments().apply(this.lowest())).getFirst();
        Node node2 = OptionVal$Some$.MODULE$.unapply(node);
        if (!OptionVal$.MODULE$.isEmpty$extension(node2)) {
            Node first = OptionVal$.MODULE$.get$extension(node2);
            nil$ = (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.removeNode(first)}));
        } else {
            nil$ = package$.MODULE$.Nil();
        }
        return nil$;
    }

    public Seq<A> removeOverallLeastRecentOutside(FiniteDuration duration) {
        if (OptionVal$.MODULE$.isEmpty$extension(this.clock)) {
            throw new UnsupportedOperationException("Overall recency is not enabled");
        }
        long min = OptionVal$.MODULE$.get$extension(this.clock).earlierTime(duration);
        return this.overallRecency().forwardIterator().takeWhile((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)SegmentedRecencyList.$anonfun$removeOverallLeastRecentOutside$1(min, x$6))).map((Function1 & Serializable)node -> this.removeNode((Node)node)).toList();
    }

    public void updateLimits(Seq<Object> newLimits) {
        this.limits_$eq((scala.collection.immutable.IndexedSeq<Object>)newLimits.toIndexedSeq());
        this.totalLimit_$eq(BoxesRunTime.unboxToInt((Object)this.limits().sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
    }

    private void adjustProtectedLevels() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.highest()), this.lowest()).by(-1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)level -> this.adjust(level));
    }

    private void adjust(int level) {
        block0: {
            int excess = BoxesRunTime.unboxToInt((Object)this.sizes().apply(level)) - BoxesRunTime.unboxToInt((Object)this.limits().apply(level));
            if (excess <= 0) break block0;
            ((DoubleLinkedList)this.segments().apply(level)).forwardIterator().take(excess).foreach((Function1 & Serializable)node -> {
                this.demote(node);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void insert(Node<A> node) {
        block0: {
            this.appendTo(this.lowest(), node);
            this.lookupNode().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(node.value()), node));
            if (!OptionVal$.MODULE$.isDefined$extension(this.clock)) break block0;
            node.timestamp_$eq(OptionVal$.MODULE$.get$extension(this.clock).currentTime());
            this.overallRecency().append(node);
        }
    }

    private void promote(Node<A> node) {
        block2: {
            BoxedUnit boxedUnit;
            if (node.level() == this.highest()) {
                boxedUnit = ((DoubleLinkedList)this.segments().apply(node.level())).moveToBack(node);
            } else {
                int newLevel = node.level() + 1;
                this.removeFromCurrentLevel(node);
                this.appendTo(newLevel, node);
                this.adjust(newLevel);
                boxedUnit = BoxedUnit.UNIT;
            }
            if (!OptionVal$.MODULE$.isDefined$extension(this.clock)) break block2;
            node.timestamp_$eq(OptionVal$.MODULE$.get$extension(this.clock).currentTime());
            this.overallRecency().moveToBack(node);
        }
    }

    private void demote(Node<A> node) {
        this.removeFromCurrentLevel(node);
        this.appendTo(node.level() - 1, node);
    }

    private void appendTo(int level, Node<A> node) {
        node.level_$eq(level);
        ((DoubleLinkedList)this.segments().apply(level)).append(node);
        this.sizes().update(level, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.sizes().apply(level)) + 1)));
    }

    private void removeFromCurrentLevel(Node<A> node) {
        ((DoubleLinkedList)this.segments().apply(node.level())).remove(node);
        int n = node.level();
        this.sizes().update(n, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.sizes().apply(n)) - 1)));
    }

    /*
     * WARNING - void declaration
     */
    private A removeNode(Node<A> node) {
        void var2_2;
        A value = node.value();
        this.removeFromCurrentLevel(node);
        if (OptionVal$.MODULE$.isDefined$extension(this.clock)) {
            this.overallRecency().remove(node);
        }
        this.lookupNode().$minus$eq(value);
        return var2_2;
    }

    public static final /* synthetic */ boolean $anonfun$removeOverallLeastRecentOutside$1(long min$1, Node x$6) {
        return x$6.timestamp() < min$1;
    }

    public SegmentedRecencyList(Seq<Object> initialLimits, RecencyList.Clock clock) {
        this.clock = clock;
        this.limits = initialLimits.toIndexedSeq();
        this.totalLimit = BoxesRunTime.unboxToInt((Object)this.limits().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        this.levels = this.limits().size();
        this.lowest = 0;
        this.highest = this.levels() - 1;
        this.segments = (scala.collection.immutable.IndexedSeq)package$.MODULE$.IndexedSeq().fill(this.levels(), (Function0 & Serializable)() -> new DoubleLinkedList((Function1 & Serializable)x$1 -> new OptionVal<Node>(x$1.lessRecent()), (Function1 & Serializable)x$2 -> new OptionVal<Node>(x$2.moreRecent()), (Function2 & Serializable)(node, previous) -> {
            node.lessRecent_$eq((Node)((OptionVal)previous).x());
            return BoxedUnit.UNIT;
        }, (Function2 & Serializable)(node, next) -> {
            node.moreRecent_$eq((Node)((OptionVal)next).x());
            return BoxedUnit.UNIT;
        }));
        this.sizes = (IndexedSeq)IndexedSeq$.MODULE$.fill(this.levels(), (Function0)(JFunction0.mcI.sp & Serializable)() -> 0);
        this.overallRecency = new DoubleLinkedList((Function1 & Serializable)x$3 -> new OptionVal<Node>(x$3.overallLessRecent()), (Function1 & Serializable)x$4 -> new OptionVal<Node>(x$4.overallMoreRecent()), (Function2 & Serializable)(node, previous) -> {
            node.overallLessRecent_$eq((Node)((OptionVal)previous).x());
            return BoxedUnit.UNIT;
        }, (Function2 & Serializable)(node, next) -> {
            node.overallMoreRecent_$eq((Node)((OptionVal)next).x());
            return BoxedUnit.UNIT;
        });
        this.lookupNode = (Map)Map$.MODULE$.empty();
    }

    private static final class Node<A> {
        private final A value;
        private int level;
        private long timestamp;
        private Node<A> lessRecent;
        private Node<A> moreRecent;
        private Node<A> overallLessRecent;
        private Node<A> overallMoreRecent;

        public A value() {
            return this.value;
        }

        public int level() {
            return this.level;
        }

        public void level_$eq(int x$1) {
            this.level = x$1;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public void timestamp_$eq(long x$1) {
            this.timestamp = x$1;
        }

        public Node<A> lessRecent() {
            return this.lessRecent;
        }

        public void lessRecent_$eq(Node<A> x$1) {
            this.lessRecent = x$1;
        }

        public Node<A> moreRecent() {
            return this.moreRecent;
        }

        public void moreRecent_$eq(Node<A> x$1) {
            this.moreRecent = x$1;
        }

        public Node<A> overallLessRecent() {
            return this.overallLessRecent;
        }

        public void overallLessRecent_$eq(Node<A> x$1) {
            this.overallLessRecent = x$1;
        }

        public Node<A> overallMoreRecent() {
            return this.overallMoreRecent;
        }

        public void overallMoreRecent_$eq(Node<A> x$1) {
            this.overallMoreRecent = x$1;
        }

        public Node(A value) {
            this.value = value;
            this.level = 0;
            this.timestamp = 0L;
            OptionVal$.MODULE$.None();
            this.lessRecent = null;
            OptionVal$.MODULE$.None();
            this.moreRecent = null;
            OptionVal$.MODULE$.None();
            this.overallLessRecent = null;
            OptionVal$.MODULE$.None();
            this.overallMoreRecent = null;
        }
    }
}

