/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.RedisEnvironmentProperties;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.StringUtils;

public class RedisEnvironmentRepository
implements EnvironmentRepository {
    private final StringRedisTemplate redis;
    private final RedisEnvironmentProperties properties;

    public RedisEnvironmentRepository(StringRedisTemplate redis, RedisEnvironmentProperties properties) {
        this.redis = redis;
        this.properties = properties;
    }

    @Override
    public Environment findOne(String application, String profile, String label) {
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        Environment environment = new Environment(application, profiles, label, null, null);
        List<String> keys = this.addKeys(application, Arrays.asList(profiles));
        keys.forEach(it -> {
            Map m = this.redis.opsForHash().entries(it);
            environment.add(new PropertySource("redis:" + it, m));
        });
        return environment;
    }

    private List<String> addKeys(String application, List<String> profiles) {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(application);
        for (String profile : profiles) {
            keys.add(application + "-" + profile);
        }
        Collections.reverse(keys);
        return keys;
    }
}

