/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client;

import java.util.LinkedHashMap;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.commons.util.InetUtilsProperties;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class HostInfoEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private int order = -2147483639;

    public int getOrder() {
        return this.order;
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        InetUtils.HostInfo hostInfo = this.getFirstNonLoopbackHostInfo(environment);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("spring.cloud.client.hostname", hostInfo.getHostname());
        map.put("spring.cloud.client.ip-address", hostInfo.getIpAddress());
        MapPropertySource propertySource = new MapPropertySource("springCloudClientHostInfo", map);
        environment.getPropertySources().addLast((PropertySource)propertySource);
    }

    private InetUtils.HostInfo getFirstNonLoopbackHostInfo(ConfigurableEnvironment environment) {
        InetUtilsProperties target = new InetUtilsProperties();
        ConfigurationPropertySources.attach((Environment)environment);
        Binder.get((Environment)environment).bind("spring.cloud.inetutils", Bindable.ofInstance((Object)target));
        try (InetUtils utils = new InetUtils(target);){
            InetUtils.HostInfo hostInfo = utils.findFirstNonLoopbackHostInfo();
            return hostInfo;
        }
    }
}

