/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.xebialabs.deployit.security.authentication.AuthenticationFailureException;
import com.xebialabs.deployit.security.permission.Permission;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class Permissions {
    private static final Logger logger = LoggerFactory.getLogger(Permissions.class);

    public static Authentication getAuthentication() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    public static String getAuthenticatedUserName() {
        return Permissions.getAuthentication() != null ? Permissions.getAuthentication().getName() : null;
    }

    public static Collection<String> authenticationToPrincipals(Authentication authentication) {
        if (authentication == null) {
            throw new AuthenticationFailureException();
        }
        String name = authentication.getName();
        Collection allPrincipals = authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toCollection(HashSet::new));
        allPrincipals.add(name);
        logger.trace("All principals for user [{}] are: {}", (Object)authentication.getName(), (Object)allPrincipals);
        return allPrincipals;
    }

    public static void clearSecurityContext() {
        SecurityContextHolder.clearContext();
    }

    public static Collection<Permission> isApplicableTo(Collection<Permission> values, String id) {
        return Permissions.isApplicableTo(values, id, true);
    }

    public static Collection<Permission> isApplicableTo(Collection<Permission> values, String id, boolean checkRoot) {
        return values.stream().filter(p -> !p.isApplicableTo(id, checkRoot)).collect(Collectors.toList());
    }
}

