/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import org.springframework.aop.Advisor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.authorization.method.AuthorizationManagerAfterMethodInterceptor;
import org.springframework.security.authorization.method.AuthorizationManagerBeforeMethodInterceptor;
import org.springframework.security.authorization.method.PostAuthorizeAuthorizationManager;
import org.springframework.security.authorization.method.PostFilterAuthorizationMethodInterceptor;
import org.springframework.security.authorization.method.PreAuthorizeAuthorizationManager;
import org.springframework.security.authorization.method.PreFilterAuthorizationMethodInterceptor;
import org.springframework.security.config.core.GrantedAuthorityDefaults;

@Configuration(proxyBeanMethods=false)
@Role(value=2)
final class PrePostMethodSecurityConfiguration
implements ApplicationContextAware {
    private final PreFilterAuthorizationMethodInterceptor preFilterAuthorizationMethodInterceptor = new PreFilterAuthorizationMethodInterceptor();
    private final PreAuthorizeAuthorizationManager preAuthorizeAuthorizationManager = new PreAuthorizeAuthorizationManager();
    private final PostAuthorizeAuthorizationManager postAuthorizeAuthorizationManager = new PostAuthorizeAuthorizationManager();
    private final PostFilterAuthorizationMethodInterceptor postFilterAuthorizationMethodInterceptor = new PostFilterAuthorizationMethodInterceptor();
    private final DefaultMethodSecurityExpressionHandler expressionHandler = new DefaultMethodSecurityExpressionHandler();
    private boolean customMethodSecurityExpressionHandler = false;

    PrePostMethodSecurityConfiguration() {
    }

    @Bean
    @Role(value=2)
    Advisor preFilterAuthorizationMethodInterceptor() {
        if (!this.customMethodSecurityExpressionHandler) {
            this.preAuthorizeAuthorizationManager.setExpressionHandler((MethodSecurityExpressionHandler)this.expressionHandler);
        }
        return this.preFilterAuthorizationMethodInterceptor;
    }

    @Bean
    @Role(value=2)
    Advisor preAuthorizeAuthorizationMethodInterceptor() {
        if (!this.customMethodSecurityExpressionHandler) {
            this.preAuthorizeAuthorizationManager.setExpressionHandler((MethodSecurityExpressionHandler)this.expressionHandler);
        }
        return AuthorizationManagerBeforeMethodInterceptor.preAuthorize((PreAuthorizeAuthorizationManager)this.preAuthorizeAuthorizationManager);
    }

    @Bean
    @Role(value=2)
    Advisor postAuthorizeAuthorizationMethodInterceptor() {
        if (!this.customMethodSecurityExpressionHandler) {
            this.postAuthorizeAuthorizationManager.setExpressionHandler((MethodSecurityExpressionHandler)this.expressionHandler);
        }
        return AuthorizationManagerAfterMethodInterceptor.postAuthorize((PostAuthorizeAuthorizationManager)this.postAuthorizeAuthorizationManager);
    }

    @Bean
    @Role(value=2)
    Advisor postFilterAuthorizationMethodInterceptor() {
        if (!this.customMethodSecurityExpressionHandler) {
            this.postFilterAuthorizationMethodInterceptor.setExpressionHandler((MethodSecurityExpressionHandler)this.expressionHandler);
        }
        return this.postFilterAuthorizationMethodInterceptor;
    }

    @Autowired(required=false)
    void setMethodSecurityExpressionHandler(MethodSecurityExpressionHandler methodSecurityExpressionHandler) {
        this.customMethodSecurityExpressionHandler = true;
        this.preFilterAuthorizationMethodInterceptor.setExpressionHandler(methodSecurityExpressionHandler);
        this.preAuthorizeAuthorizationManager.setExpressionHandler(methodSecurityExpressionHandler);
        this.postAuthorizeAuthorizationManager.setExpressionHandler(methodSecurityExpressionHandler);
        this.postFilterAuthorizationMethodInterceptor.setExpressionHandler(methodSecurityExpressionHandler);
    }

    @Autowired(required=false)
    void setGrantedAuthorityDefaults(GrantedAuthorityDefaults grantedAuthorityDefaults) {
        this.expressionHandler.setDefaultRolePrefix(grantedAuthorityDefaults.getRolePrefix());
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.expressionHandler.setApplicationContext(context);
    }
}

