/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.packager.io;

import com.typesafe.config.Config;
import com.xebialabs.deployit.util.TryWith$;
import com.xebialabs.xldeploy.packager.io.ArchiveStreamStreamer;
import com.xebialabs.xldeploy.packager.io.ArchiveStreamer;
import com.xebialabs.xldeploy.packager.io.ArtifactIOUtils$;
import com.xebialabs.xldeploy.packager.io.DirectoryStreamer;
import com.xebialabs.xldeploy.packager.io.EmptyStreamer;
import com.xebialabs.xldeploy.packager.io.FileStreamStreamer;
import com.xebialabs.xldeploy.packager.io.FileStreamer;
import com.xebialabs.xldeploy.packager.io.JarArchiveStreamStreamer;
import com.xebialabs.xldeploy.packager.io.JarFileArchiveStreamer;
import com.xebialabs.xldeploy.packager.io.Streamer;
import com.xebialabs.xldeploy.packager.io.StreamerFactory$;
import com.xebialabs.xldeploy.packager.io.SupportedArchiveExtensions$;
import com.xebialabs.xldeploy.packager.io.UnsupportedArchiveExtensionException;
import com.xebialabs.xldeploy.packager.io.ZipArchiveStreamStreamer;
import com.xebialabs.xldeploy.packager.io.ZipFileArchiveStreamer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dt!B\u000b\u0017\u0011\u0003\tc!B\u0012\u0017\u0011\u0003!\u0003\"B\u0016\u0002\t\u0003a\u0003\u0002C\u0017\u0002\u0005\u0004%\t!\u0001\u0018\t\r]\n\u0001\u0015!\u00030\u0011\u0015A\u0014\u0001\"\u0001:\u0011\u001d\t\t&\u0001C\u0001\u0003'2Aa\t\f\u0001w!AAh\u0002B\u0001B\u0003%Q\b\u0003\u0005L\u000f\t\u0005\t\u0015!\u0003I\u0011!auA!A!\u0002\u0013A\u0005\"B\u0016\b\t\u0003i\u0005BB)\bA\u0013%!\u000b\u0003\u0004`\u000f\u0011\u0005a\u0003\u0019\u0005\u0006Q\u001e!\t!\u001b\u0005\u0007u\u001e\u0001K\u0011B>\t\u000f\u0005]q\u0001\"\u0001\u0002\u001a!9\u00111E\u0004\u0005\u0002\u0005\u0015\u0002\"CA\u0018\u000fE\u0005I\u0011AA\u0019\u0011\u001d\t\u0019c\u0002C\u0001\u0003\u000fB\u0001\"a\u0013\bA\u0013%\u0011QJ\u0001\u0010'R\u0014X-Y7fe\u001a\u000b7\r^8ss*\u0011q\u0003G\u0001\u0003S>T!!\u0007\u000e\u0002\u0011A\f7m[1hKJT!a\u0007\u000f\u0002\u0011adG-\u001a9m_fT!!\b\u0010\u0002\u0013a,'-[1mC\n\u001c(\"A\u0010\u0002\u0007\r|Wn\u0001\u0001\u0011\u0005\t\nQ\"\u0001\f\u0003\u001fM#(/Z1nKJ4\u0015m\u0019;pef\u001c\"!A\u0013\u0011\u0005\u0019JS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011%\u0001\u0004m_\u001e<WM]\u000b\u0002_A\u0011\u0001'N\u0007\u0002c)\u0011!gM\u0001\u0006g24GG\u001b\u0006\u0002i\u0005AqM]5{u2,G-\u0003\u00027c\t1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%A\beK\u001a\fW\u000f\u001c;NCB\u0004\u0018N\\4t)\u0005Q\u0004C\u0001\u0012\b'\t9Q%A\bbe\u000eD\u0017N^3NCB\u0004\u0018N\\4t!\u0011qT\t\u0013%\u000f\u0005}\u001a\u0005C\u0001!(\u001b\u0005\t%B\u0001\"!\u0003\u0019a$o\\8u}%\u0011AiJ\u0001\u0007!J,G-\u001a4\n\u0005\u0019;%aA'ba*\u0011Ai\n\t\u0003}%K!AS$\u0003\rM#(/\u001b8h\u0003-Q\u0018\u000e]#oG>$\u0017N\\4\u0002\u0017)\f'/\u00128d_\u0012Lgn\u001a\u000b\u0005u9{\u0005\u000bC\u0003=\u0017\u0001\u0007Q\bC\u0003L\u0017\u0001\u0007\u0001\nC\u0003M\u0017\u0001\u0007\u0001*A\fhKR\f%o\u00195jm\u0016,e\u000e\u001e:z'R\u0014X-Y7feR\u00111K\u0016\t\u0003EQK!!\u0016\f\u0003\u0011M#(/Z1nKJDQa\u0016\u0007A\u0002a\u000bAAZ5mKB\u0011\u0011,X\u0007\u00025*\u0011qc\u0017\u0006\u00029\u0006!!.\u0019<b\u0013\tq&L\u0001\u0003GS2,\u0017!H4fi\u0006\u00138\r[5wK\u0016sGO]=TiJ,\u0017-\\*ue\u0016\fW.\u001a:\u0015\u0007M\u000bg\rC\u0003c\u001b\u0001\u00071-\u0001\u0002jgB\u0011\u0011\fZ\u0005\u0003Kj\u00131\"\u00138qkR\u001cFO]3b[\")q-\u0004a\u0001\u0011\u0006!a.Y7f\u0003Y9W\r^!sG\"Lg/Z(viB,Ho\u0015;sK\u0006lGC\u00016y!\tYg/D\u0001m\u0015\tig.A\u0005be\u000eD\u0017N^3sg*\u0011q\u000e]\u0001\tG>l\u0007O]3tg*\u0011\u0011O]\u0001\bG>lWn\u001c8t\u0015\t\u0019H/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002k\u0006\u0019qN]4\n\u0005]d'aE!sG\"Lg/Z(viB,Ho\u0015;sK\u0006l\u0007\"B=\u000f\u0001\u0004A\u0016A\u0002;be\u001e,G/A\rhKR$\u0016M]!sG\"Lg/Z(viB,Ho\u0015;sK\u0006lG#\u0002?\u0002\u0006\u0005\u001d\u0001cA?\u0002\u00025\taP\u0003\u0002\u0000Y\u0006\u0019A/\u0019:\n\u0007\u0005\raP\u0001\fUCJ\f%o\u00195jm\u0016|U\u000f\u001e9viN#(/Z1n\u0011\u0015Ix\u00021\u0001Y\u0011\u001d\tIa\u0004a\u0001\u0003\u0017\t!bY8naJ,7o]8s!\u001d1\u0013QBA\t\u0003#I1!a\u0004(\u0005%1UO\\2uS>t\u0017\u0007E\u0002Z\u0003'I1!!\u0006[\u00051yU\u000f\u001e9viN#(/Z1n\u0003MA\u0017m]!sG\"Lg/Z#yi\u0016t7/[8o)\u0011\tY\"!\t\u0011\u0007\u0019\ni\"C\u0002\u0002 \u001d\u0012qAQ8pY\u0016\fg\u000eC\u0003h!\u0001\u0007\u0001*\u0001\u0005tiJ,\u0017-\\3s)\u001d\u0019\u0016qEA\u0015\u0003WAQAY\tA\u0002\rDQaZ\tA\u0002!C\u0011\"!\f\u0012!\u0003\u0005\r!a\u0007\u0002\u0013%\u001c\u0018I]2iSZ,\u0017AE:ue\u0016\fW.\u001a:%I\u00164\u0017-\u001e7uIM*\"!a\r+\t\u0005m\u0011QG\u0016\u0003\u0003o\u0001B!!\u000f\u0002D5\u0011\u00111\b\u0006\u0005\u0003{\ty$A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011I\u0014\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002F\u0005m\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dKR\u00191+!\u0013\t\u000b]\u001b\u0002\u0019\u0001-\u0002\u001d\u001d,G/\u0011:dQ&4X\rV=qKR\u0019\u0001*a\u0014\t\u000b\u001d$\u0002\u0019\u0001%\u0002\u0013\u0019|'oQ8oM&<Gc\u0001\u001e\u0002V!9\u0011q\u000b\u0004A\u0002\u0005e\u0013AB2p]\u001aLw\r\u0005\u0003\u0002\\\u0005\rTBAA/\u0015\u0011\t9&a\u0018\u000b\u0007\u0005\u0005d$\u0001\u0005usB,7/\u00194f\u0013\u0011\t)'!\u0018\u0003\r\r{gNZ5h\u0001")
public class StreamerFactory {
    private final Map<String, String> archiveMappings;
    private final String zipEncoding;
    private final String jarEncoding;

    public static StreamerFactory forConfig(Config config) {
        return StreamerFactory$.MODULE$.forConfig(config);
    }

    public static StreamerFactory defaultMappings() {
        return StreamerFactory$.MODULE$.defaultMappings();
    }

    private Streamer getArchiveEntryStreamer(File file) {
        Streamer streamer;
        String mappedExt = this.getArchiveType(file.getName());
        boolean extOK = BoxesRunTime.unboxToBoolean((Object)TryWith$.MODULE$.apply((Function0 & Serializable)() -> ArtifactIOUtils$.MODULE$.getResettableInputStream(new FileInputStream(file)), (Function1 & Serializable)resettableIs -> BoxesRunTime.boxToBoolean((boolean)SupportedArchiveExtensions$.MODULE$.archiveTypeMatchesExtension(resettableIs, mappedExt, file.getName()))).get());
        String string = mappedExt;
        if (!extOK) {
            streamer = new EmptyStreamer();
        } else {
            String string2 = SupportedArchiveExtensions$.MODULE$.ZIP();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                streamer = new ZipFileArchiveStreamer(file, this.zipEncoding);
            } else {
                String string4 = SupportedArchiveExtensions$.MODULE$.JAR();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    streamer = new JarFileArchiveStreamer(file, this.jarEncoding);
                } else {
                    String string6 = SupportedArchiveExtensions$.MODULE$.TAR();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        streamer = new ArchiveStreamer(file, (Function1<InputStream, InputStream>)(Function1 & Serializable)is -> is);
                    } else {
                        String string8 = SupportedArchiveExtensions$.MODULE$.TARGZ();
                        String string9 = string;
                        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                            streamer = new ArchiveStreamer(file, (Function1<InputStream, InputStream>)(Function1 & Serializable)is -> new GzipCompressorInputStream(is));
                        } else {
                            String string10 = SupportedArchiveExtensions$.MODULE$.TARBZ2();
                            String string11 = string;
                            if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                                streamer = new ArchiveStreamer(file, (Function1<InputStream, InputStream>)(Function1 & Serializable)is -> new BZip2CompressorInputStream(is));
                            } else {
                                throw new MatchError((Object)string);
                            }
                        }
                    }
                }
            }
        }
        return streamer;
    }

    public Streamer getArchiveEntryStreamStreamer(InputStream is2, String name) {
        Streamer streamer;
        String mappedExt = this.getArchiveType(name);
        InputStream resettableIs = ArtifactIOUtils$.MODULE$.getResettableInputStream(is2);
        boolean extOK = SupportedArchiveExtensions$.MODULE$.archiveTypeMatchesExtension(resettableIs, mappedExt, name);
        String string = mappedExt;
        if (!extOK) {
            streamer = new EmptyStreamer();
        } else {
            String string2 = SupportedArchiveExtensions$.MODULE$.ZIP();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                streamer = new ZipArchiveStreamStreamer(resettableIs, this.zipEncoding);
            } else {
                String string4 = SupportedArchiveExtensions$.MODULE$.JAR();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    streamer = new JarArchiveStreamStreamer(resettableIs, this.jarEncoding);
                } else {
                    String string6 = SupportedArchiveExtensions$.MODULE$.TAR();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        streamer = new ArchiveStreamStreamer(resettableIs, (Function1<InputStream, InputStream>)(Function1 & Serializable)is -> is);
                    } else {
                        String string8 = SupportedArchiveExtensions$.MODULE$.TARGZ();
                        String string9 = string;
                        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                            streamer = new ArchiveStreamStreamer(resettableIs, (Function1<InputStream, InputStream>)(Function1 & Serializable)is -> new GzipCompressorInputStream(is));
                        } else {
                            String string10 = SupportedArchiveExtensions$.MODULE$.TARBZ2();
                            String string11 = string;
                            if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                                streamer = new ArchiveStreamStreamer(resettableIs, (Function1<InputStream, InputStream>)(Function1 & Serializable)is -> new BZip2CompressorInputStream(is));
                            } else {
                                throw new MatchError((Object)string);
                            }
                        }
                    }
                }
            }
        }
        return streamer;
    }

    public ArchiveOutputStream getArchiveOutputStream(File target) {
        ZipArchiveOutputStream zipArchiveOutputStream;
        String string = this.getArchiveType(target.getName());
        String string2 = SupportedArchiveExtensions$.MODULE$.ZIP();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            zipArchiveOutputStream = new ZipArchiveOutputStream(target);
        } else {
            String string4 = SupportedArchiveExtensions$.MODULE$.JAR();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                zipArchiveOutputStream = new ZipArchiveOutputStream(target);
            } else {
                String string6 = SupportedArchiveExtensions$.MODULE$.TAR();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    zipArchiveOutputStream = this.getTarArchiveOutputStream(target, (Function1<OutputStream, OutputStream>)(Function1 & Serializable)os -> os);
                } else {
                    String string8 = SupportedArchiveExtensions$.MODULE$.TARGZ();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        zipArchiveOutputStream = this.getTarArchiveOutputStream(target, (Function1<OutputStream, OutputStream>)(Function1 & Serializable)os -> new GzipCompressorOutputStream(os));
                    } else {
                        String string10 = SupportedArchiveExtensions$.MODULE$.TARBZ2();
                        String string11 = string;
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            zipArchiveOutputStream = this.getTarArchiveOutputStream(target, (Function1<OutputStream, OutputStream>)(Function1 & Serializable)os -> new BZip2CompressorOutputStream(os));
                        } else {
                            String originExt = (String)((Tuple2)this.archiveMappings.find((Function1 & Serializable)am -> BoxesRunTime.boxToBoolean((boolean)StreamerFactory.$anonfun$getArchiveOutputStream$4(target, am))).get())._1();
                            throw new UnsupportedArchiveExtensionException(new StringBuilder(59).append(target.getName()).append(" with extension ").append(originExt).append(" -> ").append(string).append(" is not a supported archive output type").toString());
                        }
                    }
                }
            }
        }
        return zipArchiveOutputStream;
    }

    private TarArchiveOutputStream getTarArchiveOutputStream(File target, Function1<OutputStream, OutputStream> compressor) {
        OutputStream wrapped = (OutputStream)compressor.apply((Object)new FileOutputStream(target));
        TarArchiveOutputStream os = new TarArchiveOutputStream(wrapped);
        os.setLongFileMode(3);
        os.setBigNumberMode(2);
        return os;
    }

    public boolean hasArchiveExtension(String name) {
        return this.archiveMappings.exists((Function1 & Serializable)am -> BoxesRunTime.boxToBoolean((boolean)name.endsWith(new StringBuilder(11).append('.').append((String)am._1()).toString())));
    }

    public Streamer streamer(InputStream is, String name, boolean isArchive) {
        return this.hasArchiveExtension(name) ? this.getArchiveEntryStreamStreamer(is, name) : (isArchive ? new ZipArchiveStreamStreamer(ArtifactIOUtils$.MODULE$.getResettableInputStream(is), this.zipEncoding) : new FileStreamStreamer(is, name));
    }

    public Streamer streamer(File file) {
        return file.isDirectory() ? new DirectoryStreamer(file) : (this.hasArchiveExtension(file.getName()) ? this.getArchiveEntryStreamer(file) : new FileStreamer(file));
    }

    public boolean streamer$default$3() {
        return false;
    }

    private String getArchiveType(String name) {
        Some some;
        Tuple2 tuple2;
        Option option = this.archiveMappings.find((Function1 & Serializable)am -> BoxesRunTime.boxToBoolean((boolean)name.endsWith(new StringBuilder(11).append('.').append((String)am._1()).toString())));
        if (None$.MODULE$.equals(option)) {
            throw new UnsupportedArchiveExtensionException(new StringBuilder(27).append(name).append(" is not a supported archive").toString());
        }
        if (!(option instanceof Some) || (tuple2 = (Tuple2)(some = (Some)option).value()) == null) {
            throw new MatchError((Object)option);
        }
        String originExt = (String)tuple2._1();
        String mappedExt = (String)tuple2._2();
        StreamerFactory$.MODULE$.logger().debug((Function0 & Serializable)() -> new StringBuilder(43).append("Detected mapped archive extension ").append(originExt).append(" -> ").append(mappedExt).append(" for ").append(name).toString());
        String string = mappedExt;
        return string;
    }

    public static final /* synthetic */ boolean $anonfun$getArchiveOutputStream$4(File target$1, Tuple2 am) {
        return target$1.getName().endsWith(new StringBuilder(11).append('.').append((String)am._1()).toString());
    }

    public StreamerFactory(Map<String, String> archiveMappings, String zipEncoding, String jarEncoding) {
        this.archiveMappings = archiveMappings;
        this.zipEncoding = zipEncoding;
        this.jarEncoding = jarEncoding;
    }
}

