/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.ssh.SshConnection;
import com.xebialabs.overthere.ssh.SshProcess;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.SocketFactory;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.direct.LocalPortForwarder;
import net.schmizz.sshj.connection.channel.direct.Parameters;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshTunnelConnection
extends SshConnection
implements AddressPortMapper {
    private static final AtomicReference<TunnelPortManager> PORT_MANAGER = new AtomicReference<TunnelPortManager>(new TunnelPortManager());
    private static final int MAX_PORT = 65535;
    private Map<InetSocketAddress, InetSocketAddress> localPortForwards = new HashMap<InetSocketAddress, InetSocketAddress>();
    private List<PortForwarder> portForwarders = new ArrayList<PortForwarder>();
    private int startPortRange;
    private final ReentrantLock lock = new ReentrantLock();
    private static final Logger logger = LoggerFactory.getLogger(SshTunnelConnection.class);

    public SshTunnelConnection(String protocol, ConnectionOptions options, AddressPortMapper mapper) {
        super(protocol, options, mapper);
        this.startPortRange = options.getInteger("portAllocationRangeStart", 1024);
    }

    @Override
    protected void connect() {
        super.connect();
        OverthereUtils.checkState(this.sshClient != null, "Should have set an SSH client when connected", new Object[0]);
    }

    @Override
    public void doClose() {
        logger.debug("Closing tunnel.");
        for (PortForwarder portForwarder : this.portForwarders) {
            OverthereUtils.closeQuietly(portForwarder);
        }
        super.doClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InetSocketAddress map(InetSocketAddress address) {
        this.lock.lock();
        try {
            if (this.localPortForwards.containsKey(address)) {
                InetSocketAddress inetSocketAddress = this.localPortForwards.get(address);
                return inetSocketAddress;
            }
            ServerSocket serverSocket = PORT_MANAGER.get().bindToNextFreePort(this.startPortRange);
            this.portForwarders.add(this.startForwarder(address, serverSocket));
            InetSocketAddress localAddress = InetSocketAddress.createUnresolved("localhost", serverSocket.getLocalPort());
            this.localPortForwards.put(address, localAddress);
            InetSocketAddress inetSocketAddress = localAddress;
            return inetSocketAddress;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public SocketFactory socketFactory() {
        return SocketFactory.getDefault();
    }

    private PortForwarder startForwarder(InetSocketAddress remoteAddress, ServerSocket serverSocket) {
        PortForwarder forwarderThread = new PortForwarder(this.sshClient, remoteAddress, serverSocket);
        logger.info("Starting {}", (Object)forwarderThread.getName());
        forwarderThread.start();
        try {
            forwarderThread.latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return forwarderThread;
    }

    @Override
    public OverthereFile getFile(String hostPath) throws RuntimeIOException {
        throw new UnsupportedOperationException("Cannot get a file from the tunnel.");
    }

    @Override
    public OverthereProcess startProcess(CmdLine commandLine) {
        throw new UnsupportedOperationException("Cannot start a process on the tunnel.");
    }

    @Override
    protected CmdLine processCommandLine(CmdLine cmd) {
        throw new UnsupportedOperationException("Cannot process a command line for the tunnel.");
    }

    @Override
    protected SshProcess createProcess(Session session, CmdLine commandLine) throws TransportException, ConnectionException {
        throw new UnsupportedOperationException("Cannot create a process in the tunnel.");
    }

    @Override
    public void setWorkingDirectory(OverthereFile workingDirectory) {
        throw new UnsupportedOperationException("Cannot set a working directory on the tunnel.");
    }

    @Override
    public OverthereFile getWorkingDirectory() {
        throw new UnsupportedOperationException("Cannot get a working directory from the tunnel.");
    }

    @Override
    public int execute(OverthereExecutionOutputHandler stdoutHandler, OverthereExecutionOutputHandler stderrHandler, CmdLine commandLine) {
        throw new UnsupportedOperationException("Cannot execute a command on the tunnel.");
    }

    static class TunnelPortManager {
        private AtomicInteger lastBoundPort = new AtomicInteger(0);
        private ReentrantLock lock = new ReentrantLock();

        TunnelPortManager() {
        }

        ServerSocket bindToNextFreePort(int startFrom) {
            this.lock.lock();
            try {
                int firstPort;
                int port = firstPort = Math.max(startFrom, this.lastBoundPort.get() + 1);
                do {
                    logger.trace("Trying to bind to port {}", (Object)port);
                    ServerSocket socket = this.tryBind(port);
                    if (socket != null) {
                        logger.debug("Successfully bound to port {}.", (Object)port);
                        this.lastBoundPort.set(port);
                        ServerSocket serverSocket = socket;
                        return serverSocket;
                    }
                    if (port == 65535) {
                        port = startFrom;
                        continue;
                    }
                    ++port;
                } while (port != firstPort);
                throw new IllegalStateException(String.format("Could not find a single free port in the range [%s-%s]...", startFrom, 65535));
            }
            finally {
                this.lock.unlock();
            }
        }

        protected ServerSocket tryBind(int localPort) {
            try {
                ServerSocket ss = new ServerSocket();
                ss.setReuseAddress(true);
                ss.bind(new InetSocketAddress("localhost", localPort));
                return ss;
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    private static class PortForwarder
    extends Thread
    implements Closeable {
        private final SSHClient sshClient;
        private final InetSocketAddress remoteAddress;
        private final ServerSocket localSocket;
        private CountDownLatch latch = new CountDownLatch(1);
        private LocalPortForwarder forwarder;

        public PortForwarder(SSHClient sshClient, InetSocketAddress remoteAddress, ServerSocket localSocket) {
            super(PortForwarder.buildName(remoteAddress, localSocket.getLocalPort()));
            this.sshClient = sshClient;
            this.remoteAddress = remoteAddress;
            this.localSocket = localSocket;
        }

        private static String buildName(InetSocketAddress remoteAddress, Integer localPort) {
            return String.format("SSH local port forward thread %d:%s", localPort, remoteAddress.toString());
        }

        @Override
        public void run() {
            Parameters params = new Parameters("localhost", this.localSocket.getLocalPort(), this.remoteAddress.getHostName(), this.remoteAddress.getPort());
            this.forwarder = this.sshClient.newLocalPortForwarder(params, this.localSocket);
            try {
                this.latch.countDown();
                this.forwarder.listen();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void close() throws IOException {
            this.forwarder.close();
            this.localSocket.close();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

