/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.script;

import org.rzo.yajsw.os.OperatingSystem;
import org.rzo.yajsw.os.Process;
import org.rzo.yajsw.script.AbstractScript;
import org.rzo.yajsw.wrapper.WrappedProcess;

public class ShellScript
extends AbstractScript {
    volatile Process p = null;

    public ShellScript(String script, String id, WrappedProcess process, String[] args, int timeout, int maxConcInvocations) {
        super("scripts/" + script, id, process, args, timeout, maxConcInvocations);
    }

    @Override
    public Object execute(String line) {
        String id = this._id;
        String state = this._process != null ? this._process.getStringState() : "?";
        String count = this._process != null ? "" + this._process.getRestartCount() : "?";
        String pid = this._process != null ? "" + this._process.getAppPid() : "?";
        String exitCode = this._process != null ? "" + this._process.getExitCode() : "?";
        try {
            this.p = OperatingSystem.instance().processManagerInstance().createProcess();
            this.p.setCommand(this.getScript() + " " + id + " " + state + " " + count + " " + pid + " " + exitCode);
            this.p.setPipeStreams(false, false);
            this.p.start();
            this.p.waitFor(this.getTimeout());
            if (this.p.isRunning()) {
                this.p.kill(999);
            }
            if (this.p.getExitCode() != 0) {
                System.out.println("script " + this.getScript() + "returned " + this.p.getExitCode());
            }
            this.p.destroy();
            this.p = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    @Override
    public Object execute() {
        return this.execute("");
    }

    @Override
    public void executeWithTimeout() {
    }

    @Override
    public void interrupt() {
        if (this.p != null) {
            this.p.destroy();
        }
    }

    @Override
    void log(String msg) {
        if (this._process != null && this._process.getInternalWrapperLogger() != null) {
            this._process.getInternalWrapperLogger().info(msg);
        } else {
            System.out.println(msg);
        }
    }
}

